/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui;

import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.CustomFileFilter;
import com.kingdee.bos.ctrl.common.util.ExceptionUtil;
import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class WindowUtil {
    public static final Dimension SIZE_640_480 = new Dimension(640, 480);
    public static final Dimension SIZE_800_600 = new Dimension(800, 600);
    public static final Dimension SIZE_1024_768 = new Dimension(1024, 768);

    private WindowUtil() {
    }

    public static Object createWindow(Class wndCls, Component owner) {
        if (owner != null) {
            do {
                if (owner instanceof Frame) {
                    return ObjectUtil.createObject((Class)wndCls, (Class[])new Class[]{Frame.class}, (Object[])new Object[]{owner});
                }
                if (!(owner instanceof Dialog)) continue;
                return ObjectUtil.createObject((Class)wndCls, (Class[])new Class[]{Dialog.class}, (Object[])new Object[]{owner});
            } while ((owner = owner.getParent()) != null);
        }
        try {
            return wndCls.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void msgboxInfo(Object message, String title, Component parentComponent) {
        MessageDialog.show((Component)parentComponent, (Object)message, (String)title, (int)-1, (int)1);
    }

    public static void msgboxWarning(Object message, String title, Component parentComponent) {
        MessageDialog.show((Component)parentComponent, (Object)message, (String)title, (int)-1, (int)2);
    }

    public static int msgboxError(Object message, String title, Component parentComponent) {
        return MessageDialog.show((Component)parentComponent, (Object)message, (String)title, (int)-1, (int)0);
    }

    public static int msgbox(Component parentComponent, Object message, String title, int optionType, int messageType) {
        return MessageDialog.show((Component)parentComponent, (Object)message, (String)title, (int)optionType, (int)messageType);
    }

    public static boolean msgboxYesNo(Component parentComponent, Object message, String title) {
        return 0 == MessageDialog.show((Component)parentComponent, (Object)message, (String)title, (int)0, (int)3);
    }

    public static int msgboxYesNoCancel(Component parentComponent, Object message, String title) {
        return MessageDialog.show((Component)parentComponent, (Object)message, (String)title, (int)1, (int)3);
    }

    public static void alert(Component parentComponent, String message) {
        MessageDialog.show((Component)parentComponent, (Object)message, (String)"\u63d0\u793a", (int)-1);
    }

    public static File chooseOpenFile(Component owner, String initPath, String[] extFilters) {
        return WindowUtil.chooseFile(true, 0, owner, initPath, extFilters);
    }

    public static File chooseOpenDirectory(Component owner, String initPath, String[] extFilters) {
        return WindowUtil.chooseFile(true, 1, owner, initPath, extFilters);
    }

    public static File chooseSaveFile(Component owner, String initPath, String[] extFilters) {
        return WindowUtil.chooseFile(false, 0, owner, initPath, extFilters);
    }

    public static File chooseSaveDirectory(Component owner, String initPath, String[] extFilters) {
        return WindowUtil.chooseFile(false, 1, owner, initPath, extFilters);
    }

    public static File chooseFile(boolean isOpen, int mode, Component owner, String initPath, String[] extFilters) {
        int ret;
        KDFileChooser fc = new KDFileChooser();
        if (initPath != null) {
            fc.setSelectedFile(new File(initPath));
        }
        if (extFilters != null) {
            int i;
            FileFilter[] ff = fc.getChoosableFileFilters();
            for (i = 0; i < ff.length; ++i) {
                fc.removeChoosableFileFilter(ff[i]);
            }
            for (i = 0; i < extFilters.length; ++i) {
                fc.setFileFilter((FileFilter)new CustomFileFilter(extFilters[i]));
            }
        }
        fc.setFileSelectionMode(mode);
        int n = ret = isOpen ? fc.showOpenDialog(owner) : fc.showSaveDialog(owner);
        if (ret == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static void makeCneterBounds(Window wnd) {
        Rectangle rc = new Rectangle(wnd.getBounds());
        Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
        rc.x = (sz.width - rc.width) / 2;
        rc.y = (sz.height - rc.height) / 2;
        wnd.setBounds(rc);
    }

    public static void showComponent(Component cp) {
        KDFrame frame = new KDFrame();
        frame.getContentPane().add(cp);
        frame.pack();
        frame.show();
    }

    public static boolean showSimpleDialog(Component c, Component owner, String title, Dimension size) {
        SimpleDialog dialog = (SimpleDialog)((Object)WindowUtil.createWindow(SimpleDialog.class, owner));
        dialog.setTitle(title);
        dialog.setComponent(c);
        if (size != null) {
            dialog.setSize(size);
        }
        return dialog.showDialog();
    }

    public static void showException(String msg, Throwable ex, String title, Component owner) {
        String detail = ExceptionUtil.makeTrace((Throwable)ex);
        MessageDialog.show((Component)owner, (Object)msg, (String)title, (int)-1, (int)0, (String)detail);
    }

    public static Rectangle getDesktopBounds(GraphicsConfiguration gc) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle desktopBounds = new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom);
        return desktopBounds;
    }

    public static void makeDialogFullScreen(KDDialog dlg) {
        Rectangle desktopBounds = WindowUtil.getDesktopBounds(dlg.getOwner().getGraphicsConfiguration());
        dlg.setLocation(desktopBounds.x, desktopBounds.y);
        dlg.setSize(desktopBounds.width, desktopBounds.height);
        dlg.validate();
        dlg.repaint();
    }
}

