/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render;

import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.kdf.util.render.IExtBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.UIManager;

public class CurrencyEditorRenderer {

    public static class Body
    implements IExtBasicRender {
        private int leftPerGrid;
        private int rightPerGrid;
        private int brokenGridCount;
        private Rectangle[] cloudyRects;
        private Rectangle[] clearRects;
        private int brokenPosition = -1;
        private int leftWidth;
        private int rightWidth;
        private static int CLOUDY_BROKEN_GRID = 0;
        private static int CLEAR_BROKEN_GRID = 1;
        private int integerDigitCount = 15;
        private int decimalDigitCount = 2;
        private int x;
        private int y;
        private int width;
        private int height;
        private BigDecimal value;
        private boolean needCompromiseForTableCell = true;

        public Body() {
        }

        public Body(int integerDigitCount, int decimalDigitCount) {
            this.integerDigitCount = integerDigitCount;
            this.decimalDigitCount = decimalDigitCount;
        }

        @Override
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            if (object instanceof String) {
                try {
                    this.value = new BigDecimal((String)object);
                }
                catch (Throwable t) {
                    this.value = null;
                }
            } else {
                this.value = object instanceof BigDecimal ? (BigDecimal)object : null;
            }
            Rectangle rect = clip.getBounds();
            if (this.needCompromiseForTableCell) {
                this.x = rect.x - 1;
                this.y = rect.y - 1;
                this.width = rect.width + 1;
                this.height = rect.height + 1;
            } else {
                this.x = rect.x;
                this.y = rect.y;
                this.width = rect.width;
                this.height = rect.height;
            }
            Color oldColor = graphics.getColor();
            graphics.setColor(Color.black);
            this.paintCloudAndLines(graphics);
            if (this.value != null) {
                this.paintNumbers(graphics);
            }
            graphics.setColor(oldColor);
        }

        public void setCompromiseForTableCell(boolean b) {
            this.needCompromiseForTableCell = b;
        }

        public boolean isCompromiseForTableCell() {
            return this.needCompromiseForTableCell;
        }

        /*
         * Unable to fully structure code
         */
        protected void paintCloudAndLines(Graphics g) {
            this.calculateAndInit();
            oldColor = g.getColor();
            temp = UIManager.getColor("CurrencyEditor.lightGrayCloudColor");
            cloudColor = new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), 200);
            chiliarchBorderColor = UIManager.getColor("CurrencyEditor.chiliarchBorderColor");
            normalSeparatorColor = UIManager.getColor("CurrencyEditor.normalSeparatorColor");
            horizontalBorderColor = UIManager.getColor("CurrencyEditor.horizontalBorderColor");
            g.setColor(horizontalBorderColor);
            g.drawLine(this.x, this.y, this.x + this.width, this.y);
            g.drawLine(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height - 1);
            g.setColor(chiliarchBorderColor);
            g.drawLine(this.x, this.y, this.x, this.y + this.height - 1);
            g.drawLine(this.x + this.width - 1, this.y, this.x + this.width - 1, this.y + this.height - 1);
            block8: for (i = this.cloudyRects.length - 1; i >= 0; --i) {
                rect = this.cloudyRects[i];
                g.setColor(cloudColor);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
                g.setColor(chiliarchBorderColor);
                g.drawLine(rect.x, rect.y - 1, rect.x, rect.y + rect.height);
                if (i == 0) {
                    radixSeparatorColor = UIManager.getColor("CurrencyEditor.radixSeparatorColor");
                    g.setColor(radixSeparatorColor);
                }
                g.drawLine(rect.x + rect.width, rect.y - 1, rect.x + rect.width, rect.y + rect.height);
                g.setColor(normalSeparatorColor);
                if (i != this.cloudyRects.length - 1 || this.brokenGridCount == 0 || this.brokenPosition != Body.CLOUDY_BROKEN_GRID) ** GOTO lbl-1000
                switch (this.brokenGridCount) {
                    case 1: {
                        continue block8;
                    }
                    case 2: {
                        g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                        continue block8;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                        g.drawLine(rect.x + this.leftPerGrid * 2, rect.y - 1, rect.x + this.leftPerGrid * 2, rect.y + rect.height);
                    }
                }
            }
            block9: for (i = this.clearRects.length - 1; i >= 0; --i) {
                rect = this.clearRects[i];
                g.setColor(normalSeparatorColor);
                if (i != this.clearRects.length - 1 || this.brokenGridCount == 0 || this.brokenPosition != Body.CLEAR_BROKEN_GRID) ** GOTO lbl-1000
                switch (this.brokenGridCount) {
                    case 1: {
                        continue block9;
                    }
                    case 2: {
                        g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                        continue block9;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                        g.drawLine(rect.x + this.leftPerGrid * 2, rect.y - 1, rect.x + this.leftPerGrid * 2, rect.y + rect.height);
                    }
                }
            }
            for (i = 1; i < this.decimalDigitCount; ++i) {
                g.drawLine(this.x + this.leftWidth - 1 + this.rightPerGrid * i, this.y, this.x + this.leftWidth - 1 + this.rightPerGrid * i, this.y + this.height - 1);
            }
            g.setColor(oldColor);
        }

        protected void paintNumbers(Graphics g) {
            int i;
            Shape oldClip = g.getClip();
            Color oldColor = g.getColor();
            int sign = this.value.signum();
            if (sign < 0) {
                g.setColor(UIManager.getColor("CurrencyEditor.negativeColor"));
            }
            String temp = Util.bigDecimalToPlainString((BigDecimal)this.value);
            String[] temps = temp.split("\\.");
            String integerDigits = temps[0];
            String decimalDigits = temps.length == 2 ? temps[1] : "";
            Font oldFont = g.getFont();
            g.setFont(new Font("DIALOG", 1, 14));
            for (i = integerDigits.length(); i > 0; --i) {
                int position;
                if (i == 1 && sign < 0 || (position = this.integerDigitCount - integerDigits.length() + i - 1) < 0) continue;
                String charValue = new String(new char[]{integerDigits.charAt(i - 1)});
                int baseX = this.leftPerGrid * position;
                int baseY = 0;
                int baseWidth = this.leftPerGrid;
                int baseHeight = this.height;
                g.setClip(this.x + baseX, this.y + baseY, baseWidth, baseHeight);
                g.drawString(charValue, this.x + baseX + baseWidth / 3, this.y + baseY + baseHeight / 2 + g.getFontMetrics().getLeading() + g.getFontMetrics().getDescent());
            }
            for (i = 0; i < this.decimalDigitCount; ++i) {
                String charValue = i < decimalDigits.length() ? new String(new char[]{decimalDigits.charAt(i)}) : "0";
                int baseX = this.leftPerGrid * this.integerDigitCount + this.rightPerGrid * i;
                int baseY = 0;
                int baseWidth = this.rightPerGrid;
                int baseHeight = this.height;
                g.setClip(this.x + baseX, this.y + baseY, baseWidth, baseHeight);
                g.drawString(charValue, this.x + baseX + baseWidth / 4, this.y + baseY + baseHeight / 2 + g.getFontMetrics().getLeading() + g.getFontMetrics().getDescent());
            }
            g.setFont(oldFont);
            g.setColor(oldColor);
            g.setClip(oldClip);
        }

        public void setIntegerDigitCount(int integerDigitCount) {
            this.integerDigitCount = integerDigitCount;
        }

        public void setDecimalDigitCount(int decimalDigitCount) {
            this.decimalDigitCount = decimalDigitCount;
        }

        public int getIntegerDigitCount() {
            return this.integerDigitCount;
        }

        public int getDecimalDigitCount() {
            return this.decimalDigitCount;
        }

        private void calculateAndInit() {
            int i;
            this.leftPerGrid = Math.round((float)this.width * 1.0f / (float)(this.integerDigitCount + this.decimalDigitCount));
            this.leftWidth = this.leftPerGrid * this.integerDigitCount;
            this.rightWidth = this.width - this.leftWidth;
            this.rightPerGrid = Math.round((float)this.rightWidth * 1.0f / (float)this.decimalDigitCount);
            int footPrint = this.leftPerGrid * 3;
            this.brokenGridCount = this.integerDigitCount % 3;
            int iterativeCount = this.brokenGridCount == 0 ? this.integerDigitCount / 3 : this.integerDigitCount / 3 + 1;
            ArrayList<Rectangle> cloudyCollector = new ArrayList<Rectangle>();
            ArrayList<Rectangle> clearCollector = new ArrayList<Rectangle>();
            boolean mark = true;
            for (i = iterativeCount; i > 0; --i) {
                Rectangle rect;
                if (mark) {
                    if (i == 1 && this.brokenGridCount != 0) {
                        rect = new Rectangle(this.x, this.y + 1, this.brokenGridCount * this.leftPerGrid, this.height - 2);
                        this.brokenPosition = CLOUDY_BROKEN_GRID;
                    } else {
                        rect = new Rectangle(this.x + this.leftWidth - footPrint * (iterativeCount - i + 1), this.y + 1, footPrint, this.height - 2);
                    }
                    cloudyCollector.add(rect);
                    mark = false;
                    continue;
                }
                if (i == 1 && this.brokenGridCount != 0) {
                    rect = new Rectangle(this.x, this.y + 1, this.brokenGridCount * this.leftPerGrid, this.height - 2);
                    this.brokenPosition = CLEAR_BROKEN_GRID;
                } else {
                    rect = new Rectangle(this.x + this.leftWidth - footPrint * (iterativeCount - i + 1), this.y + 1, footPrint, this.height - 2);
                }
                clearCollector.add(rect);
                mark = true;
            }
            this.cloudyRects = new Rectangle[cloudyCollector.size()];
            for (i = 0; i < cloudyCollector.size(); ++i) {
                this.cloudyRects[i] = (Rectangle)cloudyCollector.get(i);
            }
            this.clearRects = new Rectangle[clearCollector.size()];
            for (i = 0; i < clearCollector.size(); ++i) {
                this.clearRects[i] = (Rectangle)clearCollector.get(i);
            }
        }

        @Override
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle, Object extObject) {
            this.draw(graphics, clip, object, cellStyle);
        }

        @Override
        public boolean isClip() {
            return false;
        }

        @Override
        public boolean isDrawBorder() {
            return true;
        }

        @Override
        public boolean isFillBackground() {
            return false;
        }
    }

    public static class Title
    implements IExtBasicRender {
        private int leftPerGrid;
        private int rightPerGrid;
        private int brokenGridCount;
        private Rectangle[] cloudyRects;
        private Rectangle[] clearRects;
        private int brokenPosition = -1;
        private int leftWidth;
        private int rightWidth;
        private static int CLOUDY_BROKEN_GRID = 0;
        private static int CLEAR_BROKEN_GRID = 1;
        private int integerDigitCount = 15;
        private int decimalDigitCount = 2;
        private int x;
        private int y;
        private int width;
        private int height;
        private boolean needCompromiseForTableCell = true;

        public Title() {
        }

        public Title(int integerDigitCount, int decimalDigitCount) {
            this.integerDigitCount = integerDigitCount;
            this.decimalDigitCount = decimalDigitCount;
        }

        @Override
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            Rectangle rect = clip.getBounds();
            if (this.needCompromiseForTableCell) {
                this.x = rect.x - 1;
                this.y = rect.y - 1;
                this.width = rect.width + 2;
                this.height = rect.height + 2;
            } else {
                this.x = rect.x;
                this.y = rect.y;
                this.width = rect.width;
                this.height = rect.height;
            }
            Color oldColor = graphics.getColor();
            graphics.setColor(Color.black);
            this.paintCloudAndLines(graphics);
            this.paintStrings(graphics);
            graphics.setColor(oldColor);
        }

        public void setCompromiseForTableCell(boolean b) {
            this.needCompromiseForTableCell = b;
        }

        public boolean isCompromiseForTableCell() {
            return this.needCompromiseForTableCell;
        }

        /*
         * Unable to fully structure code
         */
        protected void paintCloudAndLines(Graphics g) {
            this.calculateAndInit();
            oldColor = g.getColor();
            chiliarchBorderColor = UIManager.getColor("CurrencyEditor.chiliarchBorderColor");
            normalSeparatorColor = UIManager.getColor("CurrencyEditor.normalSeparatorColor");
            g.setColor(chiliarchBorderColor);
            g.drawLine(this.x, this.y, this.x, this.y + this.height - 1);
            if (this.isCompromiseForTableCell()) {
                g.drawLine(this.x + this.width - 2, this.y, this.x + this.width - 2, this.y + this.height - 1);
            } else {
                g.drawLine(this.x + this.width - 1, this.y, this.x + this.width - 1, this.y + this.height - 1);
            }
            block8: for (i = this.cloudyRects.length - 1; i >= 0; --i) {
                rect = this.cloudyRects[i];
                g.setColor(chiliarchBorderColor);
                g.drawLine(rect.x, rect.y - 1, rect.x, rect.y + rect.height);
                if (i == 0) {
                    radixSeparatorColor = UIManager.getColor("CurrencyEditor.radixSeparatorColor");
                    g.setColor(radixSeparatorColor);
                }
                g.drawLine(rect.x + rect.width, rect.y - 1, rect.x + rect.width, rect.y + rect.height);
                g.setColor(normalSeparatorColor);
                if (i != this.cloudyRects.length - 1 || this.brokenGridCount == 0 || this.brokenPosition != Title.CLOUDY_BROKEN_GRID) ** GOTO lbl-1000
                switch (this.brokenGridCount) {
                    case 1: {
                        continue block8;
                    }
                    case 2: {
                        g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                        continue block8;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                        g.drawLine(rect.x + this.leftPerGrid * 2, rect.y - 1, rect.x + this.leftPerGrid * 2, rect.y + rect.height);
                    }
                }
            }
            block9: for (i = this.clearRects.length - 1; i >= 0; --i) {
                rect = this.clearRects[i];
                g.setColor(normalSeparatorColor);
                if (i != this.clearRects.length - 1 || this.brokenGridCount == 0 || this.brokenPosition != Title.CLEAR_BROKEN_GRID) ** GOTO lbl-1000
                switch (this.brokenGridCount) {
                    case 1: {
                        continue block9;
                    }
                    case 2: {
                        g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                        continue block9;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                        g.drawLine(rect.x + this.leftPerGrid * 2, rect.y - 1, rect.x + this.leftPerGrid * 2, rect.y + rect.height);
                    }
                }
            }
            for (i = 1; i < this.decimalDigitCount; ++i) {
                g.drawLine(this.x + this.leftWidth - 1 + this.rightPerGrid * i, this.y, this.x + this.leftWidth - 1 + this.rightPerGrid * i, this.y + this.height - 1);
            }
            g.setColor(oldColor);
        }

        protected void paintStrings(Graphics g) {
            int i;
            Shape oldClip = g.getClip();
            Color oldColor = g.getColor();
            String temp = "\u5343\u767e\u5341\u4ebf\u5343\u767e\u5341\u4e07\u5343\u767e\u5341\u5143.\u89d2\u5206";
            String[] temps = temp.split("\\.");
            String integerDigits = temps[0];
            String decimalDigits = temps.length == 2 ? temps[1] : "";
            for (i = integerDigits.length(); i > 0; --i) {
                int position = this.integerDigitCount - integerDigits.length() + i - 1;
                if (position < 0) continue;
                String charValue = new String(new char[]{integerDigits.charAt(i - 1)});
                int baseX = this.leftPerGrid * position;
                int baseY = 0;
                int baseWidth = this.leftPerGrid;
                int baseHeight = this.height;
                g.setClip(this.x + baseX, this.y + baseY, baseWidth, baseHeight);
                g.drawString(charValue, this.x + baseX + baseWidth / 6, this.y + baseY + baseHeight / 2 + g.getFontMetrics().getLeading() + g.getFontMetrics().getDescent());
            }
            for (i = 0; i < this.decimalDigitCount && i < decimalDigits.length(); ++i) {
                String charValue = new String(new char[]{decimalDigits.charAt(i)});
                int baseX = this.leftPerGrid * this.integerDigitCount + this.rightPerGrid * i;
                int baseY = 0;
                int baseWidth = this.rightPerGrid;
                int baseHeight = this.height;
                g.setClip(this.x + baseX, this.y + baseY, baseWidth, baseHeight);
                g.drawString(charValue, this.x + baseX + baseWidth / 6, this.y + baseY + baseHeight / 2 + g.getFontMetrics().getLeading() + g.getFontMetrics().getDescent());
            }
            g.setColor(oldColor);
            g.setClip(oldClip);
        }

        public void setIntegerDigitCount(int integerDigitCount) {
            this.integerDigitCount = integerDigitCount;
        }

        public void setDecimalDigitCount(int decimalDigitCount) {
            this.decimalDigitCount = decimalDigitCount;
        }

        public int getIntegerDigitCount() {
            return this.integerDigitCount;
        }

        public int getDecimalDigitCount() {
            return this.decimalDigitCount;
        }

        private void calculateAndInit() {
            int i;
            this.leftPerGrid = Math.round((float)this.width * 1.0f / (float)(this.integerDigitCount + this.decimalDigitCount));
            this.leftWidth = this.leftPerGrid * this.integerDigitCount;
            this.rightWidth = this.width - this.leftWidth;
            this.rightPerGrid = Math.round((float)this.rightWidth * 1.0f / (float)this.decimalDigitCount);
            int footPrint = this.leftPerGrid * 3;
            this.brokenGridCount = this.integerDigitCount % 3;
            int iterativeCount = this.brokenGridCount == 0 ? this.integerDigitCount / 3 : this.integerDigitCount / 3 + 1;
            ArrayList<Rectangle> cloudyCollector = new ArrayList<Rectangle>();
            ArrayList<Rectangle> clearCollector = new ArrayList<Rectangle>();
            boolean mark = true;
            for (i = iterativeCount; i > 0; --i) {
                Rectangle rect;
                if (mark) {
                    if (i == 1 && this.brokenGridCount != 0) {
                        rect = new Rectangle(this.x, this.y + 1, this.brokenGridCount * this.leftPerGrid, this.height - 2);
                        this.brokenPosition = CLOUDY_BROKEN_GRID;
                    } else {
                        rect = new Rectangle(this.x + this.leftWidth - footPrint * (iterativeCount - i + 1), this.y + 1, footPrint, this.height - 2);
                    }
                    cloudyCollector.add(rect);
                    mark = false;
                    continue;
                }
                if (i == 1 && this.brokenGridCount != 0) {
                    rect = new Rectangle(this.x, this.y + 1, this.brokenGridCount * this.leftPerGrid, this.height - 2);
                    this.brokenPosition = CLEAR_BROKEN_GRID;
                } else {
                    rect = new Rectangle(this.x + this.leftWidth - footPrint * (iterativeCount - i + 1), this.y + 1, footPrint, this.height - 2);
                }
                clearCollector.add(rect);
                mark = true;
            }
            this.cloudyRects = new Rectangle[cloudyCollector.size()];
            for (i = 0; i < cloudyCollector.size(); ++i) {
                this.cloudyRects[i] = (Rectangle)cloudyCollector.get(i);
            }
            this.clearRects = new Rectangle[clearCollector.size()];
            for (i = 0; i < clearCollector.size(); ++i) {
                this.clearRects[i] = (Rectangle)clearCollector.get(i);
            }
        }

        @Override
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle, Object extObject) {
            this.draw(graphics, clip, object, cellStyle);
        }

        @Override
        public boolean isClip() {
            return false;
        }

        @Override
        public boolean isDrawBorder() {
            return true;
        }

        @Override
        public boolean isFillBackground() {
            return false;
        }
    }
}

