/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.style.styledesigner;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.MultiColorListCellRenderer;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.MultiColorListElement;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.StyleDesigner;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.packing.IStylePane;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FormatPane
extends KDPanel
implements IStylePane {
    private static final long serialVersionUID = -5734959572718864152L;
    private StyleAttributes sa;
    private KDList lstFormatItem;
    private CardLayout cardLayout = new CardLayout();
    private KDPanel panCard = new KDPanel((LayoutManager)this.cardLayout);
    private KDTextArea txaPrompt = new KDTextArea();
    private KDSpinner spnDecimal = new KDSpinner();
    private KDCheckBox chkKilo = new KDCheckBox();
    private KDComboBox cmbMoney;
    private KDSpinner spnWidth = new KDSpinner();
    private KDList lstNegative;
    private KDLabelContainer lbcNegative;
    private KDList lstDateType;
    private KDList lstTimeType;
    private KDList lstSpecialType;
    private KDTextField txtCustom = new KDTextField();
    private HashMap mapItem2InCardType = new HashMap();
    private HashMap mapItem2Prompt = new HashMap();
    private HashMap mapDate2FmtStr = new HashMap();
    private HashMap mapFmtStr2Date = new HashMap();
    private HashMap mapTime2FmtStr = new HashMap();
    private HashMap mapFmtStr2Time = new HashMap();
    private HashMap mapSpecial2FmtStr = new HashMap();
    private HashMap mapFmtStr2Special = new HashMap();
    private String[] allMoney = new String[]{"\uffe5", "$", "US$", "\u20ac", "\u00a3"};
    private static final String ITEM_NORMAL = FormatPane.getMLS("itemNormal", "\u5e38\u89c4");
    private static final String ITEM_NUMBER = FormatPane.getMLS("itemNumber", "\u6570\u503c");
    private static final String ITEM_MONEY = FormatPane.getMLS("itemMoney", "\u8d27\u5e01");
    private static final String ITEM_ACCOUNT = FormatPane.getMLS("itemAccountant", "\u4f1a\u8ba1");
    private static final String ITEM_PERCENT = FormatPane.getMLS("itemPercent", "\u767e\u5206\u6570");
    private static final String ITEM_SCIENCE = FormatPane.getMLS("itemScience", "\u79d1\u5b66\u8bb0\u6570");
    private static final String ITEM_DATE = FormatPane.getMLS("itemDate", "\u65e5\u671f");
    private static final String ITEM_TIME = FormatPane.getMLS("itemTime", "\u65f6\u95f4");
    private static final String ITEM_TEXT = FormatPane.getMLS("itemText", "\u6587\u672c");
    private static final String ITEM_SPECIAL = FormatPane.getMLS("itemSpecial", "\u7279\u6b8a");
    private static final String ITEM_CUSTOM = FormatPane.getMLS("itemCustom", "\u81ea\u5b9a\u4e49");
    private boolean flagIsShowValueFireMe;

    public FormatPane() {
        this.initCompoments();
        this.installCompoments();
        this.installListener();
    }

    @Override
    public void setSA(StyleAttributes sa) {
        this.flagIsShowValueFireMe = true;
        this.sa = sa;
        this.showValue();
        this.flagIsShowValueFireMe = false;
    }

    private void initCompoments() {
        Object[] allItem = new String[]{ITEM_NORMAL, ITEM_NUMBER, ITEM_MONEY, ITEM_ACCOUNT, ITEM_PERCENT, ITEM_SCIENCE, ITEM_DATE, ITEM_TIME, ITEM_TEXT, ITEM_SPECIAL, ITEM_CUSTOM};
        this.mapItem2InCardType.put(ITEM_NORMAL, "normal");
        this.mapItem2InCardType.put(ITEM_NUMBER, "number");
        this.mapItem2InCardType.put(ITEM_MONEY, "number");
        this.mapItem2InCardType.put(ITEM_ACCOUNT, "number");
        this.mapItem2InCardType.put(ITEM_PERCENT, "number");
        this.mapItem2InCardType.put(ITEM_SCIENCE, "number");
        this.mapItem2InCardType.put(ITEM_DATE, "date");
        this.mapItem2InCardType.put(ITEM_TIME, "time");
        this.mapItem2InCardType.put(ITEM_TEXT, "string");
        this.mapItem2InCardType.put(ITEM_SPECIAL, "special");
        this.mapItem2InCardType.put(ITEM_CUSTOM, "custom");
        this.mapItem2Prompt.put(ITEM_NORMAL, FormatPane.getMLS("promptNormal", ""));
        this.mapItem2Prompt.put(ITEM_NUMBER, FormatPane.getMLS("promptNumber", ""));
        this.mapItem2Prompt.put(ITEM_MONEY, FormatPane.getMLS("promptMoney", ""));
        this.mapItem2Prompt.put(ITEM_ACCOUNT, FormatPane.getMLS("promptAccountant", ""));
        this.mapItem2Prompt.put(ITEM_PERCENT, FormatPane.getMLS("promptPercent", ""));
        this.mapItem2Prompt.put(ITEM_SCIENCE, FormatPane.getMLS("promptScience", ""));
        this.mapItem2Prompt.put(ITEM_DATE, FormatPane.getMLS("promptDate", ""));
        this.mapItem2Prompt.put(ITEM_TIME, FormatPane.getMLS("promptTime", ""));
        this.mapItem2Prompt.put(ITEM_TEXT, FormatPane.getMLS("promptText", ""));
        this.mapItem2Prompt.put(ITEM_SPECIAL, FormatPane.getMLS("promptSpecial", ""));
        this.mapItem2Prompt.put(ITEM_CUSTOM, FormatPane.getMLS("promptCustom", ""));
        this.lstFormatItem = new KDList(allItem);
        this.initNegativeList();
        String[][] allDate = new String[][]{{"2004\u5e746\u670830\u65e5", "%r{yyyy\u5e74M\u6708d\u65e5}t"}, {"2004\u5e746\u6708", "%r{yyyy\u5e74M\u6708}t"}, {"6\u670830\u65e5", "%r{M\u6708d\u65e5}t"}, {"2004-6-30", "%r{yyyy-M-d}t"}, {"04-6-30", "%r{yy-M-d}t"}, {"6-30", "%r{M-d}t"}, {"2004-6-30 2:30 PM", "%r{yyyy-M-d H:mm a}t"}, {"2004-6-30 14:30", "%r{yyyy-M-d h:mm}t"}, {"6/30/2004", "%r{M/d/yyyy}t"}, {"6/30/04", "%r{M/d/yy}t"}};
        Object[] tempStr = new String[allDate.length];
        for (int i = allDate.length - 1; i >= 0; --i) {
            this.mapDate2FmtStr.put(allDate[i][0], allDate[i][1]);
            this.mapFmtStr2Date.put(allDate[i][1], allDate[i][0]);
            tempStr[i] = allDate[i][0];
        }
        this.lstDateType = new KDList(tempStr);
        this.lstDateType.setSelectedIndex(0);
        String[][] allTime = new String[][]{{"14:30", "%r{H:mm}t"}, {"2:30 PM", "%r{h:mm a}t"}, {"14:30:00", "%r{H:mm:ss}t"}, {"2:30:00 PM", "%r{h:mm:ss a}t"}, {"14\u65f630\u5206", "%r{H\u65f6mm\u5206}t"}, {"14\u65f630\u520600\u79d2", "%r{H\u65f6mm\u5206ss\u79d2}t"}};
        tempStr = new String[allTime.length];
        for (int i = allTime.length - 1; i >= 0; --i) {
            this.mapTime2FmtStr.put(allTime[i][0], allTime[i][1]);
            this.mapFmtStr2Time.put(allTime[i][1], allTime[i][0]);
            tempStr[i] = allTime[i][0];
        }
        this.lstTimeType = new KDList(tempStr);
        this.lstTimeType.setSelectedIndex(0);
        String[][] allSpecial = new String[][]{{"\u90ae\u653f\u7f16\u7801", "%r{000000}d"}, {"\u7b80\u4f53\u4e2d\u6587\u5927\u5199", "$UPPERCHSNUM"}, {"\u7b80\u4f53\u4e2d\u6587\u5c0f\u5199", "$LOWERCHSNUM"}, {"\u7e41\u4f53\u4e2d\u6587\u5927\u5199", "$UPPERCHTNUM"}, {"\u7e41\u4f53\u4e2d\u6587\u5c0f\u5199", "$LOWERCHTNUM"}};
        tempStr = new String[allSpecial.length];
        for (int i = allSpecial.length - 1; i >= 0; --i) {
            this.mapSpecial2FmtStr.put(allSpecial[i][0], allSpecial[i][1]);
            this.mapFmtStr2Special.put(allSpecial[i][1], allSpecial[i][0]);
            tempStr[i] = allSpecial[i][0];
        }
        this.lstSpecialType = new KDList(tempStr);
        this.lstSpecialType.setSelectedIndex(0);
        this.cmbMoney = new KDComboBox((Object[])this.allMoney);
        this.cmbMoney.setSelectedIndex(0);
        this.txaPrompt.setOpaque(false);
        this.txaPrompt.setEditable(false);
        this.txaPrompt.setBorder(BorderFactory.createEmptyBorder());
        this.spnDecimal.setModel((SpinnerModel)new SpinnerNumberModel(2, 0, 30, 1));
        this.spnWidth.setModel((SpinnerModel)new SpinnerNumberModel(12, 0, 999, 1));
        this.panCard.setOpaque(false);
        this.txtCustom.setEnabledPopup(false);
    }

    private void initNegativeList() {
        this.lstNegative = new KDList();
        this.lstNegative.setCellRenderer((ListCellRenderer)((Object)new MultiColorListCellRenderer()));
        Negative element = new Negative();
        element.setElement("-123456");
        element.setHaveBracket(false);
        element.setHaveMinus(true);
        this.lstNegative.addElement((Object)element);
        element = new Negative();
        element.setElement("-123456");
        element.setHaveBracket(false);
        element.setHaveMinus(true);
        element.setForegroud(Color.RED);
        this.lstNegative.addElement((Object)element);
        element = new Negative();
        element.setElement("123456");
        element.setHaveBracket(false);
        element.setHaveMinus(false);
        element.setForegroud(Color.RED);
        this.lstNegative.addElement((Object)element);
        element = new Negative();
        element.setElement("(123456)");
        element.setHaveBracket(true);
        element.setHaveMinus(false);
        this.lstNegative.addElement((Object)element);
        element = new Negative();
        element.setElement("(123456)");
        element.setHaveBracket(true);
        element.setHaveMinus(false);
        element.setForegroud(Color.RED);
        this.lstNegative.addElement((Object)element);
    }

    private void installCompoments() {
        KDPanel panInCardNormal = new KDPanel(null);
        KDPanel panInCardString = new KDPanel(null);
        KDPanel panInCardNumber = new KDPanel(null);
        KDPanel panInCardDate = new KDPanel(null);
        KDPanel panInCardTime = new KDPanel(null);
        KDPanel panInCardSpecial = new KDPanel(null);
        KDPanel panInCardCustom = new KDPanel(null);
        panInCardNormal.setOpaque(false);
        panInCardString.setOpaque(false);
        panInCardNumber.setOpaque(false);
        panInCardDate.setOpaque(false);
        panInCardTime.setOpaque(false);
        panInCardSpecial.setOpaque(false);
        panInCardCustom.setOpaque(false);
        this.panCard.add((Component)panInCardNormal, (Object)"normal");
        this.panCard.add((Component)panInCardString, (Object)"string");
        this.panCard.add((Component)panInCardNumber, (Object)"number");
        this.panCard.add((Component)panInCardDate, (Object)"date");
        this.panCard.add((Component)panInCardTime, (Object)"time");
        this.panCard.add((Component)panInCardSpecial, (Object)"special");
        this.panCard.add((Component)panInCardCustom, (Object)"custom");
        KDScrollPane scpFormatItem = new KDScrollPane((Component)this.lstFormatItem);
        scpFormatItem.setVerticalScrollBarPolicy(22);
        scpFormatItem.getVerticalScrollBar().setEnabled(false);
        KDScrollPane scpDateType = new KDScrollPane((Component)this.lstDateType);
        scpDateType.setVerticalScrollBarPolicy(22);
        KDScrollPane scpTimeType = new KDScrollPane((Component)this.lstTimeType);
        scpTimeType.setVerticalScrollBarPolicy(22);
        scpTimeType.getVerticalScrollBar().setEnabled(false);
        KDScrollPane scpSpecialType = new KDScrollPane((Component)this.lstSpecialType);
        scpSpecialType.setVerticalScrollBarPolicy(22);
        scpSpecialType.getVerticalScrollBar().setEnabled(false);
        KDScrollPane scpNegative = new KDScrollPane((Component)this.lstNegative);
        scpNegative.setVerticalScrollBarPolicy(22);
        KDLabelContainer lbcFormatItem = new KDLabelContainer((JComponent)scpFormatItem);
        lbcFormatItem.setBoundLabelText(FormatPane.getMLS("formatItem", "\u5206\u7c7b"));
        lbcFormatItem.setBoundLabelAlignment(8);
        lbcFormatItem.setBoundLabelLength(20);
        KDLabelContainer lbcDateType = new KDLabelContainer((JComponent)scpDateType);
        lbcDateType.setBoundLabelText(FormatPane.getMLS("formatType", "\u7c7b\u578b"));
        lbcDateType.setBoundLabelAlignment(8);
        lbcDateType.setBoundLabelLength(20);
        KDLabelContainer lbcTimeType = new KDLabelContainer((JComponent)scpTimeType);
        lbcTimeType.setBoundLabelText(FormatPane.getMLS("formatType", "\u7c7b\u578b"));
        lbcTimeType.setBoundLabelAlignment(8);
        lbcTimeType.setBoundLabelLength(20);
        KDLabelContainer lbcSpecialType = new KDLabelContainer((JComponent)scpSpecialType);
        lbcSpecialType.setBoundLabelText(FormatPane.getMLS("formatType", "\u7c7b\u578b"));
        lbcSpecialType.setBoundLabelAlignment(8);
        lbcSpecialType.setBoundLabelLength(20);
        KDLabelContainer lbcDecimal = new KDLabelContainer((JComponent)this.spnDecimal);
        lbcDecimal.setBoundLabelText(FormatPane.getMLS("decimalDigits", "\u5c0f\u6570\u4f4d\u6570"));
        lbcDecimal.setBoundLabelLength(80);
        lbcDecimal.setBoundLabelUnderline(true);
        KDLabelContainer lbcMoney = new KDLabelContainer((JComponent)this.cmbMoney);
        lbcMoney.setBoundLabelText(FormatPane.getMLS("moneySymbol", "\u8d27\u5e01\u7b26\u53f7"));
        lbcMoney.setBoundLabelLength(80);
        lbcMoney.setBoundLabelUnderline(true);
        KDLabelContainer lbcWidth = new KDLabelContainer((JComponent)this.spnWidth);
        lbcWidth.setBoundLabelText(FormatPane.getMLS("formatWidth", "\u5bbd\u5ea6"));
        lbcWidth.setBoundLabelLength(80);
        lbcWidth.setBoundLabelUnderline(true);
        this.chkKilo.setText(FormatPane.getMLS("kiloSeparator", "\u5343\u4f4d\u5206\u9694\u7b26\uff08\uff0c\uff09"));
        KDLabelContainer lbcCustom = new KDLabelContainer((JComponent)this.txtCustom);
        lbcCustom.setBoundLabelText(FormatPane.getMLS("formatString", "\u683c\u5f0f\u5316\u4e32"));
        lbcCustom.setBoundLabelAlignment(8);
        lbcCustom.setBoundLabelLength(20);
        this.lbcNegative = new KDLabelContainer((JComponent)scpNegative);
        this.lbcNegative.setBoundLabelText(FormatPane.getMLS("negative", "\u8d1f\u6570"));
        this.lbcNegative.setBoundLabelLength(20);
        this.lbcNegative.setBoundLabelAlignment(8);
        panInCardNumber.add((Component)lbcDecimal);
        panInCardNumber.add((Component)this.chkKilo);
        panInCardNumber.add((Component)lbcMoney);
        panInCardNumber.add((Component)lbcWidth);
        panInCardNumber.add((Component)this.lbcNegative);
        panInCardDate.add((Component)lbcDateType);
        panInCardTime.add((Component)lbcTimeType);
        panInCardSpecial.add((Component)lbcSpecialType);
        panInCardCustom.add((Component)lbcCustom);
        this.add((Component)lbcFormatItem);
        this.add((Component)this.panCard);
        this.add((Component)this.txaPrompt);
        this.setLayout(null);
        lbcFormatItem.setBounds(10, 10, 140, 270);
        this.panCard.setBounds(160, 10, 290, 180);
        this.txaPrompt.setBounds(160, 220, 290, 60);
        lbcDecimal.setBounds(20, 20, 160, 21);
        this.chkKilo.setBounds(20, 50, 160, 21);
        lbcMoney.setBounds(20, 50, 160, 21);
        lbcWidth.setBounds(20, 80, 160, 21);
        this.lbcNegative.setBounds(20, 80, 160, 100);
        lbcDateType.setBounds(0, 0, 290, 160);
        lbcTimeType.setBounds(0, 0, 290, 160);
        lbcSpecialType.setBounds(0, 0, 290, 160);
        lbcCustom.setBounds(0, 20, 290, 41);
    }

    public Dimension getPreferredSize() {
        return new Dimension(454, 290);
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.txtCustom.addFocusListener((FocusListener)actionHandler);
        this.lstFormatItem.addListSelectionListener((ListSelectionListener)actionHandler);
        this.lstDateType.addListSelectionListener((ListSelectionListener)actionHandler);
        this.lstTimeType.addListSelectionListener((ListSelectionListener)actionHandler);
        this.lstSpecialType.addListSelectionListener((ListSelectionListener)actionHandler);
        this.lstNegative.addListSelectionListener((ListSelectionListener)actionHandler);
        this.spnDecimal.addChangeListener((ChangeListener)actionHandler);
        this.spnWidth.addChangeListener((ChangeListener)actionHandler);
        this.chkKilo.addActionListener((ActionListener)actionHandler);
        this.cmbMoney.addActionListener((ActionListener)actionHandler);
    }

    private void showValue() {
        if (this.sa.isUnsureValue(StyleAttributes.NUMBER_FORMAT)) {
            this.lstFormatItem.setSelectedIndex(-1);
        } else {
            String strMoney;
            String strFormat = this.sa.getNumberFormat();
            if (strFormat == null || "".equals(strFormat)) {
                this.lstFormatItem.setSelectedIndex(0);
                return;
            }
            if (strFormat.equals("%l{@}s")) {
                this.lstFormatItem.setSelectedValue((Object)ITEM_TEXT, true);
                return;
            }
            Object value = this.mapFmtStr2Special.get(strFormat);
            if (value != null) {
                this.lstFormatItem.setSelectedValue((Object)ITEM_SPECIAL, true);
                this.lstSpecialType.setSelectedValue(value, true);
                return;
            }
            value = this.mapFmtStr2Time.get(strFormat);
            if (value != null) {
                this.lstFormatItem.setSelectedValue((Object)ITEM_TIME, true);
                this.lstTimeType.setSelectedValue(value, true);
                return;
            }
            value = this.mapFmtStr2Date.get(strFormat);
            if (value != null) {
                this.lstFormatItem.setSelectedValue((Object)ITEM_DATE, true);
                this.lstDateType.setSelectedValue(value, true);
                return;
            }
            int negativeIndex = 0;
            String normalFormat = strFormat;
            if (strFormat.matches("^#-;.*;.*")) {
                String[] split = strFormat.split(";");
                if (split[1].matches("^\\[R\\]%r\\{.*\\}f$")) {
                    negativeIndex = 1;
                } else if (split[1].matches("^\\[R\\]%r_\\{\\(.*\\)\\}f$")) {
                    negativeIndex = 4;
                } else if (split[1].matches("^\\[R\\]%r_\\{.*\\}f$")) {
                    negativeIndex = 2;
                } else if (split[1].matches("^%r_\\{\\(.*\\)\\}f$")) {
                    negativeIndex = 3;
                }
                normalFormat = split[2];
            }
            if (normalFormat.matches("^%r\\{(#,##)?0(\\.00*)?\\}f$")) {
                this.lstFormatItem.setSelectedValue((Object)ITEM_NUMBER, true);
                int num = this.parseDecimalNum(normalFormat, "}");
                this.spnDecimal.setValue((Object)new Integer(num));
                if (normalFormat.indexOf("#,##") == -1) {
                    this.chkKilo.setSelected(false);
                } else {
                    this.chkKilo.setSelected(true);
                }
                this.lstNegative.setSelectedIndex(negativeIndex);
                return;
            }
            if (normalFormat.matches("^%r\\{.+#,##0(\\.00*)?\\}f$") && (strMoney = this.parseMoneySymbol(normalFormat, "#,##")) != null) {
                this.lstFormatItem.setSelectedValue((Object)ITEM_MONEY, true);
                this.cmbMoney.setSelectedItem((Object)strMoney);
                int num = this.parseDecimalNum(normalFormat, "}");
                this.spnDecimal.setValue((Object)new Integer(num));
                this.lstNegative.setSelectedIndex(negativeIndex);
                return;
            }
            if (strFormat.matches("^%r\\{.+\\*#,##0(\\.00*)?\\}\\d{1,3}f$") && (strMoney = this.parseMoneySymbol(strFormat, "*#,##")) != null) {
                this.lstFormatItem.setSelectedValue((Object)ITEM_ACCOUNT, true);
                this.cmbMoney.setSelectedItem((Object)strMoney);
                int num = this.parseDecimalNum(strFormat, "}");
                this.spnDecimal.setValue((Object)new Integer(num));
                int widthStart = strFormat.indexOf("}");
                int widthEnd = strFormat.length();
                String strWidth = strFormat.substring(widthStart + 1, widthEnd - 1);
                this.spnWidth.setValue((Object)new Integer(strWidth));
                return;
            }
            if (strFormat.matches("^%r\\{0(\\.00*)?\\}p$")) {
                this.lstFormatItem.setSelectedValue((Object)ITEM_PERCENT, true);
                int num = this.parseDecimalNum(strFormat, "}p");
                this.spnDecimal.setValue((Object)new Integer(num));
                return;
            }
            if (strFormat.matches("^%r\\.\\d+e$")) {
                this.lstFormatItem.setSelectedValue((Object)ITEM_SCIENCE, true);
                int num = Integer.parseInt(strFormat.substring(3, strFormat.length() - 1));
                this.spnDecimal.setValue((Object)new Integer(num));
                return;
            }
            this.lstFormatItem.setSelectedValue((Object)ITEM_CUSTOM, true);
            this.txtCustom.setText(strFormat);
        }
    }

    private String parseMoneySymbol(String strFormat, String strEndFlag) {
        int moneyStart = strFormat.indexOf("{");
        int moneyEnd = strFormat.indexOf(strEndFlag);
        String strMoney = strFormat.substring(moneyStart + 1, moneyEnd);
        for (int i = this.allMoney.length - 1; i >= 0; --i) {
            if (!strMoney.equals(this.allMoney[i])) continue;
            return strMoney;
        }
        return null;
    }

    private int parseDecimalNum(String strFormat, String strEndFlag) {
        int decimalStart = strFormat.indexOf("0.0");
        if (decimalStart == -1) {
            return 0;
        }
        int decimalEnd = strFormat.indexOf(strEndFlag);
        return decimalEnd - decimalStart - 2;
    }

    private static String getMLS(String key, String defaultValue) {
        return StyleDesigner.getMLS(key, defaultValue);
    }

    private class ActionHandler
    implements ListSelectionListener,
    ChangeListener,
    ActionListener,
    FocusListener {
        private ActionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource().equals(FormatPane.this.lstFormatItem)) {
                Object sltValue = FormatPane.this.lstFormatItem.getSelectedValue();
                if (sltValue == null) {
                    FormatPane.this.cardLayout.show((Container)FormatPane.this.panCard, FormatPane.this.mapItem2InCardType.get(ITEM_NORMAL).toString());
                    FormatPane.this.txaPrompt.setText("");
                    return;
                }
                String cardKey = FormatPane.this.mapItem2InCardType.get(sltValue).toString();
                FormatPane.this.cardLayout.show((Container)FormatPane.this.panCard, cardKey);
                FormatPane.this.chkKilo.setVisible(false);
                FormatPane.this.cmbMoney.getParent().setVisible(false);
                FormatPane.this.spnWidth.getParent().setVisible(false);
                FormatPane.this.lbcNegative.setVisible(false);
                if (sltValue.equals(ITEM_NUMBER)) {
                    FormatPane.this.chkKilo.setVisible(true);
                    FormatPane.this.lbcNegative.setVisible(true);
                } else if (sltValue.equals(ITEM_MONEY)) {
                    FormatPane.this.cmbMoney.getParent().setVisible(true);
                    FormatPane.this.lbcNegative.setVisible(true);
                } else if (sltValue.equals(ITEM_ACCOUNT)) {
                    FormatPane.this.cmbMoney.getParent().setVisible(true);
                    FormatPane.this.spnWidth.getParent().setVisible(true);
                } else if (sltValue.equals(ITEM_CUSTOM)) {
                    FormatPane.this.txtCustom.setText(FormatPane.this.sa.getNumberFormat());
                }
                FormatPane.this.txaPrompt.setText(FormatPane.this.mapItem2Prompt.get(sltValue).toString());
            }
            if (FormatPane.this.flagIsShowValueFireMe) {
                return;
            }
            String strFormat = this.getFmtStr();
            if (strFormat != null) {
                FormatPane.this.sa.setNumberFormat(strFormat);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (FormatPane.this.flagIsShowValueFireMe) {
                return;
            }
            String strFormat = this.getFmtStr();
            if (strFormat != null) {
                FormatPane.this.sa.setNumberFormat(strFormat);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FormatPane.this.flagIsShowValueFireMe) {
                return;
            }
            String strFormat = this.getFmtStr();
            if (strFormat != null) {
                FormatPane.this.sa.setNumberFormat(strFormat);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String strFormat = this.getFmtStr();
            if (strFormat != null) {
                FormatPane.this.sa.setNumberFormat(strFormat);
            }
        }

        private String getStrDecimal() {
            String strDecimal = "0";
            int decimal = Integer.parseInt(FormatPane.this.spnDecimal.getValue().toString());
            if (decimal > 0) {
                strDecimal = strDecimal + ".";
            }
            for (int i = 0; i < decimal; ++i) {
                strDecimal = strDecimal + "0";
            }
            return strDecimal;
        }

        private int getIntDecimal() {
            return Integer.parseInt(FormatPane.this.spnDecimal.getValue().toString());
        }

        private String getFmtStr() {
            Object sltValue = FormatPane.this.lstFormatItem.getSelectedValue();
            if (sltValue.equals(ITEM_SCIENCE)) {
                return "%r." + this.getIntDecimal() + "e";
            }
            if (sltValue.equals(ITEM_TEXT)) {
                return "%l{@}s";
            }
            if (sltValue.equals(ITEM_DATE)) {
                return FormatPane.this.mapDate2FmtStr.get(FormatPane.this.lstDateType.getSelectedValue()).toString();
            }
            if (sltValue.equals(ITEM_TIME)) {
                return FormatPane.this.mapTime2FmtStr.get(FormatPane.this.lstTimeType.getSelectedValue()).toString();
            }
            if (sltValue.equals(ITEM_SPECIAL)) {
                return FormatPane.this.mapSpecial2FmtStr.get(FormatPane.this.lstSpecialType.getSelectedValue()).toString();
            }
            if (sltValue.equals(ITEM_NORMAL)) {
                return "";
            }
            if (sltValue.equals(ITEM_CUSTOM)) {
                return FormatPane.this.txtCustom.getText();
            }
            StringBuffer sb = new StringBuffer();
            String strKilo = "#,##";
            String strDecimal = this.getStrDecimal();
            String strMoney = FormatPane.this.cmbMoney.getSelectedItem().toString();
            if (sltValue.equals(ITEM_ACCOUNT)) {
                sb.append("%r{");
                sb.append(strMoney);
                sb.append("*");
                sb.append("#,##");
                sb.append(strDecimal);
                sb.append("}");
                sb.append(FormatPane.this.spnWidth.getValue().toString());
                sb.append("f");
                return sb.toString();
            }
            if (sltValue.equals(ITEM_PERCENT)) {
                sb.append("%r{");
                sb.append(strDecimal);
                sb.append("}p");
                return sb.toString();
            }
            StringBuffer sb4Negative = new StringBuffer();
            Negative negative = (Negative)FormatPane.this.lstNegative.getSelectedValue();
            String leftBracket = null;
            String rightBracket = null;
            String noMinus = null;
            String red = null;
            if (negative != null) {
                leftBracket = negative.isHaveBracket() ? "(" : "";
                rightBracket = negative.isHaveBracket() ? ")" : "";
                noMinus = negative.isHaveMinus() ? "" : "_";
                String string = red = negative.getForegroud() == Color.RED ? "[R]" : "";
            }
            if (sltValue.equals(ITEM_NUMBER)) {
                sb.append("%r{");
                sb.append(FormatPane.this.chkKilo.isSelected() ? "#,##" : "");
                sb.append(strDecimal);
                sb.append("}f");
                if (!(negative == null || !negative.isHaveBracket() && negative.isHaveMinus() && StringUtil.isEmptyString((String)red))) {
                    sb4Negative.append("#-;");
                    sb4Negative.append(red);
                    sb4Negative.append("%r");
                    sb4Negative.append(noMinus);
                    sb4Negative.append("{");
                    sb4Negative.append(leftBracket);
                    sb4Negative.append(FormatPane.this.chkKilo.isSelected() ? "#,##" : "");
                    sb4Negative.append(strDecimal);
                    sb4Negative.append(rightBracket);
                    sb4Negative.append("}f;");
                }
                sb4Negative.append(sb.toString());
                return sb4Negative.toString();
            }
            if (sltValue.equals(ITEM_MONEY)) {
                sb.append("%r{");
                sb.append(strMoney);
                sb.append("#,##");
                sb.append(strDecimal);
                sb.append("}f");
                if (!(negative == null || !negative.isHaveBracket() && negative.isHaveMinus() && StringUtil.isEmptyString((String)red))) {
                    sb4Negative.append("#-;");
                    sb4Negative.append(red);
                    sb4Negative.append("%r");
                    sb4Negative.append(noMinus);
                    sb4Negative.append("{");
                    sb4Negative.append(leftBracket);
                    sb4Negative.append(strMoney);
                    sb4Negative.append("#,##");
                    sb4Negative.append(strDecimal);
                    sb4Negative.append(rightBracket);
                    sb4Negative.append("}f;");
                }
                sb4Negative.append(sb.toString());
                return sb4Negative.toString();
            }
            return null;
        }
    }

    private class Negative
    extends MultiColorListElement {
        private boolean isHaveMinus;
        private boolean isHaveBracket;

        private Negative() {
        }

        public boolean isHaveBracket() {
            return this.isHaveBracket;
        }

        public boolean isHaveMinus() {
            return this.isHaveMinus;
        }

        public void setHaveBracket(boolean b) {
            this.isHaveBracket = b;
        }

        public void setHaveMinus(boolean b) {
            this.isHaveMinus = b;
        }
    }
}

