/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.java.stat;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.res.tool.java.stat.JavaFileBean;
import com.kingdee.bos.ctrl.res.tool.java.stat.JavaFileStatInfo;
import com.kingdee.bos.ctrl.res.tool.java.stat.visitor.PKClassVisitor;
import com.kingdee.bos.ctrl.res.tool.java.stat.visitor.SystemIOStatementVisitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;

public class StatSystemIOFile
extends JPanel {
    private static final String CONFIG_FILE = "statIO.properties";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private boolean scaning = false;
    private JTextArea txtOut = new JTextArea();
    private JButton btnStat = new JButton("StatIO");
    private JTextField txtpath = new JTextField(50);
    private Properties pros = new Properties();

    public StatSystemIOFile() {
        this.initUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() {
        String scan_path;
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout(0, 5, 5));
        topPanel.add(new JLabel("\u6e90\u7801\u8def\u5f84\uff1a"));
        topPanel.add(this.txtpath);
        topPanel.add(this.btnStat);
        this.add((Component)topPanel, "North");
        this.add((Component)new JScrollPane(this.txtOut), "Center");
        this.btnStat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block6: {
                            String path = StatSystemIOFile.this.txtpath.getText().trim();
                            if (path.length() > 0) {
                                FileOutputStream out = null;
                                try {
                                    StatSystemIOFile.this.scaning = true;
                                    StatSystemIOFile.this.btnStat.setEnabled(false);
                                    StatSystemIOFile.this.pros.setProperty("scan_path", path);
                                    out = new FileOutputStream(StatSystemIOFile.CONFIG_FILE);
                                    StatSystemIOFile.this.pros.store(out, null);
                                    StatSystemIOFile.statIO(path);
                                    StatSystemIOFile.this.btnStat.setEnabled(true);
                                }
                                catch (Exception e) {
                                    e.printStackTrace(System.out);
                                    break block6;
                                }
                                finally {
                                    StatSystemIOFile.this.btnStat.setEnabled(true);
                                    StatSystemIOFile.this.scaning = false;
                                    StreamUtil.closeCloseable(out);
                                }
                                StatSystemIOFile.this.scaning = false;
                                StreamUtil.closeCloseable((Closeable)out);
                            }
                        }
                    }
                }.start();
            }
        });
        PrintStream ps = new PrintStream(new ByteArrayOutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                if (StatSystemIOFile.this.txtOut.getLineCount() > 500 && StatSystemIOFile.this.scaning) {
                    try {
                        int offset = StatSystemIOFile.this.txtOut.getLineEndOffset(StatSystemIOFile.this.txtOut.getLineCount() / 2 - 1);
                        StatSystemIOFile.this.txtOut.setText(StatSystemIOFile.this.txtOut.getText().substring(offset));
                    }
                    catch (Exception e) {
                        StatSystemIOFile.this.txtOut.setText(null);
                    }
                }
                SwingUtilities.invokeLater(new PrintMsgRunnable(new String(b, off, len)));
            }
        });
        System.setOut(ps);
        System.setErr(ps);
        FileInputStream in = null;
        try {
            in = new FileInputStream(CONFIG_FILE);
            this.pros.load(in);
            scan_path = this.pros.getProperty("scan_path", "W:\\workspace\\Ctrl-CommonUI\\src");
        }
        catch (Exception e) {
            try {
                scan_path = "W:\\workspace\\Ctrl-CommonUI\\src";
            }
            catch (Throwable throwable) {
                StreamUtil.closeCloseable(in);
                throw throwable;
            }
            StreamUtil.closeCloseable((Closeable)in);
        }
        StreamUtil.closeCloseable((Closeable)in);
        this.txtpath.setText(scan_path);
        this.txtOut.setEditable(false);
        this.txtOut.setText("\u7edf\u8ba1java\u6e90\u7801System.(out|err).print(ln)\u7684\u8f93\u51fa\uff0c\u5ffd\u7565main\u65b9\u6cd5\u90e8\u5206\u3002");
    }

    public static void center(Window w) {
        Dimension dd = Toolkit.getDefaultToolkit().getScreenSize();
        w.setLocation((dd.width - w.getWidth()) / 2, (dd.height - w.getHeight()) / 2);
    }

    public static JFrame run(Component c, String title) {
        JFrame f = new JFrame();
        f.setTitle(title);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add(c, "Center");
        f.setSize(800, 600);
        StatSystemIOFile.center(f);
        f.setDefaultCloseOperation(2);
        f.setVisible(true);
        return f;
    }

    public static JavaFileStatInfo scan(String fileName) throws Exception {
        System.out.println("Scan... " + fileName);
        JavaFileBean jfb = new JavaFileBean(fileName);
        if (!jfb.withError()) {
            jfb.accept(new PKClassVisitor());
            jfb.accept(new SystemIOStatementVisitor(false, "SystemIOUtil.println($)"));
            jfb.finishAccept();
        }
        return jfb.getJavaFileStatInfo();
    }

    private static JavaFileStatInfo[] scanPath(String path) throws Exception {
        List list = StatSystemIOFile.getJavaFileNameList(path);
        ArrayList<JavaFileStatInfo> infoList = new ArrayList<JavaFileStatInfo>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            infoList.add(StatSystemIOFile.scan((String)list.get(i)));
        }
        JavaFileStatInfo[] infos = new JavaFileStatInfo[infoList.size()];
        infoList.toArray(infos);
        return infos;
    }

    private static List getJavaFileNameList(String path) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        File f = new File(FilenameUtils.normalize((String)path));
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                list.addAll(StatSystemIOFile.getJavaFileNameList(fs[i].getAbsolutePath()));
            }
        } else if (path.endsWith(".java")) {
            list.add(path);
        }
        return list;
    }

    private static String getModelName(String pk) {
        char[] chs = pk.toCharArray();
        StringBuffer sb = new StringBuffer(chs.length);
        int dotCount = 0;
        for (char ch : chs) {
            if (ch == '.') {
                ++dotCount;
            }
            if (dotCount == 5) break;
            sb.append(ch);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void statIO(String f) throws Exception {
        JavaFileStatInfo[] fs = StatSystemIOFile.scanPath(f);
        StringBuilder s = new StringBuilder();
        int fcount = 0;
        int count = 0;
        TreeMap<String, int[]> authorMap = new TreeMap<String, int[]>();
        TreeMap<String, int[]> modelMap = new TreeMap<String, int[]>();
        for (int i = 0; i < fs.length; ++i) {
            int[] vv;
            String author;
            JavaFileStatInfo ff = fs[i];
            if (ff.getOtherWarningList().size() <= 0) continue;
            ++fcount;
            count += ff.getOtherWarningList().size();
            String string = author = ff.getAuthor() == null ? "unknow" : ff.getAuthor();
            if (authorMap.containsKey(author)) {
                vv = (int[])authorMap.get(author);
                vv[0] = vv[0] + 1;
                vv[1] = vv[1] + ff.getOtherWarningList().size();
            } else {
                vv = new int[]{1, ff.getOtherWarningList().size()};
            }
            authorMap.put(author, vv);
            String model = StatSystemIOFile.getModelName(ff.getPK());
            if (modelMap.containsKey(model)) {
                vv = (int[])modelMap.get(model);
                vv[0] = vv[0] + 1;
                vv[1] = vv[1] + ff.getOtherWarningList().size();
            } else {
                vv = new int[]{1, ff.getOtherWarningList().size()};
            }
            modelMap.put(model, vv);
            s.append("\r\n\u2605" + ff.getPK() + "." + ff.getCL() + "\r\n\u4f5c\u8005=" + author + ", \u521b\u5efa\u65f6\u95f4=" + ff.getCreateDate()).append(", \u8f93\u51fa\u5904=" + ff.getListFormatString(ff.getOtherWarningList(), true));
        }
        s.append("\r\n\r\n\u2605\u7edf\u8ba1: \u6587\u4ef6\u6570=" + fcount + ", \u6e90\u7801\u5757\u6570=" + count);
        s.append("\r\n\r\n\u2605\u6a21\u5757\u7edf\u8ba1\u5217\u8868(\u6587\u4ef6\u6570,\u5757\u6570)");
        for (String model : modelMap.keySet()) {
            int[] vv = (int[])modelMap.get(model);
            s.append("\r\n\t").append(model).append("\t=").append(vv[0] + "," + vv[1]);
        }
        s.append("\r\n\r\n\u2605\u4f5c\u8005\u7edf\u8ba1\u5217\u8868(\u6587\u4ef6\u6570,\u5757\u6570)");
        for (String author : authorMap.keySet()) {
            int[] vv = (int[])authorMap.get(author);
            s.append("\r\n\t").append(author).append("\t=").append(vv[0] + "," + vv[1]);
        }
        System.out.println(s);
        String of = f.replace('\\', '/');
        String[] ss = of.split("/");
        if (ss.length >= 2) {
            of = ss[ss.length - 2] + "_" + ss[ss.length - 1];
        }
        of = of.replace(':', '_');
        of = "statIO_" + of + ".txt";
        FileWriter w = null;
        BufferedWriter br = null;
        try {
            w = new FileWriter(FilenameUtils.normalize((String)of));
            br = new BufferedWriter(w);
            br.write("#" + sdf.format(new Date()) + "  " + f + "\r\n");
            br.write(s.toString());
            br.flush();
        }
        catch (Throwable throwable) {
            StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, w});
            throw throwable;
        }
        StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, w});
        System.out.println("Scan completed!");
    }

    public static void main(String[] args) throws Exception {
        StatSystemIOFile.run(new StatSystemIOFile(), "StatIO");
    }

    class PrintMsgRunnable
    implements Runnable {
        String msg;

        PrintMsgRunnable(String aMsg) {
            this.msg = aMsg;
        }

        @Override
        public void run() {
            if (StatSystemIOFile.this.scaning) {
                StatSystemIOFile.this.txtOut.append(this.msg);
                StatSystemIOFile.this.txtOut.setCaretPosition(StatSystemIOFile.this.txtOut.getDocument().getLength());
            }
        }
    }
}

