/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.scheme.ui;

import com.kingdee.bos.ctrl.common.ui.tree.ATreeController;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;

public class QueryTreeCtrl
extends ATreeController {
    private MetaClass[] schemas;
    private EventListenerList listenerList;

    public void initTreeUI(TreeUI treeUI) {
        super.initTreeUI(treeUI);
        treeUI.getTree().setRootVisible(false);
        treeUI.getTree().setShowsRootHandles(true);
    }

    public void setSchemes(MetaClass[] bss) {
        this.schemas = bss;
        this.updataQueryTree();
    }

    public MetaClass[] getSchemes() {
        if (this.schemas == null) {
            this.schemas = new MetaClass[0];
        }
        return this.schemas;
    }

    private void updataQueryTree() {
        TreeUINode root = this.getTreeUI().getRootNode();
        this.getTreeUI().removeAllChildrenNodes(root);
        for (int i = 0; i < this.getSchemes().length; ++i) {
            MetaClass scheme = this.getSchemes()[i];
            TreeUINode nodeScheme = new TreeUINode(scheme.getName());
            nodeScheme.setAlias(scheme.getAlias());
            nodeScheme.setUserObject((Object)scheme);
            this.getTreeUI().addChildNode(nodeScheme, root);
        }
        this.getTreeUI().expand(new TreePath(root));
    }

    public MetaField getSelectedField() {
        DefaultKingdeeTreeNode node;
        TreePath path = this.getTreeUI().getSelectionPath();
        if (path != null && (node = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject() instanceof MetaField) {
            return (MetaField)node.getUserObject();
        }
        return null;
    }

    public MetaClass getSchemeOfSelectedFieldIn() {
        DefaultKingdeeTreeNode node;
        TreePath path = this.getTreeUI().getSelectionPath();
        if (path != null && (node = (DefaultKingdeeTreeNode)(path = path.getParentPath()).getLastPathComponent()).getUserObject() instanceof MetaClass) {
            return (MetaClass)node.getUserObject();
        }
        return null;
    }

    private EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    protected void fireDoubleClickSelectEvent(Object source) {
        Object[] listeners = this.getListenerList().getListenerList();
        DoubleClickSelectEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DoubleClickSelectListener.class) continue;
            if (evt == null) {
                evt = new DoubleClickSelectEvent(source);
            }
            ((DoubleClickSelectListener)listeners[i + 1]).doubleClicked(evt);
        }
    }

    public void addDoubleClickSelectListener(DoubleClickSelectListener l) {
        this.getListenerList().add(DoubleClickSelectListener.class, l);
    }

    public void removeDoubleClickSelectListener(DoubleClickSelectListener l) {
        this.getListenerList().remove(DoubleClickSelectListener.class, l);
    }

    protected boolean initNode(TreePath treePath) {
        TreeUINode node = (TreeUINode)treePath.getLastPathComponent();
        if (node.getUserObject() instanceof MetaClass) {
            MetaClass scheme = (MetaClass)node.getUserObject();
            for (int j = 0; j < scheme.getFields().size(); ++j) {
                MetaField col = (MetaField)scheme.getFields().get(j);
                TreeUINode nodeCol = new TreeUINode(col.getName());
                nodeCol.setAlias(col.getAlias());
                nodeCol.setUserObject((Object)col);
                nodeCol.setAllowsChildren(false);
                this.getTreeUI().addChildNode(nodeCol, node);
            }
        }
        return true;
    }

    protected void onDoubleClick(MouseEvent evt, TreePath path) {
        this.fireDoubleClickSelectEvent((Object)this);
    }

    public class DoubleClickSelectEvent
    extends EventObject {
        public DoubleClickSelectEvent(Object source) {
            super(source);
        }
    }

    public static interface DoubleClickSelectListener
    extends EventListener {
        public void doubleClicked(DoubleClickSelectEvent var1);
    }
}

