/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.dataprocess;

import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.modal.DataDef;
import com.kingdee.bos.ctrl.data.modal.IDataDef;
import com.kingdee.bos.ctrl.data.modal.Import;
import com.kingdee.bos.ctrl.data.modal.Imports;
import com.kingdee.bos.ctrl.data.modal.Outputs;
import com.kingdee.bos.ctrl.data.modal.ProcessScript;
import com.kingdee.bos.ctrl.data.modal.io.DataDef2Meta;
import com.kingdee.bos.ctrl.data.modal.types.IDataSetTypeProvider;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.data.wizard.common.CommonFunction;
import com.kingdee.bos.ctrl.data.wizard.common.OutPutTable;
import com.kingdee.bos.ctrl.data.wizard.common.ParamPanel;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.DataCommonFunction;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.DataSetProcess;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.DataprocessResource;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.ImportSelector;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.WizardPane;
import com.kingdee.bos.ctrl.data.wizard.formula.FormulaWizardEditor;
import com.kingdee.bos.ctrl.data.wizard.process.DataDefEditorPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class DataProcessEditorPane
extends WizardPane {
    public static final Logger log = LogUtil.getPackageLogger(DataProcessEditorPane.class);
    private ParamPanel paramUI;
    private ImportSelector importSelector;
    private DataDefEditorPanel dataDefEditor;
    private DataSetProcess dataSetProcess;
    private OutPutTable outputEditor;
    private IObjectSelector provider;
    private boolean isRegularProcess = true;
    private IDataDef dataObj;

    public DataProcessEditorPane() {
        this.init();
    }

    private void init() {
        this.paramUI = DataCommonFunction.createParaEditor(this.tabbedPane);
        this.importSelector = DataCommonFunction.createImports(this.tabbedPane);
        this.dataDefEditor = DataCommonFunction.createDataSetProcess2(this.tabbedPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.installListener();
    }

    private void installListener() {
    }

    @Override
    protected void onTabbedChanged(int oldTabbed, int newTabbed) {
        Component obj = this.tabbedPane.getComponentAt(oldTabbed);
        if (obj instanceof WizardPane.CustomPane) {
            obj = ((WizardPane.CustomPane)((Object)obj)).getComponent(0);
        }
        if (obj == this.paramUI) {
            if (this.dataDefEditor != null) {
                this.dataDefEditor.updateParameters(this.paramUI.getParameters());
            }
            this.dataObj.setParameters(this.paramUI.getParameters());
        } else if (obj == this.importSelector) {
            if (!this.isRegularProcess) {
                this.updateInputNavigateMetas(this.outputEditor.getMetaClasses());
                if (this.dataSetProcess.isUseBeanShell()) {
                    this.updateImportOfFormula(this.dataSetProcess.getBsProcess().formula);
                }
                this.dataObj.setImports(this.importSelector.getImports());
            }
        } else if (obj == this.dataDefEditor || obj == this.dataSetProcess) {
            if (this.isRegularProcess) {
                this.dataObj = this.dataDefEditor.getDataDef();
                if (this.importSelector != null) {
                    this.importSelector.setProvider(this.provider);
                    this.importSelector.showValue(this.dataObj);
                }
            } else {
                this.dataSetProcess.updateDataObj(this.dataObj);
            }
        }
        OutputColumns output = this.outputEditor != null ? this.outputEditor.getOutputColumns() : new OutputColumns();
        this.dataObj.setOutputs(new Outputs((IDataSetTypeProvider)output));
    }

    protected void updateInputNavigateMetas(List list) {
        list.clear();
        Imports imports = this.importSelector.getImports();
        for (Import impt : imports) {
            Object obj = this.provider.getObject(impt.getExpr());
            if (obj == null || !(obj instanceof MetaClass)) continue;
            MetaClass mc = (MetaClass)obj;
            list.add(mc);
        }
    }

    protected void updateFieldSupplyTree(KDTree tree) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        tree.removeAllChildrenFromParent((MutableTreeNode)root);
        Imports imports = this.importSelector.getImports();
        for (Import impt : imports) {
            Object obj = this.provider.getObject(impt.getExpr());
            if (obj == null || !(obj instanceof MetaClass)) continue;
            MetaClass mc = (MetaClass)obj;
            DefaultKingdeeTreeNode parent = new DefaultKingdeeTreeNode((Object)impt);
            tree.addNodeInto((MutableTreeNode)parent, (MutableTreeNode)root);
            for (MetaField mf : mc.getFields()) {
                tree.addNodeInto((MutableTreeNode)new DefaultKingdeeTreeNode((Object)mf), (MutableTreeNode)parent);
            }
        }
        tree.expandAllNodes(true, (TreeNode)root);
    }

    protected void updateImportOfFormula(FormulaWizardEditor f) {
        Imports imports = this.importSelector.getImports();
        MetaClass[] mcs = new MetaClass[imports.size()];
        String[] names = new String[imports.size()];
        Iterator it = imports.iterator();
        int i = 0;
        while (it.hasNext()) {
            Import impt = (Import)it.next();
            names[i] = impt.getName();
            Object obj = this.provider.getObject(impt.getExpr());
            if (obj == null) {
                mcs[i] = null;
                continue;
            }
            if (obj instanceof MetaClass) {
                mcs[i] = (MetaClass)obj;
            }
            ++i;
        }
        f.getFieldSupplyGroup().updateImportSupplyGroup(names, mcs);
    }

    @Override
    protected void showValue() {
        this.importSelector.showValue(this.dataObj);
        this.paramUI.setParameters2(this.dataObj.getParameters());
        ProcessScript ps = this.dataObj.getProcessScript();
        if (ps != null && ps.isAutoMakeCalling() && !ps.isEmpty()) {
            try {
                this.dataDefEditor.setDataDef((DataDef)this.dataObj);
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
            }
        } else {
            this.tabbedPane.remove((Component)this.dataDefEditor.getParent());
            this.tabbedPane.remove((Component)this.importSelector.getParent());
            this.isRegularProcess = false;
            this.dataSetProcess = DataCommonFunction.createDataSetProcess(this.tabbedPane);
            this.outputEditor = CommonFunction.createOutputTable(this.tabbedPane);
            this.dataSetProcess.setDataObj(this.dataObj);
            if (this.dataObj.getOutputs() != null && this.dataObj.getOutputs().size() != 0) {
                this.outputEditor.setMetaClass(DataDef2Meta.parseDataObject((IDataDef)this.dataObj));
            }
            this.updateInputNavigateMetas(this.outputEditor.getMetaClasses());
            if (this.dataSetProcess.isUseBeanShell()) {
                this.updateImportOfFormula(this.dataSetProcess.getBsProcess().formula);
            }
            this.dataSetProcess.setEnableSwitchScriptType(false, true);
        }
    }

    @Override
    public void setMeta(MetaLibrary ml) {
    }

    public void setProvider(IObjectSelector provider) {
        this.provider = provider;
        this.importSelector.setProvider(provider);
        this.dataDefEditor.setObjProvider(provider);
    }

    @Override
    public String getTitle() {
        return DataprocessResource.getString("res_4");
    }

    @Override
    public Object getDataObject() {
        this.updateChange();
        return this.dataObj;
    }

    @Override
    public void setDataObject(Object dataObj) {
        this.dataObj = (IDataDef)dataObj;
        this.showValue();
    }

    public ParamPanel getParamUI() {
        return this.paramUI;
    }
}

