/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.chart.block;

import com.kingdee.bos.ctrl.freechart.chart.block.AbstractBlock;
import com.kingdee.bos.ctrl.freechart.chart.block.Block;
import com.kingdee.bos.ctrl.freechart.io.SerialUtilities;
import com.kingdee.bos.ctrl.freechart.util.PaintUtilities;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ColorBlock
extends AbstractBlock
implements Block {
    private transient Paint paint;

    public ColorBlock(Paint paint, double width, double height) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paint = paint;
        this.setWidth(width);
        this.setHeight(height);
    }

    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area) {
        Rectangle2D bounds = this.getBounds();
        g2.setPaint(this.paint);
        g2.fill(bounds);
    }

    @Override
    public Object draw(Graphics2D g2, Rectangle2D area, Object params) {
        this.draw(g2, area);
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ColorBlock)) {
            return false;
        }
        ColorBlock that = (ColorBlock)obj;
        if (!PaintUtilities.equal(this.paint, that.paint)) {
            return false;
        }
        return super.equals(obj);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(stream);
    }
}

