/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.chart.servlet;

import com.kingdee.bos.ctrl.freechart.chart.ChartRenderingInfo;
import com.kingdee.bos.ctrl.freechart.chart.ChartUtilities;
import com.kingdee.bos.ctrl.freechart.chart.JFreeChart;
import com.kingdee.bos.ctrl.freechart.chart.servlet.ChartDeleter;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FilenameUtils;

public class ServletUtilities {
    private static String tempFilePrefix = "jfreechart-";
    private static String tempOneTimeFilePrefix = "jfreechart-onetime-";

    public static String getTempFilePrefix() {
        return tempFilePrefix;
    }

    public static void setTempFilePrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        tempFilePrefix = prefix;
    }

    public static String getTempOneTimeFilePrefix() {
        return tempOneTimeFilePrefix;
    }

    public static void setTempOneTimeFilePrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        tempOneTimeFilePrefix = prefix;
    }

    public static String saveChartAsPNG(JFreeChart chart, int width, int height, HttpSession session) throws IOException {
        return ServletUtilities.saveChartAsPNG(chart, width, height, null, session);
    }

    public static String saveChartAsPNG(JFreeChart chart, int width, int height, ChartRenderingInfo info, HttpSession session) throws IOException {
        if (chart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        ServletUtilities.createTempDir();
        String prefix = tempFilePrefix;
        if (session == null) {
            prefix = tempOneTimeFilePrefix;
        }
        File tempFile = File.createTempFile(prefix, ".png", new File(FilenameUtils.normalize((String)System.getProperty("java.io.tmpdir"))));
        ChartUtilities.saveChartAsPNG(tempFile, chart, width, height, info);
        if (session != null) {
            ServletUtilities.registerChartForDeletion(tempFile, session);
        }
        return tempFile.getName();
    }

    public static String saveChartAsJPEG(JFreeChart chart, int width, int height, HttpSession session) throws IOException {
        return ServletUtilities.saveChartAsJPEG(chart, width, height, null, session);
    }

    public static String saveChartAsJPEG(JFreeChart chart, int width, int height, ChartRenderingInfo info, HttpSession session) throws IOException {
        if (chart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        ServletUtilities.createTempDir();
        String prefix = tempFilePrefix;
        if (session == null) {
            prefix = tempOneTimeFilePrefix;
        }
        File tempFile = File.createTempFile(prefix, ".jpeg", new File(FilenameUtils.normalize((String)System.getProperty("java.io.tmpdir"))));
        ChartUtilities.saveChartAsJPEG(tempFile, chart, width, height, info);
        if (session != null) {
            ServletUtilities.registerChartForDeletion(tempFile, session);
        }
        return tempFile.getName();
    }

    protected static void createTempDir() {
        String tempDirName = System.getProperty("java.io.tmpdir");
        if (tempDirName == null) {
            throw new RuntimeException("Temporary directory system property (java.io.tmpdir) is null.");
        }
        File tempDir = new File(FilenameUtils.normalize((String)tempDirName));
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
    }

    protected static void registerChartForDeletion(File tempFile, HttpSession session) {
        if (session != null) {
            ChartDeleter chartDeleter = (ChartDeleter)session.getAttribute("KDCtrl_FreeChart_Deleter");
            if (chartDeleter == null) {
                chartDeleter = new ChartDeleter();
                session.setAttribute("KDCtrl_FreeChart_Deleter", (Object)chartDeleter);
            }
            chartDeleter.addChart(tempFile.getName());
        } else {
            System.out.println("Session is null - chart will not be deleted");
        }
    }

    public static void sendTempFile(String filename, HttpServletResponse response) throws IOException {
        File file = new File(FilenameUtils.normalize((String)System.getProperty("java.io.tmpdir")), FilenameUtils.normalize((String)filename));
        ServletUtilities.sendTempFile(file, response);
    }

    public static void sendTempFile(File file, HttpServletResponse response) throws IOException {
        String mimeType = null;
        String filename = file.getName();
        if (filename.length() > 5) {
            if (filename.substring(filename.length() - 5, filename.length()).equals(".jpeg")) {
                mimeType = "image/jpeg";
            } else if (filename.substring(filename.length() - 4, filename.length()).equals(".png")) {
                mimeType = "image/png";
            }
        }
        ServletUtilities.sendTempFile(file, response, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendTempFile(File file, HttpServletResponse response, String mimeType) throws IOException {
        BufferedOutputStream bos;
        BufferedInputStream bis;
        FileInputStream fis;
        block6: {
            block5: {
                if (!file.exists()) break block5;
                fis = null;
                bis = null;
                bos = null;
                try {
                    fis = new FileInputStream(file);
                    bis = new BufferedInputStream(fis);
                    if (mimeType != null) {
                        response.setHeader("Content-Type", mimeType);
                    }
                    response.setHeader("Content-Length", String.valueOf(file.length()));
                    SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
                    sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                    response.setHeader("Last-Modified", sdf.format(new Date(file.lastModified())));
                    bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    byte[] input = new byte[1024];
                    boolean eof = false;
                    while (!eof) {
                        int length = bis.read(input);
                        if (length == -1) {
                            eof = true;
                            continue;
                        }
                        bos.write(input, 0, length);
                    }
                    bos.flush();
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{bos, bis, fis});
                    throw throwable;
                }
                break block6;
            }
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        CloseUtil.close((Closeable[])new Closeable[]{bos, bis, fis});
    }

    public static String searchReplace(String inputString, String searchString, String replaceString) {
        int i = inputString.indexOf(searchString);
        if (i == -1) {
            return inputString;
        }
        String r = "";
        r = r + inputString.substring(0, i) + replaceString;
        if (i + searchString.length() < inputString.length()) {
            r = r + ServletUtilities.searchReplace(inputString.substring(i + searchString.length()), searchString, replaceString);
        }
        return r;
    }
}

