/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.data.time;

import com.kingdee.bos.ctrl.freechart.data.Range;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class DateRange
extends Range
implements Serializable {
    private static final long serialVersionUID = -4705682568375418157L;
    private Date lowerDate;
    private Date upperDate;

    public DateRange() {
        this(new Date(0L), new Date(1L));
    }

    public DateRange(Date lower, Date upper) {
        super(lower.getTime(), upper.getTime());
        this.lowerDate = lower;
        this.upperDate = upper;
    }

    public DateRange(double lower, double upper) {
        super(lower, upper);
        this.lowerDate = new Date((long)lower);
        this.upperDate = new Date((long)upper);
    }

    public DateRange(Range other) {
        this(other.getLowerBound(), other.getUpperBound());
    }

    public Date getLowerDate() {
        return this.lowerDate;
    }

    public Date getUpperDate() {
        return this.upperDate;
    }

    @Override
    public String toString() {
        DateFormat df = DateFormat.getDateTimeInstance();
        return "[" + df.format(this.lowerDate) + " --> " + df.format(this.upperDate) + "]";
    }
}

