/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.data.xml;

import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.general.PieDataset;
import com.kingdee.bos.ctrl.freechart.data.xml.CategoryDatasetHandler;
import com.kingdee.bos.ctrl.freechart.data.xml.PieDatasetHandler;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class DatasetReader {
    public static PieDataset readPieDatasetFromXML(File file) throws IOException, SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        PieDataset pieDataset;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            pieDataset = DatasetReader.readPieDatasetFromXML(in);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        return pieDataset;
    }

    public static PieDataset readPieDatasetFromXML(InputStream in) throws IOException, SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        PieDataset result = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            SAXParser parser = factory.newSAXParser();
            PieDatasetHandler handler = new PieDatasetHandler();
            parser.parse(in, (DefaultHandler)handler);
            result = handler.getDataset();
        }
        catch (SAXException e) {
            System.out.println(e.getMessage());
        }
        catch (ParserConfigurationException e2) {
            System.out.println(e2.getMessage());
        }
        return result;
    }

    public static CategoryDataset readCategoryDatasetFromXML(File file) throws IOException, SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        CategoryDataset categoryDataset;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            categoryDataset = DatasetReader.readCategoryDatasetFromXML(in);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        return categoryDataset;
    }

    public static CategoryDataset readCategoryDatasetFromXML(InputStream in) throws IOException, SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        CategoryDataset result = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            SAXParser parser = factory.newSAXParser();
            CategoryDatasetHandler handler = new CategoryDatasetHandler();
            parser.parse(in, (DefaultHandler)handler);
            result = handler.getDataset();
        }
        catch (SAXException e) {
            System.out.println(e.getMessage());
        }
        catch (ParserConfigurationException e2) {
            System.out.println(e2.getMessage());
        }
        return result;
    }
}

