/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.data.xy;

import com.kingdee.bos.ctrl.freechart.data.xy.AbstractIntervalXYDataset;
import com.kingdee.bos.ctrl.freechart.data.xy.IntervalXYDataset;
import com.kingdee.bos.ctrl.freechart.data.xy.XIntervalDataItem;
import com.kingdee.bos.ctrl.freechart.data.xy.XIntervalSeries;
import com.kingdee.bos.ctrl.freechart.util.ObjectUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XIntervalSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
Serializable {
    private List data = new ArrayList();

    public void addSeries(XIntervalSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public XIntervalSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XIntervalSeries)this.data.get(series);
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    @Override
    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    @Override
    public Number getX(int series, int item) {
        XIntervalSeries s = (XIntervalSeries)this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s.getDataItem(item);
        return di.getX();
    }

    @Override
    public Number getY(int series, int item) {
        XIntervalSeries s = (XIntervalSeries)this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s.getDataItem(item);
        return new Double(di.getYValue());
    }

    @Override
    public Number getStartX(int series, int item) {
        XIntervalSeries s = (XIntervalSeries)this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s.getDataItem(item);
        return new Double(di.getXLowValue());
    }

    @Override
    public Number getEndX(int series, int item) {
        XIntervalSeries s = (XIntervalSeries)this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s.getDataItem(item);
        return new Double(di.getXHighValue());
    }

    @Override
    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XIntervalSeriesCollection)) {
            return false;
        }
        XIntervalSeriesCollection that = (XIntervalSeriesCollection)obj;
        return ObjectUtilities.equal(this.data, that.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XIntervalSeriesCollection clone = (XIntervalSeriesCollection)super.clone();
        clone.data = (List)ObjectUtilities.deepClone(this.data);
        return clone;
    }
}

