/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.export.nio;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.export.IExportObject;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.desensitization.DesensitizationRule;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class KDTableDataWrapper
extends AbstractDataWrapper {
    private KDTable _table;
    private int headRowCount = 0;
    private int[] hideColMarks;
    private int _colCount;
    private boolean _exportFootRow = true;
    private boolean _exportHeadRow = true;
    private int colEnd;
    private int rowEnd;
    private int colStart;
    private int rowStart;
    private int blockRowEnd;
    private int blockRowStart;
    private Logger logger = CommonLogger.getLogger(KDTableDataWrapper.class);
    private static final int SHEET_MAX_ROW = 1000000;
    private boolean _desensitizationExport = false;
    private int currentSheetIndex;
    private boolean groupFlag = false;

    public KDTableDataWrapper(KDTable table) {
        super(1);
        this._table = table;
        this.headRowCount = table.getHeadRowCount();
        this._colCount = this.colCount();
        if (!this._exportHideCols) {
            this.hideColMarks = new int[this._colCount];
            for (int i = 0; i < this._colCount; ++i) {
                if (!this.isHideCol(i)) continue;
                this.hideColMarks[i] = 1;
            }
        }
    }

    private IRow getRow(int rowNum) {
        int bodySize = this._table.getBody().size();
        if (rowNum < this.headRowCount) {
            return this._table.getHeadRow(rowNum);
        }
        if (rowNum - this.headRowCount < bodySize) {
            return this._table.getRow(rowNum - this.headRowCount);
        }
        return this._table.getFootRow(rowNum - this.headRowCount - bodySize);
    }

    private int getTableRow(int rowPosition) {
        return 1000000 * this.currentSheetIndex + rowPosition;
    }

    public boolean isRowEnd(int rowPosition) {
        boolean ret;
        int rowNum = this.getTableRow(rowPosition);
        if (this._exportSelect) {
            return rowNum - this.headRowCount > this.rowEnd;
        }
        if (rowNum < this.headRowCount) {
            return this._table.getHeadRow(rowNum) == null;
        }
        int tableBodyRowNum = rowNum - this.headRowCount;
        boolean bl = ret = this._table.getRow(tableBodyRowNum) == null;
        if (!ret && rowPosition != 0 && rowPosition % 1000000 == 0) {
            this.logger.debug((Object)String.format("\u884c\u6570\u8d85\u8fc7%d\u9650\u5236\u8fdb\u884c\u7ffb\u9875\u5f53\u524d\u9875\u9762%d", 1000000, this.currentSheetIndex));
            return true;
        }
        if (ret && this._exportFootRow && this._table.isHasFoot()) {
            int size = this._table.getBody().size();
            ret = this._table.getFootRow(tableBodyRowNum - size) == null;
        }
        return ret;
    }

    public int getSheetCount() {
        int size = this._table.getBody().size() + this.headRowCount;
        if (this._exportFootRow && this._table.isHasFoot()) {
            size += this._table.getFootManager().getFoot().size();
        }
        int page = size / 1000000;
        if (size % 1000000 != 0) {
            ++page;
        }
        return page;
    }

    public boolean isColEnd(int colPosition) {
        return colPosition >= this._colCount;
    }

    public AbstractDataWrapper.MergeBlock getMergeBlock(int rowNum, int colNum) {
        AbstractDataWrapper.MergeBlock mb;
        int i;
        boolean head = false;
        if (rowNum < this.headRowCount) {
            head = true;
        }
        if (!this._exportMergeBlocks && !head) {
            return null;
        }
        ICell cell = this.getFirstVisibleCell(rowNum, colNum);
        if (cell == null) {
            return null;
        }
        KDTMergeBlock block = cell.getMergeBlock();
        if (block == null) {
            return null;
        }
        int top = block.getTop();
        int bottom = block.getBottom();
        if (this._exportSelect && this.blockRowStart > top && !head) {
            top = this.blockRowStart;
        }
        if (this._exportSelect && this.blockRowEnd < bottom && !head) {
            bottom = this.blockRowEnd;
        }
        int left = block.getLeft();
        int right = block.getRight();
        if (top == bottom && left == right) {
            return null;
        }
        int hideRowCount = 0;
        int hideColCount = 0;
        if (!this._exportHideRows) {
            for (i = top; i <= bottom; ++i) {
                if (head) {
                    if (!this._table.getHeadRow(rowNum).getStyleAttributes().isHided()) continue;
                    ++hideRowCount;
                    continue;
                }
                if (this._table.getRow(rowNum) == null || !this._table.getRow(rowNum).getStyleAttributes().isHided()) continue;
                ++hideRowCount;
            }
        }
        if (!this._exportHideCols) {
            for (i = left; i <= right; ++i) {
                if (this.hideColMarks[i] != 1) continue;
                ++hideColCount;
            }
        }
        AbstractDataWrapper.MergeBlock mergeBlock = mb = head ? KDTableDataWrapper.getMergeBlock((int)rowNum, (int)colNum, (int)(bottom - top + rowNum - hideRowCount), (int)(right - left + colNum - hideColCount)) : KDTableDataWrapper.getMergeBlock((int)(top + this.headRowCount), (int)colNum, (int)(bottom - hideRowCount + this.headRowCount), (int)(right - left + colNum - hideColCount));
        if (this._exportSelect && !head) {
            int newRow = mb.getRow();
            int newCol = mb.getCol();
            int newRow2 = mb.getRow2();
            int newCol2 = mb.getCol2();
            if (newRow < this.rowStart) {
                newRow = this.rowStart;
            }
            if (newCol < this.colStart) {
                newCol = this.colStart;
            }
            if (newRow2 > this.rowEnd + 1 + this.headRowCount) {
                newRow2 = this.rowEnd + 1 + this.headRowCount;
            }
            if (newCol2 > this.colEnd + 1) {
                newCol2 = this.colEnd + 1;
            }
            mb = KDTableDataWrapper.getMergeBlock((int)(newRow + this.headRowCount), (int)newCol, (int)(newRow2 - hideRowCount + this.headRowCount), (int)(newCol2 - hideColCount));
        }
        mb.setGroup(null == cell.getKDTCell().getValue() ? "" : cell.getKDTCell().getValue().toString());
        if (mb.getRow2() == mb.getRow() && mb.getCol() == mb.getCol2()) {
            mb = null;
        }
        return mb;
    }

    public ShareStyleAttributes SSAAt(int rowPostion, int colNum) {
        StyleAttributes sa;
        IRow row;
        int rowNum = this.getTableRow(rowPostion);
        int bodySize = this._table.getBody().size();
        ICell cell = null;
        if (rowNum < this.headRowCount) {
            row = this._table.getHeadRow(rowNum);
            cell = row.getCell(colNum);
        } else if (rowNum - this.headRowCount < bodySize) {
            row = this._table.getRow(rowNum - this.headRowCount);
            if (row != null) {
                cell = row.getCell(colNum);
            }
        } else {
            rowNum -= this.headRowCount;
            row = this._table.getFootRow(rowNum -= bodySize);
            cell = this.getFirstVisibleMergeCell_Foot(rowNum, colNum);
        }
        if (cell == null) {
            return Styles.getEmptySSA();
        }
        ShareStyleAttributes[] ssas = new ShareStyleAttributes[4];
        ssas[0] = cell.getStyleAttributes();
        Object ret = cell.getValue();
        if (ret instanceof Variant) {
            ret = ((Variant)ret).getValue();
        }
        if (ret instanceof IExportObject) {
            IExportObject eo = (IExportObject)ret;
            sa = Styles.getSA((ShareStyleAttributes)ssas[0]);
            sa.setNumberFormat(eo.getFormatString());
            ssas[0] = Styles.getSSA((StyleAttributes)sa);
        }
        ssas[1] = row.getStyleAttributes();
        IColumn col = this._table.getColumn(colNum);
        ssas[2] = col.getStyleAttributes();
        ssas[3] = this._table.getSSA();
        ShareStyleAttributes ret2 = Styles.mergeSSA((ShareStyleAttributes[])ssas);
        if (this.isKDTableFormatStr(ret2.getNumberFormat())) {
            sa = Styles.getSA((ShareStyleAttributes)ret2);
            sa.setNumberFormat(null);
            ret2 = Styles.getSSA((StyleAttributes)sa);
        }
        return ret2;
    }

    private boolean isKDTableFormatStr(String str) {
        if (StringUtil.isEmptyString((String)str)) {
            return false;
        }
        if (str.startsWith("%")) {
            return true;
        }
        if (str.startsWith("$L") || str.startsWith("$U") || str.startsWith("$P")) {
            return true;
        }
        if (str.startsWith("@") && str.length() > 1) {
            return true;
        }
        return this.getCharCount(str, ';') > 3;
    }

    private int getCharCount(String str, char c) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public void dataSourceMemeryCallback(int rowPostion, int col) {
        int rowNum = this.getTableRow(rowPostion);
        KDTDataRequestManager manager = this._table.getDataRequestManager();
        manager.doMemoryCallback(rowNum / manager.getPageRowCount());
    }

    public Object valueAt(int rowPostion, int colNum) {
        int rowNum = this.getTableRow(rowPostion);
        ICell cell = this.getFirstVisibleCell(rowNum, colNum);
        if (cell == null) {
            return null;
        }
        Object ret = cell.getValue();
        if (rowNum >= this.headRowCount && rowNum - this.headRowCount < this._table.getBody().size()) {
            String nf = cell.getStyleAttributes().getNumberFormat();
            ret = nf != null && nf.startsWith("@") && nf.length() > 1 ? this._table.getCellDisplayValue(cell.getKDTCell(), cell.getRowIndex(), cell.getColumnIndex()) : KDTableHelper.getCellDisplayValue2(this._table, cell.getRowIndex(), cell.getColumnIndex());
            if (ret instanceof Variant) {
                ret = ((Variant)ret).getValue();
            }
            if (ret instanceof IExportObject) {
                IExportObject eo = (IExportObject)ret;
                ret = eo.getContent();
            }
        } else if (rowNum >= this.headRowCount) {
            rowNum -= this.headRowCount;
            cell = this.getFirstVisibleMergeCell_Foot(rowNum -= this._table.getBody().size(), colNum);
            ret = cell.getValue();
        }
        short valueType = KDTableDataWrapper.getValueType((Object)cell.getValue());
        ret = this.desensitizationValueAt(ret, valueType, cell);
        return ret;
    }

    private ICell getFirstVisibleMergeCell_Body(int rowNum, int colNum) {
        KDTMergeBlock merge = null;
        if (this._table.getCell(rowNum, colNum) != null) {
            merge = this._table.getCell(rowNum, colNum).getMergeBlock();
        }
        if (merge == null) {
            return this._table.getCell(rowNum, colNum);
        }
        if (null == this._table.getRow2(merge.getTop())) {
            return this._table.getCell(rowNum, colNum);
        }
        return this._table.getCell(merge.getTop(), merge.getLeft());
    }

    private ICell getFirstVisibleMergeCell_Head(int rowNum, int colNum) {
        int i;
        KDTMergeBlock merge = null;
        if (this._table.getHeadRow(rowNum).getCell(colNum) != null) {
            merge = this._table.getHeadRow(rowNum).getCell(colNum).getMergeBlock();
        }
        if (merge == null) {
            return this._table.getHeadRow(rowNum).getCell(colNum);
        }
        int row = merge.getTop();
        int row2 = merge.getBottom();
        int col = merge.getLeft();
        int col2 = merge.getRight();
        if (!this._exportHideCols && this.hideColMarks[colNum] != 1) {
            for (i = col; i <= col2 && this.hideColMarks[i] == 1; ++i) {
                ++col;
            }
        }
        if (!this._exportHideRows && !this._table.getHeadRow(rowNum).getStyleAttributes().isHided()) {
            for (i = row; i <= row2 && this._table.getHeadRow(row).getStyleAttributes().isHided(); ++i) {
                ++row;
            }
        }
        if (rowNum == row && colNum == col) {
            return this._table.getHeadRow(merge.getTop()).getCell(merge.getLeft());
        }
        return null;
    }

    private ICell getFirstVisibleMergeCell_Foot(int rowNum, int colNum) {
        int i;
        KDTMergeBlock merge = null;
        merge = this._table.getFootManager().getMergeManager().getMergeBlockOfCell(rowNum, colNum);
        if (merge == null) {
            return this._table.getFootRow(rowNum).getCell(colNum);
        }
        int row = merge.getTop();
        int row2 = merge.getBottom();
        int col = merge.getLeft();
        int col2 = merge.getRight();
        if (!this._exportHideCols && this.hideColMarks[colNum] != 1) {
            for (i = col; i <= col2 && this.hideColMarks[i] == 1; ++i) {
                ++col;
            }
        }
        if (!this._exportHideRows && !this._table.getFootRow(rowNum).getStyleAttributes().isHided()) {
            for (i = row; i <= row2 && this._table.getFootRow(row).getStyleAttributes().isHided(); ++i) {
                ++row;
            }
        }
        if (rowNum == row && colNum == col) {
            return this._table.getFootRow(merge.getTop()).getCell(colNum);
        }
        if (!this._exportMergeBlocks) {
            return this._table.getFootRow(merge.getTop()).getCell(colNum);
        }
        return null;
    }

    private ICell getFirstVisibleCell(int rowNum, int colNum) {
        int bodySize = this._table.getBody().size();
        ICell cell = null;
        if (rowNum < this.headRowCount) {
            cell = this.getFirstVisibleMergeCell_Head(rowNum, colNum);
        } else if (rowNum - this.headRowCount < bodySize) {
            cell = this.getFirstVisibleMergeCell_Body(rowNum -= this.headRowCount, colNum);
        } else {
            rowNum = rowNum - this.headRowCount - bodySize;
            cell = this.getFirstVisibleMergeCell_Foot(rowNum, colNum);
        }
        return cell;
    }

    public short valueTypeAt(int rowPostion, int colNum) {
        int rowNum = this.getTableRow(rowPostion);
        ICell cell = this.getFirstVisibleCell(rowNum, colNum);
        if (cell == null) {
            return 3;
        }
        return this.desensitizationValueTypeAt(KDTableDataWrapper.getValueType((Object)cell.getValue()), cell);
    }

    public int sheetCount() {
        return 1;
    }

    public String sheetName(int index) {
        int i = index + 1;
        return "Sheet" + i;
    }

    public boolean isFirstMergeCell(int row, int col) {
        KDTMergeBlock block;
        boolean head = false;
        if (row < this.headRowCount) {
            block = this._table.getHeadRow(row).getCell(col).getMergeBlock();
            head = true;
        } else {
            block = this._table.getCell(row - this.headRowCount, col).getMergeBlock();
        }
        if (block == null) {
            return true;
        }
        return head ? block.getTop() == row && block.getLeft() == col : block.getTop() == row - this.headRowCount && block.getLeft() == col;
    }

    public boolean isBookProtected() {
        return false;
    }

    public boolean isCurrentSheetProtected() {
        return false;
    }

    protected String getFormula(int row, int col) {
        return null;
    }

    public boolean isHideRow(int rowPostion) {
        int rowNum = this.getTableRow(rowPostion);
        if (rowNum < this.headRowCount) {
            return false;
        }
        if (this._exportSelect) {
            return !this.isSelectRow(rowNum);
        }
        if (this._exportHideRows) {
            return false;
        }
        IRow row = this.getRow(rowNum);
        if (row == null) {
            return true;
        }
        return row.getStyleAttributes().isHided();
    }

    private boolean isSelectRow(int rowNum) {
        KDTRange range = this._table.getSelectManager().toRange().getSequenceRange();
        for (IBlock block : range) {
            if (rowNum - this.headRowCount < block.getTop() || rowNum - this.headRowCount > block.getBottom()) continue;
            this.blockRowStart = block.getTop();
            this.blockRowEnd = block.getBottom();
            if (this._exportHideRows) {
                return true;
            }
            IRow row = this.getRow(rowNum);
            if (row == null) {
                return false;
            }
            return !row.getStyleAttributes().isHided();
        }
        return false;
    }

    public boolean isHideCol(int col) {
        if (col < this.colStart) {
            return true;
        }
        if (this._exportHideCols) {
            return false;
        }
        IColumn column = this._table.getColumn(col);
        if (column == null) {
            return true;
        }
        return column.getStyleAttributes().isHided();
    }

    public int colCount() {
        return this._table.getColumnCount();
    }

    public void configSourceRepaint(boolean isOpen) {
        if (this._table.getDataRequestManager().getDataRequestMode() == 0 || this.isExportSelect() || !this._table.getDataRequestManager().isExportMemoryCallback()) {
            return;
        }
        this._table.enableRepaint(false);
        this._table.setRefresh(false);
        final KDTDataRequestManager manager = this._table.getDataRequestManager();
        if (!isOpen) {
            this.groupFlag = this._table.getGroupManager().isGroup();
            this._table.getGroupManager().setGroup(isOpen);
        } else {
            this._table.getGroupManager().setGroup(this.groupFlag);
        }
        manager.setMemoryCallback(!isOpen);
        manager.setExporting(!isOpen);
        this._table.enableRepaint(isOpen);
        this._table.setRefresh(isOpen);
        if (isOpen) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (manager.isRequestDataByQuery()) {
                        KDTableDataWrapper.this._table.removeRows();
                    }
                    KDTableDataWrapper.this._table.reLayoutAndPaint();
                }
            });
        }
    }

    public AbstractDataWrapper.EmbedObject getEmbedObject(int index) {
        return null;
    }

    public int getEmbedObjectsCount() {
        return 0;
    }

    public int rowCount() {
        return this._table.getRowCount();
    }

    public int rowHeightAt(int rowPostion) {
        int rowNum = this.getTableRow(rowPostion);
        if (rowNum < this.headRowCount) {
            return this._table.getHeadRow(rowNum).getHeight();
        }
        if (rowNum < this._table.getBody().size() + this.headRowCount) {
            return this._table.getRow(rowNum - this.headRowCount).getHeight();
        }
        return this._table.getFootRow(rowNum - this._table.getBody().size() - this.headRowCount).getHeight();
    }

    public int colWidthAt(int colNum) {
        return this._table.getColumn(colNum).getWidth();
    }

    public final void setExportFootRow(boolean exportFootRow) {
        this._exportFootRow = exportFootRow;
    }

    public final boolean isExportFootRow() {
        return this._exportFootRow;
    }

    public final void setExportHeadRow(boolean exportHeadRow) {
        this._exportHeadRow = exportHeadRow;
        if (!exportHeadRow) {
            this.headRowCount = 0;
        }
    }

    public final boolean isExportHeadRow() {
        return this._exportHeadRow;
    }

    public final void setDesensitizationExport(boolean desensitizationExport) {
        this._desensitizationExport = desensitizationExport;
    }

    public final boolean isDesensitizationExport() {
        return this._desensitizationExport;
    }

    public void setCurrentSheetIndex(int currentSheetIndex) {
        this.currentSheetIndex = currentSheetIndex;
        if (this._exportSelect) {
            KDTRange range = this._table.getSelectManager().toRange();
            Collections.sort(range);
            IBlock block = (IBlock)range.get(0);
            IBlock blockLast = (IBlock)range.get(range.size() - 1);
            this.rowStart = block.getTop();
            this.rowEnd = blockLast.getBottom();
            this.colStart = block.getLeft();
            this.colEnd = blockLast.getRight();
            int selectMode = this._table.getSelectManager().getSelectMode();
            if (selectMode == 2 || selectMode == 10) {
                this.colStart = 0;
                this.colEnd = this._table.getColumnCount();
            } else if (selectMode == 4 || selectMode == 12) {
                this.rowStart = 0;
                this.rowEnd = this._table.getRowCount3();
            }
        }
    }

    public int getExportPageRowCount() {
        return this._table.getDataRequestManager().getDataRequestMode() == 0 ? Integer.MAX_VALUE : this._table.getDataRequestManager().getExportPageRowCount();
    }

    public String getCellValue(int row, int col) {
        String value = "";
        KDTCell cell = this._table.getBody().getCell(row, col);
        if (null != cell && null != cell.getValue()) {
            value = cell.getValue().toString();
        }
        return value;
    }

    public boolean isGroupCol(int col) {
        return this._table.getColumn(col).isGroup();
    }

    public boolean isMergeCol(int col) {
        return this._table.getColumn(col).isMergeable();
    }

    public boolean isExportHeadRow(int rowNum) {
        return this.currentSheetIndex == 0 && rowNum < this._table.getHeadRowCount();
    }

    public int getHeadNumber() {
        return this._table.getHeadRowCount();
    }

    public boolean hasGroupInfo() {
        return false;
    }

    public boolean isExportRPT() {
        return false;
    }

    public Object desensitizationValueAt(Object value, short valueType, ICell cell) {
        DesensitizationRule dr;
        if (this._desensitizationExport && (0 == valueType || 1 == valueType) && cell.getKDTCell() != null && (dr = cell.getKDTCell().getDesensitizationRule()) != null) {
            switch (valueType) {
                case 0: {
                    if (value instanceof Number) {
                        Double double1 = Double.valueOf(value.toString());
                        return DesensitizationRule.desensitization((String)String.valueOf(double1).replaceAll("\\.0*$", ""), (DesensitizationRule)dr);
                    }
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        return DesensitizationRule.desensitization((String)String.valueOf(date), (DesensitizationRule)dr);
                    }
                    if (value instanceof Calendar) {
                        Calendar calendar = (Calendar)value;
                        GregorianCalendar newCalendar = new GregorianCalendar(1900, 0, 1);
                        if (calendar.before(newCalendar)) {
                            String localeString = calendar.getTime().toLocaleString();
                            return DesensitizationRule.desensitization((String)localeString, (DesensitizationRule)dr);
                        }
                        Calendar cd = (Calendar)value;
                        return DesensitizationRule.desensitization((String)String.valueOf(cd), (DesensitizationRule)dr);
                    }
                    if (!(value instanceof String) || StringUtil.isEmptyString((String)((String)value))) break;
                    String string = value.toString();
                    return DesensitizationRule.desensitization((String)string, (DesensitizationRule)dr);
                }
                case 1: {
                    if (value == null) break;
                    String str = value.toString();
                    if (StringUtil.isEmptyString((String)str)) {
                        return DesensitizationRule.desensitization((String)"", (DesensitizationRule)dr);
                    }
                    return DesensitizationRule.desensitization((String)str, (DesensitizationRule)dr);
                }
            }
        }
        return value;
    }

    public short desensitizationValueTypeAt(short valueType, ICell cell) {
        DesensitizationRule dr;
        if (this._desensitizationExport && (0 == valueType || 1 == valueType) && cell.getKDTCell() != null && (dr = cell.getKDTCell().getDesensitizationRule()) != null) {
            return 7;
        }
        return valueType;
    }
}

