/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.servertable;

import com.kingdee.bos.ctrl.common.util.CollectionUtil;
import com.kingdee.bos.ctrl.kdf.servertable.IRows;
import com.kingdee.bos.ctrl.kdf.servertable.KDTCell;
import com.kingdee.bos.ctrl.kdf.servertable.KDTRow;
import com.kingdee.bos.ctrl.kdf.servertable.KDTable;
import java.util.ArrayList;
import java.util.List;

class KDTHead
implements IRows {
    private KDTable table;
    private ArrayList rows;

    public KDTHead(KDTable table) {
        this.table = table;
        this.rows = new ArrayList();
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public int virtualSize() {
        return this.size();
    }

    @Override
    public void addRow(int rowIndex, KDTRow row) {
        if (rowIndex < 0) {
            return;
        }
        if (rowIndex > this.size()) {
            CollectionUtil.resizeList((List)this.rows, (int)(rowIndex + 1));
        }
        this.rows.add(rowIndex, row);
    }

    @Override
    public void setRow(int rowIndex, KDTRow row) {
        if (rowIndex < 0 || rowIndex >= this.size()) {
            return;
        }
        this.rows.set(rowIndex, row);
    }

    @Override
    public void addColumn(int colIndex, KDTCell cell) {
        for (int i = 0; i < this.rows.size(); ++i) {
            KDTRow row = this.getRow2(i);
            if (row == null) continue;
            row.addCell(colIndex, cell);
        }
    }

    @Override
    public KDTRow removeRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.size()) {
            return (KDTRow)this.rows.remove(rowIndex);
        }
        return null;
    }

    public void removeRows() {
        this.rows.clear();
    }

    @Override
    public KDTRow getRow(int rowIndex) {
        return this.getRow2(rowIndex);
    }

    @Override
    public KDTRow getRow2(int rowIndex) {
        return rowIndex < 0 || rowIndex >= this.size() ? null : (KDTRow)this.rows.get(rowIndex);
    }

    @Override
    public int getRowHeight(int rowIndex) {
        KDTRow row = this.getRow(rowIndex);
        if (row != null) {
            int height = row.getHeight();
            if (height == -1) {
                height = this.table.getDefaultHeadRowHeight();
            }
            return height;
        }
        return -1;
    }

    @Override
    public void setRowHeight(int rowIndex, int height) {
        KDTRow row = this.getRow(rowIndex);
        if (row != null) {
            row.setHeight(height);
        }
    }

    @Override
    public int getHeight(int top, int bottom) {
        if (top < 0) {
            top = 0;
        }
        int height = 0;
        for (int i = top; i <= bottom; ++i) {
            height += this.getRowHeight(i);
        }
        return height;
    }

    @Override
    public int getHeight() {
        int height = 0;
        for (int i = 0; i < this.size(); ++i) {
            height += this.getRowHeight(i);
        }
        return height;
    }

    @Override
    public boolean isCellEquals(KDTCell cell1, KDTCell cell2) {
        return cell1 != null && cell2 != null && cell1.getValue() != null && cell2.getValue() != null && cell1.getValue().equals(cell2.getValue());
    }

    @Override
    public int getType() {
        return 0;
    }

    KDTable getTable() {
        return this.table;
    }
}

