/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.servertable;

import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.expr.TableRelations;
import com.kingdee.bos.ctrl.kdf.servertable.ICell;
import com.kingdee.bos.ctrl.kdf.servertable.IColumn;
import com.kingdee.bos.ctrl.kdf.servertable.IRow;
import com.kingdee.bos.ctrl.kdf.servertable.IRows;
import com.kingdee.bos.ctrl.kdf.servertable.KDTCell;
import com.kingdee.bos.ctrl.kdf.servertable.KDTRow;
import com.kingdee.bos.ctrl.kdf.servertable.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public final class KDTableXmlTrans
implements IXmlTrans {
    private KDTable table;
    protected static final Namespace NS_TABLE = Namespace.getNamespace((String)"t", (String)"http://www.kingdee.com/Table");
    protected static final Namespace NS_COMMON = Namespace.getNamespace((String)"c", (String)"http://www.kingdee.com/Common");
    private TableRelations tableRelations;

    public KDTableXmlTrans() {
        long b = System.currentTimeMillis();
        long e = System.currentTimeMillis() - b;
        KDTable.printDebugInfo("coustruct:" + e);
    }

    public Element writeToNode(Object obj, KDF kdf) {
        if (!(obj instanceof KDTable)) {
            throw new IllegalArgumentException("KDTable\u7684\u5e8f\u5217\u5316\u5668\u53ea\u80fd\u63a5\u53d7KDTable\u7c7b\u578b\u7684\u53c2\u6570");
        }
        this.table = (KDTable)obj;
        return this.out(kdf);
    }

    public Object readFromNode(Element ele, KDF kdf) {
        return this.readFromNode(ele, kdf.getReader());
    }

    public Object readFromNode(Element ele, KDFXmlReader reader) {
        this.table = new KDTable();
        this.table.getScriptManager().setRelationsObject(this.getTableRelations());
        this.parse(ele);
        return this.table;
    }

    public void readDefaultTableFromFile(KDTable table, KDFXmlReader reader) {
        this.table = table;
        this.parse((Element)reader.getTableNodes().get(0));
    }

    Element out(KDF kdf) {
        if (null == kdf) {
            throw new IllegalArgumentException("KDTable\u5e8f\u5217\u5316\u65b9\u6cd5\u9700\u8981\u975e\u7a7a\u7684\u53c2\u6570\uff1akdf");
        }
        Element nodeKDTable = new Element("Table", kdf.getReader().getRoot().getNamespace());
        if (this.isEmptyString(this.table.getID())) {
            this.table.setID(KDF.getDefaultID());
        }
        this.setNodeAttribute(nodeKDTable, "id", this.table.getID());
        Element nodeDataStyles = new Element("DataStyles", NS_TABLE);
        nodeKDTable.addContent((Content)nodeDataStyles);
        Element nodeSheet = new Element("Sheet", NS_TABLE);
        nodeKDTable.addContent((Content)nodeSheet);
        this.buildSheet(nodeSheet);
        return nodeKDTable;
    }

    private void buildSheet(Element nodeSheet) {
        nodeSheet.setAttribute("name", "NotSupportedInThisVersion", NS_TABLE);
        Element nodeTable = new Element("Table", NS_TABLE);
        this.buildTable(nodeTable);
        nodeSheet.addContent((Content)nodeTable);
        Element nodeOptions = new Element("SheetOptions", NS_TABLE);
        this.buildSheetOptions(nodeOptions);
        nodeSheet.addContent((Content)nodeOptions);
    }

    private void buildSheetOptions(Element nodeOptions) {
        Element nodeGridLine = new Element("GridLine", NS_TABLE);
        this.setNodeAttribute(nodeGridLine, "headVertical", this.table.isVerticalHeadGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "headHorizon", this.table.isHorizonHeadGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "bodyVertical", this.table.isVerticalGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "bodyHorizon", this.table.isHorizonGridLineVisible() ? "true" : "false");
        nodeOptions.addContent((Content)nodeGridLine);
    }

    private void buildTable(Element nodeTable) {
        String value;
        this.setTableAttributes(nodeTable);
        Element nodeColGroup = new Element("ColumnGroup", NS_TABLE);
        this.buildNodeColGroup(nodeColGroup);
        nodeTable.addContent((Content)nodeColGroup);
        Element nodeHead = new Element("Head", NS_TABLE);
        this.buildNodeHead(nodeHead);
        nodeTable.addContent((Content)nodeHead);
        Element nodeBody = new Element("Body", NS_TABLE);
        this.buildNodeBody(nodeBody);
        nodeTable.addContent((Content)nodeBody);
        Object uo = this.table.getUserObject();
        if (uo != null && (value = ObjectUtil.objectToString((Object)uo)) != null) {
            Element nodeUO = new Element("UserObject", NS_TABLE);
            nodeUO.setText(value);
            nodeTable.addContent((Content)nodeUO);
        }
    }

    private void setTableAttributes(Element nodeTable) {
        this.setNodeAttribute(nodeTable, "rowHeight", String.valueOf(this.table.getDefaultRowHeight()));
        this.setNodeAttribute(nodeTable, "headRowHeight", String.valueOf(this.table.getDefaultHeadRowHeight()));
        this.setNodeAttribute(nodeTable, "columnWidth", String.valueOf(this.table.getDefaultColumnWidth()));
    }

    private void buildNodeColGroup(Element nodeColGroup) {
    }

    private void setNodeAttribute(Element node, String attrName, String value) {
        if (StringUtil.isEmptyString((String)attrName) || StringUtil.isEmptyString((String)value)) {
            return;
        }
        node.setAttribute(attrName, value, NS_TABLE);
    }

    private void buildNodeHead(Element nodeHead) {
        this.buildRowsNode(nodeHead, this.table.getHead(), this.table.getHeadRowCount());
    }

    private void buildRowsNode(Element nodeRows, IRows rows, int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            Element nodeRow = new Element("Row", nodeRows.getNamespace());
            this.buildRow(nodeRow, rows.getRow(i));
            nodeRows.addContent((Content)nodeRow);
        }
    }

    private void buildRow(Element nodeRow, KDTRow row) {
        String str;
        this.setNodeAttribute(nodeRow, "mergeable", String.valueOf(row.isMergeable()));
        this.setNodeAttribute(nodeRow, "resizeable", String.valueOf(row.isResizeable()));
        this.setNodeAttribute(nodeRow, "height", String.valueOf(row.getHeight()));
        int size = row.getCells().size();
        for (int i = 0; i < size; ++i) {
            Element nodeCell = new Element("Cell", NS_TABLE);
            this.buildCell(nodeCell, row.getCell(i));
            nodeRow.addContent((Content)nodeCell);
        }
        Object obj = row.getUserObject();
        if (obj != null && (str = ObjectUtil.objectToString((Object)obj)) != null) {
            Element nodeUO = new Element("UserObject", NS_TABLE);
            nodeUO.setText(str);
            nodeRow.addContent((Content)nodeUO);
        }
    }

    private void buildCell(Element nodeCell, KDTCell cell) {
        Element node;
        if (null == cell || cell.isEmpty()) {
            return;
        }
        String value = ObjectUtil.objectToString((Object)cell.getValue());
        if (value != null) {
            node = new Element("Value", NS_TABLE);
            node.setText(value);
            nodeCell.addContent((Content)node);
        }
        if ((value = ObjectUtil.objectToString((Object)cell.getUserObject())) != null) {
            node = new Element("UserObject", NS_TABLE);
            node.setText(value);
            nodeCell.addContent((Content)node);
        }
        if (!this.isEmptyString(value = cell.getExpressions())) {
            node = new Element("Expression", NS_TABLE);
            node.setText(value);
            nodeCell.addContent((Content)node);
        }
    }

    private void buildNodeBody(Element nodeBody) {
    }

    void parse(Element nodeKDTable) {
        boolean autoRun = this.table.isScriptAutoRun();
        this.table.setScriptAutoRun(false);
        String id = nodeKDTable.getAttributeValue("id", NS_TABLE);
        if (!this.isEmptyString(id)) {
            this.table.setID(id);
        }
        Element nodeTable = null;
        try {
            nodeTable = nodeKDTable.getChild("Sheet", NS_TABLE).getChild("Table", NS_TABLE);
        }
        catch (Exception e) {
            return;
        }
        if (nodeTable == null) {
            return;
        }
        this.fillTable(nodeTable);
        Element nodeSheetOptions = nodeKDTable.getChild("Sheet", NS_TABLE).getChild("SheetOptions", NS_TABLE);
        if (null != nodeSheetOptions) {
            this.fillSheetOptions(nodeSheetOptions);
        }
        this.table.setScriptAutoRun(autoRun);
    }

    private void fillSheetOptions(Element nodeSheetOptions) {
        Element nodeGridLine = nodeSheetOptions.getChild("GridLine", NS_TABLE);
        this.parseGridLine(nodeGridLine);
        Element nodeMerges = nodeSheetOptions.getChild("MergeBlocks", NS_TABLE);
        this.parseMergeBlocks(nodeMerges);
    }

    private void parseMergeBlocks(Element nodeMerges) {
        if (null == nodeMerges) {
            return;
        }
    }

    private void parseGridLine(Element nodeGridLine) {
        if (null == nodeGridLine) {
            return;
        }
        String sVal = nodeGridLine.getAttributeValue("headVertical", NS_TABLE);
        this.table.setVerticalHeadGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttributeValue("headHorizon", NS_TABLE);
        this.table.setHorizonHeadGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttributeValue("bodyVertical", NS_TABLE);
        this.table.setVerticalGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttributeValue("bodyHorizon", NS_TABLE);
        this.table.setHorizonGridLineVisible(this.getBooleanFromString(sVal));
    }

    private boolean isEmptyString(String value) {
        return null == value || value.trim().equals("");
    }

    private boolean getBooleanFromString(String s) {
        return s != null && (s.equalsIgnoreCase("true") || s.equals("1"));
    }

    private void fillTable(Element nodeTable) {
        Object uo;
        this.fillTableAttributes(this.table, nodeTable);
        Element e = nodeTable.getChild("ColumnGroup", NS_TABLE);
        if (e != null) {
            this.fillColumns(e);
        }
        if ((e = nodeTable.getChild("Head", NS_TABLE)) != null) {
            this.fillHead(e);
        }
        if ((e = nodeTable.getChild("Body", NS_TABLE)) != null) {
            this.fillBody(e);
        }
        if ((e = nodeTable.getChild("UserObject", NS_TABLE)) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            this.table.setUserObject(uo);
        }
    }

    private void fillColumns(Element e) {
        List list1 = e.getChildren("Column", NS_TABLE);
        for (int i = 0; i < list1.size(); ++i) {
            Element colNode = (Element)list1.get(i);
            this.fillColAttributes(i, colNode);
        }
    }

    private void fillHead(Element e) {
        int i;
        List list1 = e.getChildren("Row", NS_TABLE);
        IRow[] rows = new IRow[list1.size()];
        for (i = 0; i < rows.length; ++i) {
            rows[i] = this.table.addHeadRow(i);
        }
        for (i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            Element rowNode = (Element)list1.get(i);
            this.fillRowAttributes(row, rowNode);
            List list2 = rowNode.getChildren("Cell", NS_TABLE);
            for (int j = 0; j < list2.size(); ++j) {
                ICell cell;
                Element cellNode = (Element)list2.get(j);
                int cellIndex = j;
                String value = cellNode.getAttributeValue("index", NS_TABLE);
                if (!this.isEmptyString(value)) {
                    cellIndex = Integer.parseInt(value);
                }
                if ((cell = row.getCell(cellIndex)) == null) continue;
                this.fillCellAttributes(cell, cellNode);
            }
        }
    }

    private void fillBody(Element e) {
        List list1 = e.getChildren("Row", NS_TABLE);
        for (int i = 0; i < list1.size(); ++i) {
            IRow row = this.table.addRow(i);
            Element rowNode = (Element)list1.get(i);
            this.fillRowAttributes(row, rowNode);
            List list2 = rowNode.getChildren("Cell", NS_TABLE);
            for (int j = 0; j < list2.size(); ++j) {
                Element cellNode = (Element)list2.get(j);
                ICell cell = row.getCell(j);
                if (cell == null) continue;
                this.fillCellAttributes(cell, cellNode);
            }
        }
    }

    private void fillTableAttributes(KDTable objTable, Element objXml) {
        String attVal = objXml.getAttributeValue("columnWidth", NS_TABLE);
        if (!this.isEmptyString(attVal)) {
            objTable.setDefaultColumnWidth(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("headRowHeight", NS_TABLE))) {
            objTable.setDefaultHeadRowHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("rowHeight", NS_TABLE))) {
            objTable.setDefaultRowHeight(Integer.parseInt(attVal));
        }
        attVal = objXml.getAttributeValue("selectMode", NS_TABLE);
    }

    private void fillColAttributes(int colIndex, Element objXml) {
        Object uo;
        Element e;
        IColumn col = this.table.addColumn(colIndex);
        if (col == null) {
            return;
        }
        String attVal = objXml.getAttributeValue("width", NS_TABLE);
        if (!this.isEmptyString(attVal)) {
            col.setWidth(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("key", NS_TABLE))) {
            col.setKey(attVal);
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("mergeable", NS_TABLE))) {
            col.setMergeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("resizeable", NS_TABLE))) {
            col.setResizeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("moveable", NS_TABLE))) {
            col.setMoveable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("group", NS_TABLE))) {
            col.setGroup(this.getBooleanFromString(attVal));
        }
        if ((e = objXml.getChild("UserObject", NS_TABLE)) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            col.setUserObject(uo);
        }
    }

    private void fillRowAttributes(IRow objTable, Element objXml) {
        Object uo;
        Element e;
        String attVal = objXml.getAttributeValue("height", NS_TABLE);
        if (!this.isEmptyString(attVal)) {
            objTable.setHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("mergeable", NS_TABLE))) {
            objTable.setMergeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("resizeable", NS_TABLE))) {
            objTable.setResizeable(this.getBooleanFromString(attVal));
        }
        if ((e = objXml.getChild("UserObject", NS_TABLE)) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            objTable.setUserObject(uo);
        }
    }

    private void fillCellAttributes(ICell objCell, Element objXml) {
        String attVal;
        Object obj;
        if (objXml.getChildren().size() == 0) {
            String attVal2 = objXml.getText();
            if (attVal2 != null) {
                objCell.setValue(attVal2);
            }
            return;
        }
        Element node = objXml.getChild("UserObject", NS_TABLE);
        if (node != null && (obj = ObjectUtil.stringToObject((String)(attVal = node.getText()))) != null) {
            objCell.getKDTCell().setUserObject(obj);
        }
        if ((node = objXml.getChild("Expression", NS_TABLE)) != null && !this.isEmptyString(attVal = node.getText())) {
            objCell.setExpressions(attVal);
        }
        if ((node = objXml.getChild("Value", NS_TABLE)) != null) {
            attVal = node.getText();
            obj = ObjectUtil.stringToObject((String)attVal);
            if (obj != null) {
                objCell.getKDTCell().setValue(obj);
            } else if (attVal != null) {
                objCell.getKDTCell().setValue(attVal);
            }
        }
    }

    private TableRelations getTableRelations() {
        if (this.tableRelations == null) {
            this.tableRelations = new TableRelations();
        }
        return this.tableRelations;
    }
}

