/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMark;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.NodeClickListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashSet;

public class CellTreeNode {
    public static int TREE_TYPE_COLUMN = 0;
    public static int TREE_TYPE_ROW = 1;
    private int mark = 13312;
    private int treeType = TREE_TYPE_COLUMN;
    private static final String SPAN = "   ";
    private Object value;
    private HashSet clickListeners;
    public static int TOPLEFT = 0;
    public static int BOTTOMRIGHT = 1;
    private int treeRootDirection = TOPLEFT;
    private int x = 0;
    private int y = 0;
    private int iconWidth = 0;

    public int getTreeLevel() {
        return KDTMark.getTreeLevel(this.mark);
    }

    public void setTreeLevel(int newValue) {
        this.mark = KDTMark.setTreeLevel(this.mark, newValue);
    }

    public void setTreeRootDirection(int direction) {
        this.treeRootDirection = direction;
    }

    public int getTreeType() {
        return this.treeType;
    }

    public void setTreeType(int newValue) {
        this.treeType = newValue;
    }

    public boolean isCollapse() {
        return KDTMark.isCollapse(this.mark);
    }

    public void setCollapse(boolean newValue) {
        this.mark = KDTMark.setCollapse(this.mark, newValue);
    }

    public boolean isHasChildren() {
        return KDTMark.isHasChildren(this.mark);
    }

    public void setHasChildren(boolean newValue) {
        this.mark = KDTMark.setHasChildren(this.mark, newValue);
    }

    public boolean isVirtualModel() {
        return KDTMark.isDummyModel(this.mark);
    }

    public void setVirtualModel(boolean newValue) {
        this.mark = KDTMark.setDummyModel(this.mark, newValue);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int level = this.getTreeLevel();
        for (int i = 0; i < level; ++i) {
            sb.append(SPAN);
        }
        if (this.getValue() != null) {
            sb.append(this.getValue().toString());
        }
        return sb.toString();
    }

    public void doClick(KDTable table, EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)anEvent;
            int px = mouseEvent.getX();
            int py = mouseEvent.getY();
            if (px >= this.x && px <= this.x + this.iconWidth && py >= this.y && py <= this.y + this.iconWidth) {
                this.doTreeClick(table);
                this.fireClick(table);
            }
        }
    }

    private void fireClick(KDTable table) {
        if (this.clickListeners == null) {
            return;
        }
        KDTable.XCell cell2 = (KDTable.XCell)table.getEditManager().getEditCell();
        int type = cell2.index.getType();
        for (NodeClickListener listener : this.clickListeners) {
            listener.doClick(this, cell2, type);
        }
    }

    public void addClickListener(NodeClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new HashSet();
        }
        this.clickListeners.add(listener);
    }

    public void doTreeClick(KDTable table) {
        this.doTreeClick(table, table.getEditManager().getEditCell());
    }

    public void doTreeClick(KDTable table, ICell currCell) {
        KDTable.XCell cell2 = (KDTable.XCell)currCell;
        if (cell2 == null || cell2.index == null) {
            return;
        }
        int type = cell2.index.getType();
        ICell fcell = null;
        if (this.getTreeType() == 0) {
            if (this.isHasChildren()) {
                boolean old = table.isRefresh();
                table.setRefresh(false);
                this.setCollapse(!this.isCollapse());
                int rowindex = 0;
                rowindex = this.treeRootDirection == TOPLEFT ? cell2.getRowIndex() + 1 : cell2.getRowIndex() - 1;
                int colindex = cell2.getColumnIndex();
                while (rowindex >= 0 && rowindex < table.getRowCount() && this.getCellLevel(table, rowindex, colindex, type) > this.getTreeLevel()) {
                    if (this.isCollapse()) {
                        table.getRow(rowindex).getStyleAttributes().setHided(true);
                    } else {
                        fcell = this.getFatherRow(table.getCell(rowindex, cell2.getColumnIndex()), table);
                        if (fcell != null) {
                            if (this.isCellCollapse(fcell)) {
                                table.getRow(rowindex).getStyleAttributes().setHided(true);
                            } else {
                                table.getRow(rowindex).getStyleAttributes().setHided(false);
                            }
                        } else {
                            table.getRow(rowindex).getStyleAttributes().setHided(false);
                        }
                    }
                    if (this.treeRootDirection == TOPLEFT) {
                        ++rowindex;
                        continue;
                    }
                    --rowindex;
                }
                table.setRefresh(old);
                table.repaint();
            }
        } else if (this.isHasChildren()) {
            table.setRefresh(false);
            this.setCollapse(!this.isCollapse());
            int rowindex = cell2.getRowIndex();
            int colindex = cell2.getColumnIndex() + 1;
            colindex = this.treeRootDirection == TOPLEFT ? cell2.getColumnIndex() + 1 : cell2.getColumnIndex() - 1;
            while (colindex >= 0 && colindex < table.getColumnCount() && this.getCellLevel(table, rowindex, colindex, type) > this.getTreeLevel()) {
                if (this.isCollapse()) {
                    table.getColumn(colindex).getStyleAttributes().setHided(true);
                } else {
                    fcell = this.getFatherCol(table.getCell(cell2.getRowIndex(), colindex), table);
                    if (fcell != null) {
                        if (this.isCellCollapse(fcell)) {
                            table.getColumn(colindex).getStyleAttributes().setHided(true);
                        } else {
                            table.getColumn(colindex).getStyleAttributes().setHided(false);
                        }
                    } else {
                        table.getColumn(colindex).getStyleAttributes().setHided(false);
                    }
                }
                if (this.treeRootDirection == TOPLEFT) {
                    ++colindex;
                    continue;
                }
                --colindex;
            }
            table.setRefresh(true);
            table.repaint();
        }
    }

    private ICell getFatherRow(ICell cell, KDTable table) {
        ICell fcell = null;
        for (int i = cell.getRowIndex() - 1; i >= 0 && this.getCellLevel(fcell = table.getCell(i, cell.getColumnIndex())) >= this.getCellLevel(cell); --i) {
        }
        return fcell;
    }

    private ICell getFatherCol(ICell cell, KDTable table) {
        ICell fcell = null;
        for (int i = cell.getColumnIndex() - 1; i >= 0 && this.getCellLevel(fcell = table.getCell(cell.getRowIndex(), i)) >= this.getCellLevel(cell); --i) {
        }
        return fcell;
    }

    private int getCellLevel(KDTable table, int r, int c, int type) {
        IRow row = null;
        row = type == 0 ? table.getHeadRow(r) : table.getRow(r);
        if (row != null) {
            ICell cell = row.getCell(c);
            return this.getCellLevel(cell);
        }
        return 0;
    }

    private int getCellLevel(ICell cell) {
        Object value;
        if (cell != null && (value = cell.getValue()) instanceof CellTreeNode) {
            CellTreeNode node = (CellTreeNode)value;
            return node.getTreeLevel();
        }
        return 0;
    }

    private boolean isCellCollapse(ICell cell) {
        Object value;
        if (cell != null && (value = cell.getValue()) instanceof CellTreeNode) {
            CellTreeNode node = (CellTreeNode)value;
            return node.isCollapse();
        }
        return false;
    }

    public void setIconPosition(int x, int y, int width) {
        this.x = x;
        this.y = y;
        this.iconWidth = width;
    }
}

