/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.IRows;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTStyleConstants;
import com.kingdee.bos.ctrl.kdf.table.KDTView;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;

public class KDTCornerView
extends KDTView {
    private static final long serialVersionUID = 3751015328844184711L;

    public KDTCornerView(KDTable table, KDTColumns columns, IRows rows) {
        super(table, columns, rows);
        this.viewType = 4;
    }

    public static void fillRectWithVerge(Graphics g, Rectangle rect, Color[] headVerges, Color backColor) {
        Color oldColor = g.getColor();
        int y = rect.y;
        int width = rect.x + rect.width - 1;
        g.setColor(headVerges[0]);
        g.drawLine(rect.x, y, width, y);
        g.setColor(headVerges[1]);
        g.drawLine(rect.x, y + 1, width, y + 1);
        g.setColor(headVerges[2]);
        g.drawLine(rect.x, y + 2, width, y + 2);
        g.setColor(backColor);
        g.fillRect(rect.x, y + 3, rect.width, rect.height - 5);
        y = rect.y + rect.height - 2;
        g.setColor(headVerges[3]);
        g.drawLine(rect.x, y, width, y);
        g.setColor(headVerges[4]);
        g.drawLine(rect.x, y + 1, width, y + 1);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(KDTStyleConstants.GRID_LINE_COLOR);
        g2d.drawLine(0, rect.height - 1, rect.width, rect.height - 1);
        g2d.drawLine(rect.width - 1, 0, rect.width - 1, rect.height);
        g.setColor(oldColor);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        Color[] headVerges = this.table.getHeadVergesColor();
        KDTCornerView.fillRectWithVerge(g, rect, headVerges, this.table.getHeadStyle().getBackground());
        Iterator iter = this.table.getSelectManager().getBlocks().iterator();
        while (iter.hasNext()) {
            if (((KDTSelectBlock)iter.next()).getMode() != 8) continue;
            g2d.setPaint(this.table.getSelectManager().getSelectColor());
            g2d.fill(rect);
            break;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.table.getEditManager().isEditing() && 0 != this.table.getEditManager().stopEditing()) {
            return;
        }
        if (!this.table.isFocusOwner()) {
            this.table.requestFocusInWindow();
        }
        switch (this.status) {
            case 0: {
                KDTSelectManager sm = this.table.getSelectManager();
                if (!sm.isMultipleSelectable()) break;
                KDTSelectBlock sb = new KDTSelectBlock(0, 0, this.table.getRowCount3() - 1, this.table.getColumnCount() - 1, 8);
                sm.select(sb, true);
                break;
            }
            case 1: {
                this.colResizeBegin();
                break;
            }
            case 3: {
                break;
            }
        }
    }

    @Override
    protected boolean isAboveBottomBorder(int y) {
        return false;
    }

    @Override
    protected boolean isAboveRightBorder(int x) {
        return x > this.getWidth() - 2;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        switch (this.status) {
            case 2: {
                this.setHorizonViewsWidth(x);
                this.table.doLayout();
                this.table.repaint();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public void setHorizonViewsWidth(int width) {
        this.table.getIndexColumn().setWidth(width);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        switch (this.status) {
            case 0: {
                if (this.isAboveBottomBorder(y)) {
                    this.setStatus(3);
                }
                if (!this.isAboveRightBorder(x) || this.table.getIndexColumn().getWidthAdjustMode() != 1) break;
                this.setStatus(1);
                break;
            }
            case 1: {
                if (x - this.activeColRight < 2 && x - this.activeColRight > -2) break;
                this.setStatus(0);
                break;
            }
            case 3: {
                if (y - this.activeRowBottom < 2 && y - this.activeRowBottom > -2) break;
                this.setStatus(0);
                break;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.fireCellClick(e, -1, -1);
    }

    @Override
    protected void fireCellClick(MouseEvent e, int rowIndex, int colIndex) {
        KDTMouseEvent mouseEvent = new KDTMouseEvent(this.table, e, rowIndex, colIndex, 3);
        this.table.fireTableClick(mouseEvent);
    }
}

