/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.table.BasicView;
import com.kingdee.bos.ctrl.kdf.table.ITipContentProvider;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTLayoutInfo;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.TipPanel;
import com.kingdee.bos.ctrl.swing.KDDBntScrollBar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;

public class KDTHorizon
extends KDTLayoutInfo
implements AdjustmentListener,
ITipContentProvider {
    public KDTHorizon(KDTable table) {
        this(table, false);
    }

    public KDTHorizon(KDTable table, boolean hasScrollBar) {
        super(table, hasScrollBar);
        this.setTrackable(true);
    }

    public KDTHorizon(KDTable table, JScrollBar hBar) {
        super(table);
        if (0 != hBar.getOrientation()) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u4e3aKDTHorizon\u5bf9\u8c61\u8bbe\u7f6e\u975e\u6c34\u5e73\u7684\u6eda\u52a8\u6761");
        }
        this.setScrollBar(hBar);
        this.setTrackable(true);
    }

    @Override
    public JScrollBar getScrollBar() {
        if (this.scrollable && this.scrollBar == null) {
            KDDBntScrollBar hBar = new KDDBntScrollBar(0);
            this.setScrollBar((JScrollBar)hBar);
        }
        return this.scrollBar;
    }

    @Override
    public void setScrollBar(JScrollBar scrollBar) {
        scrollBar.addAdjustmentListener(this);
        super.setScrollBar(scrollBar);
        if (this.table.getLayoutManager().isToolTipVisible()) {
            this.getToolTip().addComponent(scrollBar, this);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.table.getLayoutManager().isToolTipVisible()) {
            this.getToolTip().setText(LanguageManager.getLangMessage((String)"column", KDTHorizon.class, (String)"Column:") + String.valueOf(e.getValue() + 1));
        }
        JScrollBar sb = (JScrollBar)e.getSource();
        if (!this.isTrackable() && sb.getValueIsAdjusting()) {
            return;
        }
        if (this.first == e.getValue()) {
            return;
        }
        if (!sb.getValueIsAdjusting()) {
            int index;
            int cols = this.table.getColumns().size();
            int index2 = index = e.getValue();
            while (index2 < cols && index2 > 0 && this.table.getColumns().getColumnWidth(index2) <= 0) {
                if (index > this.first) {
                    ++index2;
                    continue;
                }
                --index2;
            }
            if (index != index2) {
                if (sb != null) {
                    DefaultBoundedRangeModel model = (DefaultBoundedRangeModel)sb.getModel();
                    if (index2 + model.getExtent() > model.getMaximum()) {
                        index2 = model.getMaximum() - model.getExtent();
                        this.scrollToPosition2(index2);
                        this.table.repaint();
                        return;
                    }
                    sb.setValue(index2);
                }
                return;
            }
        }
        this.scrollToPosition2(e.getValue());
        this.table.repaint();
    }

    private void scrollToPosition2(int index) {
        int cols = this.table.getColumns().size();
        if (index < 0 || index >= cols) {
            return;
        }
        if (this.table.getEditManager().isEditing()) {
            this.table.getEditManager().stopEditing();
        }
        this.setFirst(index);
        this.repaint();
    }

    public void scrollToPosition(int index) {
        if (!this.isEnable()) {
            return;
        }
        if (index >= this.table.getColumns().size()) {
            index = this.table.getColumns().size() - 1;
        }
        if (index < 0) {
            index = 0;
        }
        if (this.scrollBar == null) {
            return;
        }
        if (index >= this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount()) {
            int block = this.scrollBar.getMaximum() - index - 1;
            if (block <= 0) {
                this.scrollBar.setVisibleAmount(0);
                this.scrollBar.setBlockIncrement(1);
            } else {
                this.scrollBar.setVisibleAmount(block);
                this.scrollBar.setBlockIncrement(block);
            }
        }
        this.scrollBar.setValue(index);
    }

    public void scrollToPrevUnit() {
        this.scrollToPosition(this.getFirst() - 1);
    }

    public void scrollToNextUnit() {
        this.scrollToPosition(this.getFirst() + 1);
    }

    public void scrollToPrevBlock() {
        this.scrollToPosition(this.getFirst() - 1);
    }

    public void scrollToNextBlock() {
        this.scrollToPosition(this.getLast2());
    }

    @Override
    public int getLast() {
        if (this.last == -1) {
            this.refresh();
        }
        return this.last;
    }

    @Override
    public int getLast2() {
        if (this.last == -1) {
            this.refresh();
        }
        return this.last2;
    }

    @Override
    protected void refresh() {
        if (!this.isCanRefresh()) {
            return;
        }
        this.calculateLast();
        this.adjustScrollBar(this.first);
    }

    void calculateLast() {
        int h;
        KDTColumns cols = this.table.getColumns();
        int colIndex = this.first;
        int hs = 0;
        while ((h = cols.getColumnWidth(colIndex)) >= 0 && (hs += h) < this.span) {
            ++colIndex;
        }
        while (cols.getColumnWidth(colIndex + 1) == 0) {
            ++colIndex;
        }
        if (colIndex == this.first && h == -1) {
            this.last = -2;
            this.last2 = -2;
        } else if (h == -1) {
            this.last = colIndex - 1;
            this.last2 = this.last + 1;
        } else {
            this.last = colIndex;
            this.last2 = hs == this.span ? this.last + 1 : this.last;
        }
    }

    public void scrollToShowCol(int colIndex) {
        int firstIndex;
        if (this.getFirst() <= colIndex && this.getLast2() > colIndex) {
            return;
        }
        if (this.getFirst() > colIndex) {
            this.scrollToPosition(colIndex);
            return;
        }
        int width = this.getSpan();
        if (width <= 0) {
            return;
        }
        int tableHeight = width;
        int colWidth = 0;
        for (firstIndex = colIndex; firstIndex >= 0; --firstIndex) {
            colWidth = this.table.getColumns().getColumnWidth(firstIndex);
            if ((width -= colWidth) >= 0) continue;
            if (tableHeight > colWidth) break;
            --firstIndex;
            break;
        }
        this.scrollToPosition(++firstIndex);
    }

    public void repaint() {
        if (!this.table.enableRepaint) {
            return;
        }
        int vCount = this.table.getVerticalCount();
        for (int i = 0; i < vCount; ++i) {
            BasicView view = this.table.getViewManager().getView(i, this.index);
            view.updateBounds(false);
            view.repaint();
        }
    }

    @Override
    protected int getVisibleAmount() {
        int colIndex;
        int firstCol = this.getFirstInAll();
        int lastCol = this.getLastInAll();
        if (lastCol < 0) {
            lastCol = 0;
        }
        int width = 0;
        for (colIndex = lastCol; colIndex >= firstCol && (width += this.table.getColumns().getColumnWidth(colIndex)) <= this.span; --colIndex) {
        }
        int visible = lastCol - colIndex;
        return visible <= 0 ? 1 : visible;
    }

    @Override
    public void setTipContent(TipPanel tip, MouseEvent evt) {
    }

    @Override
    public Object clone() {
        JScrollBar sb = this.getScrollBar();
        if (sb != null) {
            sb = KDTLayoutInfo.createScrollBar(sb.getClass(), 0);
        }
        KDTHorizon horizon = new KDTHorizon(this.table, sb);
        return horizon;
    }

    @Override
    public int getFirstInAll() {
        if (this.firstInAll == -1) {
            return 0;
        }
        return super.getFirstInAll();
    }

    @Override
    public int getLastInAll() {
        if (this.lastInAll == -1) {
            return this.table.getColumnCount() - 1;
        }
        return super.getLastInAll();
    }
}

