/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.DefaultProgressImpl;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IExceptionHandler;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableXmlTrans;
import com.kingdee.bos.ctrl.kdf.table.Kds2Kdt;
import com.kingdee.bos.ctrl.kdf.table.Kdt2Kds;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class KDTIOManager {
    public static final int ALL = 15;
    public static final int STYLE = 1;
    public static final int VALUE = 2;
    public static final int FORMULA = 4;
    public static final int USEROBJECT = 8;
    private KDTable table;
    private boolean expandedOnly;
    protected String tempFileDirection;
    protected IExceptionHandler exceptionHandler;
    private boolean mergeExportable = true;
    private boolean memoryCallbackWhenExport;
    private int startNumber = 0;
    private int fileCount = 0;
    private boolean display = false;
    private int exportSize = 1999;
    private int exportTime = 0;
    private Thread exportThread;
    private Thread freshThread;
    private boolean exporting = false;
    private long sum = 0L;

    static boolean isAll(int mark) {
        return mark == 15;
    }

    static boolean isStyle(int mark) {
        return (mark & 1) == 1;
    }

    static boolean isValue(int mark) {
        return (mark & 2) == 2;
    }

    static boolean isFormula(int mark) {
        return (mark & 4) == 4;
    }

    static boolean isUserObject(int mark) {
        return (mark & 8) == 8;
    }

    public KDTIOManager(KDTable table) {
        this.table = table;
    }

    public boolean isMergeExportable() {
        return this.mergeExportable;
    }

    public void setMergeExportable(boolean mergeExportable) {
        this.mergeExportable = mergeExportable;
    }

    public void load(InputStream byteStream) {
        KDF kdf = null;
        try {
            kdf = new KDF(byteStream);
        }
        catch (KDFException e) {
            e.printStackTrace();
        }
        this.parseDefaultTable(kdf);
    }

    public void load(Reader charStream) {
        KDF kdf = null;
        try {
            kdf = new KDF(charStream);
        }
        catch (KDFException e) {
            e.printStackTrace();
        }
        this.parseDefaultTable(kdf);
    }

    public void parseDefaultTable(KDF kdf) {
        boolean formatOnly = this.isFormatOnly();
        if (!formatOnly) {
            this.table.removeColumns();
            this.table.setRowCount(-1);
        }
        KDTableXmlTrans trans = new KDTableXmlTrans();
        trans.readDefaultTableFromFile(this.table, kdf);
    }

    public void load(String fileName) {
        KDF kdf = null;
        try {
            kdf = new KDF(fileName);
        }
        catch (KDFException e) {
            e.printStackTrace();
        }
        this.parseDefaultTable(kdf);
    }

    public void save(String fileName) {
        KDF kdf = this.getKDF();
        kdf.saveToFile(fileName);
    }

    public void save(Writer writer) {
        KDF kdf = this.getKDF();
        kdf.save(writer);
    }

    public void save(OutputStream out) {
        KDF kdf = this.getKDF();
        kdf.save(out);
    }

    private KDF getKDF() {
        KDF kdf = new KDF();
        kdf.addTable((IDObject)this.table);
        this.table.getPrintManager().saveToKDF(kdf);
        return kdf;
    }

    public void parseFromKDS(KDSSheet sheet) {
        this.parseFromKDS(sheet, 0);
    }

    public void parseFromKDS(KDSSheet sheet, int headRowCount) {
        this.parseFromKDS(sheet, headRowCount, true);
    }

    public void parseFromKDS(KDSSheet sheet, int headRowCount, boolean overwrite) {
        this.parseFromKDS(sheet, headRowCount, overwrite, 15);
    }

    public void parseFromKDS(KDSSheet sheet, int headRowCount, boolean overwrite, int mark) {
        Kds2Kdt transer = new Kds2Kdt();
        transer.parse(this.table, sheet, headRowCount, overwrite, mark);
    }

    public void parseFromKDSWithExcelHead(KDSSheet sheet) {
        this.parseFromKDSWithExcelHead(sheet, true);
    }

    public void parseFromKDSWithExcelHead(KDSSheet sheet, boolean overwrite) {
        this.parseFromKDSWithExcelHead(sheet, overwrite, 15);
    }

    public void parseFromKDSWithExcelHead(KDSSheet sheet, boolean overwrite, int mark) {
        this.parseFromKDS(sheet, 0, overwrite, mark);
        this.table.setHeadDisplayMode(1);
    }

    void loadFromExcel(String fileName, int headRowCount) {
        KDSBook book = POIXlsReader.parse((String)fileName);
        this.parseFromKDS(book.getSheet((Object)new Integer(0)), headRowCount);
    }

    void loadFromExcel(String fileName, int headRowCount, String sheetName) {
        KDSBook book = POIXlsReader.parse((String)fileName);
        this.parseFromKDS(book.getSheet((Object)sheetName), headRowCount);
    }

    void loadFromExcel(InputStream in, int headRowCount) {
        KDSBook book = POIXlsReader.parse((InputStream)in);
        this.parseFromKDS(book.getSheet((Object)new Integer(0)), headRowCount);
    }

    void loadFromExcel(InputStream in, int headRowCount, String sheetName) {
        KDSBook book = POIXlsReader.parse((InputStream)in);
        this.parseFromKDS(book.getSheet((Object)sheetName), headRowCount);
    }

    public KDSBook saveToKDS() {
        return this.saveToKDS(this.table.getID());
    }

    public KDSBook saveToKDS(String bookName) {
        return this.saveToKDS(bookName, false, false);
    }

    public KDSBook saveToKDS(String bookName, boolean withHead, boolean withIndex) {
        KDSBook book = new KDSBook(bookName);
        try {
            book.addSheet(null, this.saveToKDSSheet(book, withHead, withIndex, this.table.getName()));
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
        return book;
    }

    public KDSSheet saveToKDSSheet(KDSBook book, boolean withHead, boolean withIndex, String sheetName) {
        return this.saveToKDSSheet(book, withHead, withIndex, true, sheetName);
    }

    public KDSSheet saveToKDSSheet(KDSBook book, boolean withHead, boolean withIndex, boolean withHiddenCol, String sheetName) {
        return this.saveToKDSSheet(book, withHead, withIndex, withHiddenCol, sheetName, null);
    }

    public KDSSheet saveToKDSSheet(KDSBook book, boolean withHead, boolean withIndex, boolean withHiddenCol, String sheetName, KDTRange range) {
        Kdt2Kds trans = new Kdt2Kds(this.table, book);
        trans.setWithHead(withHead);
        trans.setWithIndexColumn(withIndex);
        trans.setWithHiddenCol(withHiddenCol);
        trans.setRange(range);
        return trans.transform(sheetName);
    }

    public void saveToExcel(String fileName) {
        ExportManager man = new ExportManager();
        if (!this.mergeExportable) {
            man.setExporterParmeter(ExporterParameter.EXPORT_MERGE_BLOCKS, (Object)"FALSE");
        }
        KDSBook book = this.table.getIOManager().saveToKDS();
        try {
            man.exportToExcel(book, fileName);
        }
        catch (POIExportException pOIExportException) {
            // empty catch block
        }
    }

    void appendToExcel(String fileName, boolean withHead, boolean withIndex, String sheetName) {
        File file = new File(fileName);
        KDSBook book = null;
        book = file.exists() ? POIXlsReader.parse((String)fileName) : new KDSBook(file.getName());
        try {
            book.addSheet(null, this.saveToKDSSheet(book, withHead, withIndex, sheetName));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        ExportManager man = new ExportManager();
        if (!this.mergeExportable) {
            man.setExporterParmeter(ExporterParameter.EXPORT_MERGE_BLOCKS, (Object)"FALSE");
        }
        try {
            man.exportToExcel(book, fileName);
        }
        catch (POIExportException pOIExportException) {
            // empty catch block
        }
    }

    void appendToExcel(InputStream in, OutputStream out, boolean withHead, boolean withIndex, String sheetName) {
        KDSBook book = POIXlsReader.parse((InputStream)in);
        try {
            book.addSheet(null, this.saveToKDSSheet(book, withHead, withIndex, sheetName));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        ExportManager man = new ExportManager();
        if (!this.mergeExportable) {
            man.setExporterParmeter(ExporterParameter.EXPORT_MERGE_BLOCKS, (Object)"FALSE");
        }
        try {
            man.exportToExcelStream(book, out);
        }
        catch (POIExportException pOIExportException) {
            // empty catch block
        }
    }

    void appendToExcel(String fileName) {
        this.appendToExcel(fileName, true, false, this.table.getID());
    }

    void appendToExcel(InputStream in, OutputStream out) {
        this.appendToExcel(in, out, true, false, this.table.getID());
    }

    boolean isFormatOnly() {
        Object obj = this.table.getClientProperty("formatOnly");
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public String getFormatXml() {
        Object obj = this.table.getClientProperty("formatOnly");
        this.table.putClientProperty("formatOnly", true);
        StringWriter writer = new StringWriter();
        this.save(writer);
        this.table.putClientProperty("formatOnly", obj);
        return writer.toString();
    }

    public void setFormatXml(String formatXml) {
        if (StringUtil.isEmptyString((String)formatXml)) {
            return;
        }
        Object obj = this.table.getClientProperty("formatOnly");
        this.table.putClientProperty("formatOnly", true);
        this.load(new StringReader(formatXml));
        this.table.putClientProperty("formatOnly", obj);
    }

    public boolean isExpandedOnly() {
        return this.expandedOnly;
    }

    public void setExpandedOnly(boolean expandedOnly) {
        this.expandedOnly = expandedOnly;
    }

    public int getTableRowCount() {
        if (this.isExpandedOnly()) {
            return this.table.getExpandedRowCount();
        }
        return this.table.getRowCount1();
    }

    public int getTableColumnCount() {
        if (this.isExpandedOnly()) {
            return this.table.getExpandedColumnCount();
        }
        return this.table.getColumnCount();
    }

    private boolean exportColumnConfirm(KDTable table, boolean isSelect, KDTRange range) {
        if (this.getBlockColumnCount(isSelect, range) > 256) {
            String msg2 = LanguageManager.getLangMessage((String)"export2Excel.maxColumnLimit", KDTable.class, (String)"");
            KDOptionPane.showMessageDialog((Component)table, (Object)msg2);
            return false;
        }
        return true;
    }

    private int getBlockColumnCount(boolean isSelect, KDTRange range) {
        if (range == null) {
            int tableColumnCount;
            int cnt = tableColumnCount = this.table.getColumnCount();
            for (int i = 0; i < tableColumnCount; ++i) {
                if (!this.table.getColumn(i).getStyleAttributes().isHided()) continue;
                --cnt;
            }
            return cnt;
        }
        KDTBlock block = (KDTBlock)range.get(0);
        if (!isSelect || block.getMode() == 8 || block.getMode() == 2) {
            return this.table.getColumnCount();
        }
        return block.getRight() - block.getLeft() + 1;
    }

    public void exportExcelToTempFile(boolean isSelect) {
        String fileName = this.exportExcelToFile(isSelect, null);
        if (fileName != null) {
            this.openFile(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportExcelToFile(boolean isSelect, File file) {
        block15: {
            boolean isRefresh = this.table.isRefresh();
            boolean enablePaint = this.table.enableRepaint;
            this.table.setRefresh(false);
            this.table.enableRepaint(false);
            try {
                File tempFile;
                KDTRange range = null;
                if (isSelect) {
                    range = this.table.getSelectManager().toRange();
                    if ((range = range.getSequenceRange()) == null) {
                        String msg = LanguageManager.getLangMessage((String)"export2Excel.error", KDTable.class, (String)"");
                        KDOptionPane.showMessageDialog((Component)this.table, (Object)msg);
                        String string = null;
                        return string;
                    }
                }
                File file2 = tempFile = file != null ? file : KDTMenuManager.createTempFile(this.getTempFileDirection());
                if (tempFile == null) break block15;
                String tempFileName = tempFile.getAbsolutePath();
                KDSSheet sheet = null;
                ExportManager man = new ExportManager();
                if (!this.mergeExportable) {
                    man.setExporterParmeter(ExporterParameter.EXPORT_MERGE_BLOCKS, (Object)"FALSE");
                }
                KDSBook book = null;
                book = new KDSBook("kdtable export");
                if (!this.exportColumnConfirm(this.table, isSelect, range)) {
                    String string = null;
                    return string;
                }
                KDTDataRequestManager dataRequester = this.table.getDataRequestManager();
                boolean originSettings = dataRequester.isExportMemoryCallback();
                dataRequester.setExporting(true);
                dataRequester.setExportMemoryCallback(false);
                sheet = this.getKDSSheet(book, isSelect);
                dataRequester.setExportMemoryCallback(originSettings);
                try {
                    book.addSheet(null, sheet);
                }
                catch (Exception e1) {
                    if (this.getExceptionHandler() != null) {
                        this.getExceptionHandler().handle(e1);
                    }
                    String string = null;
                    this.table.setRefresh(isRefresh);
                    this.table.enableRepaint(enablePaint);
                    this.table.getDataRequestManager().setExporting(false);
                    return string;
                }
                try {
                    man.exportToExcel(book, tempFileName);
                }
                catch (POIExportException pee) {
                    pee.printStackTrace();
                }
                String string = tempFileName;
                return string;
            }
            finally {
                this.table.setRefresh(isRefresh);
                this.table.enableRepaint(enablePaint);
                this.table.getDataRequestManager().setExporting(false);
            }
        }
        return null;
    }

    private void openFile(String tempFileName) {
        block5: {
            try {
                KDTMenuManager.openFileInExcel(tempFileName);
            }
            catch (IOException e2) {
                KDFileChooser fileChooser = this.getFileChooser();
                int result = fileChooser.showSaveDialog((Component)this.table);
                if (result != 0) break block5;
                File dest = this.getSelectedFile(fileChooser);
                try {
                    File src = new File(tempFileName);
                    if (dest.exists()) {
                        dest.delete();
                    }
                    src.renameTo(dest);
                }
                catch (Exception e3) {
                    if (this.getExceptionHandler() == null) break block5;
                    this.getExceptionHandler().handle(e3);
                }
            }
        }
    }

    public void exportExcelToSpreadSheetFile(boolean isSelect) {
        block14: {
            File tempFile;
            KDTRange range = null;
            if (isSelect) {
                range = this.table.getSelectManager().toRange();
                if ((range = range.getSequenceRange()) == null) {
                    String msg = LanguageManager.getLangMessage((String)"export2Excel.error", KDTable.class, (String)"");
                    KDOptionPane.showMessageDialog((Component)this.table, (Object)msg);
                    return;
                }
            }
            if ((tempFile = KDTMenuManager.createSpreadSheetTempFile(this.getTempFileDirection())) != null) {
                String tempFileName = tempFile.getAbsolutePath();
                KDSSheet sheet = null;
                ExportManager man = new ExportManager();
                KDSBook book = null;
                book = new KDSBook("kdtable export");
                if (!this.exportColumnConfirmFor2007(this.table, isSelect, range)) {
                    return;
                }
                sheet = this.getKDSSheet(book, isSelect);
                try {
                    book.addSheet(null, sheet);
                }
                catch (Exception e1) {
                    if (this.getExceptionHandler() != null) {
                        this.getExceptionHandler().handle(e1);
                    }
                    return;
                }
                try {
                    man.exportToSpreadSheet(book, tempFileName);
                }
                catch (POIExportException pee) {
                    pee.printStackTrace();
                }
                try {
                    KDTMenuManager.openFileInExcel(tempFileName);
                }
                catch (IOException e2) {
                    KDFileChooser fileChooser = this.getFileChooser();
                    int result = fileChooser.showSaveDialog((Component)this.table);
                    if (result != 0) break block14;
                    File dest = this.getSelectedFile(fileChooser);
                    try {
                        File src = new File(tempFileName);
                        if (dest.exists()) {
                            dest.delete();
                        }
                        src.renameTo(dest);
                    }
                    catch (Exception e3) {
                        if (this.getExceptionHandler() == null) break block14;
                        this.getExceptionHandler().handle(e3);
                    }
                }
            }
        }
    }

    private boolean exportColumnConfirmFor2007(KDTable table, boolean isSelect, KDTRange range) {
        if (this.getBlockColumnCount(isSelect, range) > 16384) {
            KDOptionPane.showMessageDialog((Component)table, (Object)"\u4e0d\u80fd\u5bfc\u51fa\u8d85\u8fc716384\u5217\u7684\u8868\u683c\uff0c\u56e0\u4e3aExcel 2007\u6700\u591a\u53ea\u80fd\u63a5\u53d716384\u5217\u3002");
            return false;
        }
        return true;
    }

    File getSelectedFile(KDFileChooser fileChooser) {
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            String path = file.getAbsolutePath();
            FileFilter ext = fileChooser.getFileFilter();
            if (ext != null && !ext.accept(file)) {
                if (ext instanceof ExcelFileFilter) {
                    path = path + ".xls";
                }
                file = new File(path);
            }
        }
        return file;
    }

    protected KDSSheet getKDSSheet(KDSBook book, boolean isSelect) {
        if (!isSelect) {
            return this.saveToKDSSheet(book, true, false, false, "sheet1");
        }
        return this.saveToKDSSheet(book, true, false, false, "sheet1", this.table.getSelectManager().toRange());
    }

    protected KDSSheet getKDSSheet(KDSBook book, int rowCount) {
        KDTRange range = new KDTRange();
        range.add(new KDTSelectBlock(0, 0, rowCount - 1, this.table.getColumnCount() - 1));
        return this.saveToKDSSheet(book, true, false, false, "sheet1", range);
    }

    public IExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(IExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    KDFileChooser getFileChooser() {
        String title = LanguageManager.getLangMessage((String)"FileChooserTitle", KDTMenuManager.class, (String)"Save As...");
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        return fileChooser;
    }

    public String getTempFileDirection() {
        return this.tempFileDirection;
    }

    public void setTempFileDirection(String tempFileDirection) {
        this.tempFileDirection = tempFileDirection;
    }

    public boolean isMemoryCallbackWhenExport() {
        return this.memoryCallbackWhenExport;
    }

    public void setMemoryCallbackWhenExport(boolean callback) {
        this.memoryCallbackWhenExport = callback;
    }

    public void exportLargeDataTable(final DefaultExportParam constants) {
        long temp;
        this.exporting = true;
        long max = Runtime.getRuntime().maxMemory();
        long free = Runtime.getRuntime().freeMemory();
        long gc = temp = max - free;
        long cgc = -1L;
        int gcTime = 0;
        do {
            if (cgc != -1L) {
                gc = cgc;
            }
            System.gc();
        } while ((cgc = (max = Runtime.getRuntime().maxMemory()) - (free = Runtime.getRuntime().freeMemory())) < gc && ++gcTime < 500);
        if (this.freshThread == null || !this.freshThread.isAlive()) {
            this.freshThread = new Thread("\u5bfc\u51fa\u5237\u65b0\u8fde\u63a5\u7ebf\u7a0b:" + this.exportTime + "\u53f7"){

                @Override
                public void run() {
                    try {
                        while (KDTIOManager.this.exporting) {
                            Thread.sleep(30000L);
                            constants.getProgressListener().updateConnectTime();
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        System.out.println("------------------------\u5bfc\u51fa\u8fde\u63a5\u4fdd\u6301\u7ebf\u7a0b\u5f02\u5e38-----------------------");
                    }
                }
            };
            this.freshThread.start();
        }
        final ProgressListener progress = constants.getProgressListener();
        long max2 = Runtime.getRuntime().maxMemory();
        long free2 = Runtime.getRuntime().freeMemory();
        String maxMemeryCapacity = "\u5f53\u524d\u6700\u5927\u53ef\u7528\u5185\u5b58:" + max2 / 1024L / 1024L + "M";
        System.out.println(maxMemeryCapacity);
        String freeMemeryCapacity = "\u5f53\u524d\u7a7a\u95f2\u5185\u5b58:" + free2 / 1024L / 1024L + "M";
        System.out.println(freeMemeryCapacity);
        String takenMemery = "\u5f53\u524d\u5360\u7528\u5185\u5b58:" + (max2 - free2) / 1024L / 1024L + "M";
        System.out.println(takenMemery);
        String pageCount = "\u6bcf\u4e2a\u6587\u4ef6\u5bfc\u51fa\u884c\u6570:" + constants.threshold;
        System.out.println(pageCount);
        String minCapacity = "\u9884\u8ba1\u5360\u7528\u5185\u5b58:" + constants.threshold * this.table.getColumnCount() / 5000 + "M";
        System.out.println(minCapacity);
        this.exportThread = new Thread("\u5bfc\u51fa\u7ebf\u7a0b:" + this.exportTime + "\u53f7"){

            @Override
            public void run() {
                try {
                    KDTIOManager.this.table.enableRepaint(false);
                    KDTIOManager.this.exportLargeDataTableImpl(constants.isOnlySelected(), constants.isExcel2007(), progress, constants.getThreshold(), constants.getFileName(), constants.getDirPath());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                KDTIOManager.this.exporting = false;
                KDTIOManager.this.table.enableRepaint(true);
                KDTIOManager.this.startNumber = 0;
                KDTIOManager.this.fileCount = 0;
                if (KDTIOManager.this.isMemoryCallbackWhenExport()) {
                    KDTIOManager.this.table.removeRows();
                }
                KDTIOManager.this.table.reLayoutAndPaint();
            }
        };
        progress.setExportThread(this.exportThread);
        this.exportThread.start();
        progress.display(true);
    }

    private void exportLargeDataTableImpl(boolean onlySelected, boolean isExcel2007, ProgressListener progress, int dataNumber, String userFileName, String userDirPath) throws Exception {
        int size;
        int i;
        String openPath;
        String fileName;
        if (!isExcel2007) {
            if (!this.exportColumnConfirm(this.table, onlySelected, null)) {
                progress.display(false);
                return;
            }
        } else if (!this.exportColumnConfirmFor2007(this.table, onlySelected, null)) {
            progress.display(false);
            return;
        }
        KDTRange range = null;
        if (onlySelected) {
            range = this.table.getSelectManager().toRange();
            if ((range = range.getSequenceRange()) == null) {
                String msg = LanguageManager.getLangMessage((String)"export2Excel.error", KDTable.class, (String)"");
                KDOptionPane.showMessageDialog((Component)this.table, (Object)msg);
                progress.display(false);
                return;
            }
        }
        ExportManager man = new ExportManager();
        if (!this.mergeExportable) {
            man.setExporterParmeter(ExporterParameter.EXPORT_MERGE_BLOCKS, (Object)"FALSE");
        }
        KDSBook book = new KDSBook("kdtable export");
        int rowCount = this.table.getRowCount();
        KDTDataRequestManager manager = this.table.getDataRequestManager();
        boolean exportMemoryCallback = manager.isExportMemoryCallback();
        manager.setExporting(true);
        manager.setExportMemoryCallback(false);
        userFileName = userFileName + new SimpleDateFormat("yyyyMMdd").format(new Date());
        if (range == null) {
            if (rowCount == -1) {
                boolean shouldEnd = false;
                int start = 0 + this.startNumber;
                int end = --dataNumber;
                while (!shouldEnd) {
                    fileName = !isExcel2007 ? userFileName + this.getFileCount(this.fileCount + 1) + ".xls" : userFileName + this.getFileCount(this.fileCount + 1) + ".xml";
                    openPath = userDirPath + File.separator + fileName;
                    progress.addTask(fileName);
                    progress.startTask(fileName);
                    this.display = true;
                    Object row = null;
                    if (row == null || progress.isUserAborted()) {
                        shouldEnd = true;
                    }
                    if (!isExcel2007) {
                        this.writeFile(start, end, book, man, openPath);
                    } else {
                        this.writeFile2007(start, end, book, man, openPath);
                    }
                    book.removeAll();
                    this.doMemeryCallBack(manager, start, end, false);
                    ++this.fileCount;
                    progress.stopTask(fileName, openPath);
                    this.startNumber = start = end + 1;
                    end = start + dataNumber;
                }
            } else {
                int num = 0;
                if (this.startNumber == 0) {
                    num = this.fileCount = rowCount / dataNumber;
                    if (rowCount % dataNumber != 0) {
                        ++num;
                    }
                    if (!isExcel2007) {
                        for (i = 0; i < num; ++i) {
                            fileName = userFileName + this.getFileCount(i + 1) + ".xls";
                            progress.addTask(fileName);
                        }
                    } else {
                        for (i = 0; i < num; ++i) {
                            fileName = userFileName + this.getFileCount(i + 1) + ".xml";
                            progress.addTask(fileName);
                        }
                    }
                    progress.setTaskNumber(num);
                    --dataNumber;
                    this.fileCount = 0;
                }
                this.display = true;
                int end = dataNumber;
                int start = 0;
                for (int i2 = this.fileCount; i2 < num && !progress.isUserAborted(); ++i2) {
                    if (!isExcel2007) {
                        fileName = userFileName + this.getFileCount(i2 + 1) + ".xls";
                        openPath = userDirPath + File.separator + fileName;
                    } else {
                        fileName = userFileName + this.getFileCount(i2 + 1) + ".xml";
                        openPath = userDirPath + File.separator + fileName;
                    }
                    progress.startTask(fileName);
                    if (!isExcel2007) {
                        this.writeFile(start, end, book, man, openPath);
                    } else {
                        this.writeFile2007(start, end, book, man, openPath);
                    }
                    book.removeAll();
                    this.doMemeryCallBack(manager, start, end, false);
                    this.startNumber = start = end + 1;
                    end = Math.min(start + dataNumber, rowCount);
                    progress.stopTask(fileName, openPath);
                }
            }
        } else {
            size = range.size();
            rowCount = 0;
            --dataNumber;
            int index = 1;
            int firstStart = 0;
            for (int i3 = 0; i3 < size && !progress.isUserAborted(); ++i3) {
                IBlock b = (IBlock)range.get(i3);
                int last = b.getBottom();
                int start = firstStart = b.getTop();
                int end = Math.min(last, start + dataNumber);
                rowCount = last - start + 1;
                fileName = userFileName + i3;
                openPath = userDirPath + File.separator + fileName;
                int fileCount = rowCount / (dataNumber + 1);
                if (rowCount % (dataNumber + 1) != 0) {
                    ++fileCount;
                }
                for (int j = 0; j < fileCount; ++j) {
                    fileName = !isExcel2007 ? userFileName + this.getFileCount(index) + ".xls" : userFileName + this.getFileCount(index) + ".xml";
                    openPath = userDirPath + File.separator + fileName;
                    progress.addTask(fileName);
                    progress.startTask(fileName);
                    this.display = true;
                    if (!isExcel2007) {
                        this.writeFile(start, end, book, man, openPath);
                    } else {
                        this.writeFile2007(start, end, book, man, openPath);
                    }
                    book.removeAll();
                    if (end - firstStart > this.table.getDataRequestManager().getPageRowCount()) {
                        this.doMemeryCallBack(manager, start, end, false);
                    }
                    this.startNumber = start = end + 1;
                    end = Math.min(last, start + dataNumber);
                    progress.stopTask(fileName, openPath);
                    ++index;
                }
            }
        }
        this.table.getMergeManager().getMergeBlockSet().clear();
        size = this.table.columns.size();
        for (i = 0; i < size; ++i) {
            this.table.columns.getColumn(i).getGroupBlockList().clear();
        }
        manager.setExportMemoryCallback(exportMemoryCallback);
        manager.setExporting(false);
        progress.allCompleted();
    }

    void doMemeryCallBack(KDTDataRequestManager manager, int start, int end, boolean keepMergeBlock) {
        try {
            if (!this.isMemoryCallbackWhenExport()) {
                return;
            }
            long max = Runtime.getRuntime().maxMemory();
            long free = Runtime.getRuntime().freeMemory();
            System.out.println("\u5f53\u524d\u6700\u5927\u53ef\u7528\u5185\u5b58:" + max / 1024L / 1024L + "M");
            System.out.println("\u5f53\u524d\u7a7a\u95f2\u5185\u5b58:" + free / 1024L / 1024L + "M");
            long temp = max - free;
            System.out.println("\u5f53\u524d\u5360\u7528\u5185\u5b58:" + (max - free) / 1024L / 1024L + "M");
            Set set = this.table.getMergeManager().getMergeBlockSet();
            HashSet hash = null;
            if (keepMergeBlock) {
                hash = new HashSet(set);
            }
            set.clear();
            int size = this.table.columns.size();
            for (int i = 0; i < size; ++i) {
                this.table.columns.getColumn(i).getGroupBlockList().clear();
            }
            manager.setExportMemoryCallback(true);
            manager.doMemoryCallback(end / this.table.getDataRequestManager().getPageRowCount());
            manager.setExportMemoryCallback(false);
            if (hash != null) {
                this.table.getMergeManager().setMergeBlockSet(hash);
            }
            long gc = temp;
            long cgc = -1L;
            int gcTime = 0;
            do {
                if (cgc != -1L) {
                    gc = cgc;
                }
                System.gc();
            } while ((cgc = (max = Runtime.getRuntime().maxMemory()) - (free = Runtime.getRuntime().freeMemory())) < gc && ++gcTime < 100);
            System.out.println("GC\u540e\u6700\u5927\u53ef\u7528\u5185\u5b58:" + max / 1024L / 1024L + "M");
            System.out.println("GC\u540e\u7a7a\u95f2\u5185\u5b58:" + free / 1024L / 1024L + "M");
            System.out.println("GC\u540e\u5360\u7528\u5185\u5b58:" + (max - free) / 1024L / 1024L + "M");
            System.out.println("\u672c\u6b21GC\u91ca\u653e\u5185\u5b58:" + (temp - (max - free)) / 1024L / 1024L + "M");
        }
        catch (Exception ex) {
            System.out.println("GC\u5931\u8d25!");
            ex.printStackTrace();
        }
    }

    private int enlargeRowCount(IRow row) {
        int offset = -1;
        if (row != null) {
            for (int k = 0; k < this.table.getColumnCount(); ++k) {
                KDTMergeBlock block;
                ICell cell = row.getCell(k);
                if (cell == null || (block = cell.getMergeBlock()) == null || block.bottom - block.top <= 0) continue;
                offset = Math.max(offset, block.bottom);
            }
        }
        return offset;
    }

    private String getFileCount(int i) {
        String ret = "";
        int zeroNum = (i / 1000 == 0 ? 1 : 0) + (i / 100 == 0 ? 1 : 0) + (i / 10 == 0 ? 1 : 0);
        for (int t = 0; t < zeroNum; ++t) {
            ret = ret + "0";
        }
        return ret + i;
    }

    private void writeFile(int start, int end, KDSBook book, ExportManager man, String filePath) throws Exception {
        this.writeFileImpl(start, end, book, filePath);
        man.exportToExcel(book, filePath);
    }

    private void writeFileImpl(int start, int end, KDSBook book, String filePath) throws Exception {
        KDTRange range = new KDTRange();
        while (start + this.exportSize <= end) {
            range.add(new KDTSelectBlock(start, 0, Math.min(start + this.exportSize, end), this.table.getColumnCount() - 1));
            start += this.exportSize + 1;
        }
        if (start <= end) {
            range.add(new KDTSelectBlock(start, 0, end, this.table.getColumnCount() - 1));
        }
        Kdt2Kds trans = new Kdt2Kds(this.table, book);
        trans.setLargeDataOutput(true);
        trans.setWithHead(true);
        trans.setWithIndexColumn(false);
        trans.setWithHiddenCol(false);
        trans.setRange(range);
        KDSSheet sheet = trans.transform("sheet1");
        book.addSheet(null, sheet);
    }

    private void writeFile2007(int start, int end, KDSBook book, ExportManager man, String filePath) throws Exception {
        this.writeFileImpl(start, end, book, filePath);
        man.exportToSpreadSheet(book, filePath);
    }

    public class DefaultExportParam {
        protected String dirPath;
        protected String fileName = "tmp";
        protected boolean excel2007;
        protected int threshold = 5000;
        protected boolean onlySelected;
        protected ProgressListener listener;

        public DefaultExportParam() {
            try {
                this.dirPath = File.createTempFile("tmp", null).getAbsolutePath();
            }
            catch (IOException ex) {
                this.dirPath = KDTIOManager.this.tempFileDirection;
            }
        }

        public boolean isOnlySelected() {
            return this.onlySelected;
        }

        public void setOnlySelected(boolean onlySelected) {
            this.onlySelected = onlySelected;
        }

        public ProgressListener getProgressListener() {
            if (this.listener == null) {
                Window w = SwingUtilities.getWindowAncestor(KDTIOManager.this.table);
                this.listener = w instanceof Frame ? new DefaultProgressImpl((Frame)w, this.dirPath) : (w instanceof Dialog ? new DefaultProgressImpl((Dialog)w, this.dirPath) : new DefaultProgressImpl(this.dirPath));
            }
            return this.listener;
        }

        public void setProgressListener(ProgressListener listener) {
            this.listener = listener;
        }

        public String getDirPath() {
            return this.dirPath;
        }

        public void setDirPath(String dirPath) {
            this.dirPath = dirPath;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public boolean isExcel2007() {
            return this.excel2007;
        }

        public void setExcel2007(boolean isExcel2007) {
            this.excel2007 = isExcel2007;
        }

        public int getThreshold() {
            return this.threshold;
        }

        public void setThreshold(int threshold) {
            this.threshold = threshold;
        }
    }

    public static interface ProgressListener {
        public void startTask(Object var1);

        public void stopTask(Object var1, String var2);

        public void addTask(Object var1);

        public void setTaskNumber(int var1);

        public boolean isUserAborted();

        public void allCompleted();

        public void display(boolean var1);

        public void updateConnectTime();

        public void setExportThread(Thread var1);
    }

    class ExcelFileFilter
    extends FileFilter {
        protected static final String POSTFIX = ".xls";
        protected final String description = "Excel File";

        ExcelFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase(Locale.ENGLISH).endsWith(POSTFIX) || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return ".xls(Excel File)";
        }
    }
}

