/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.SAXBasicTableHandler;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXColumnGroupHandler
extends SAXBasicTableHandler {
    private int colIndex = 0;
    private boolean bUserObject = false;

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if ("t:ColumnGroup".equals(qName)) {
            this.colIndex = 0;
        } else if ("t:Column".equals(qName)) {
            boolean formatOnly = this.getTable().getIOManager().isFormatOnly();
            IColumn col = formatOnly ? this.table.getColumn(this.colIndex) : this.table.addColumn(this.colIndex);
            if (col == null) {
                return;
            }
            String attVal = attrs.getValue("t:width");
            if (!StringUtil.isEmptyString((String)attVal)) {
                col.setWidth(Integer.parseInt(attVal));
            }
            if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:key")))) {
                col.setKey(attVal);
            }
            attVal = attrs.getValue("t:objectName");
            String attVal2 = attrs.getValue("t:fieldName");
            if (!StringUtil.isEmptyString((String)attVal) && !StringUtil.isEmptyString((String)attVal2)) {
                this.table.getDataRequestManager().putBindContents(this.colIndex, attVal, attVal2);
            }
            if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:mergeable")))) {
                col.setMergeable(StringUtil.getBooleanFromString((String)attVal));
            }
            if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:resizeable")))) {
                col.setResizeable(StringUtil.getBooleanFromString((String)attVal));
            }
            if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:moveable")))) {
                col.setMoveable(StringUtil.getBooleanFromString((String)attVal));
            }
            if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:group")))) {
                col.setGroup(StringUtil.getBooleanFromString((String)attVal));
            }
            if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:styleID")))) {
                ShareStyleAttributes ssa = this.getKDF().getStyleAttributes(attVal.trim());
                if (formatOnly) {
                    StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
                    col.setStyleAttributes(sa);
                } else {
                    col.getKDTColumn().setSSA(ssa);
                    col.getKDTColumn().setStyle(Styles.getStyle((ShareStyleAttributes)ssa));
                }
            }
            if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:required"))) && StringUtil.getBooleanFromString((String)attVal)) {
                col.getStyleAttributes().setBackground(this.table.getRequiredColor());
            }
        } else if ("t:UserObject".equals(qName)) {
            this.bUserObject = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.bUserObject) {
            return;
        }
        String s = new String(ch, start, length);
        Object uo = ObjectUtil.stringToObject((String)s);
        if (uo != null) {
            this.getTable().getColumn(this.colIndex).setUserObject(uo);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if ("t:ColumnGroup".equals(qName)) {
            this.colIndex = 0;
        } else if ("t:Column".equals(qName)) {
            ++this.colIndex;
        } else if ("t:UserObject".equals(qName)) {
            this.bUserObject = false;
        }
    }
}

