/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.SAXBasicTableHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXMergeBlocksHandler
extends SAXBasicTableHandler {
    private int type = 0;

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        KDTMergeBlock block;
        if ("t:Head".equals(qName)) {
            this.type = 1;
        } else if ("t:Body".equals(qName)) {
            this.type = 2;
        } else if ("t:Block".equals(qName) && null != (block = this.parseMergeBlock(attrs))) {
            if (this.type == 1) {
                this.table.getHeadMergeManager().mergeBlock(block);
            } else if (this.type == 2) {
                this.table.getMergeManager().mergeBlock(block);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        super.endElement(namespaceURI, sName, qName);
        if ("t:Head".equals(qName)) {
            this.type = 0;
        } else if ("t:Body".equals(qName)) {
            this.type = 0;
        }
    }

    private KDTMergeBlock parseMergeBlock(Attributes attrs) {
        KDTMergeBlock block = new KDTMergeBlock();
        try {
            String top = attrs.getValue("t:top");
            String right = attrs.getValue("t:right");
            String left = attrs.getValue("t:left");
            String bottom = attrs.getValue("t:bottom");
            if (StringUtil.isEmptyString((String)top) || StringUtil.isEmptyString((String)right) || StringUtil.isEmptyString((String)left) || StringUtil.isEmptyString((String)bottom)) {
                throw new IllegalArgumentException("\u9009\u62e9\u5757\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            block.setLeft(Integer.parseInt(left));
            block.setRight(Integer.parseInt(right));
            block.setTop(Integer.parseInt(top));
            block.setBottom(Integer.parseInt(bottom));
            return block;
        }
        catch (Exception err) {
            return null;
        }
    }
}

