/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.SAXBasicTableHandler;
import com.kingdee.bos.ctrl.kdf.table.SAXMergeBlocksHandler;
import com.kingdee.bos.ctrl.kdf.table.SAXSelectionHandler;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXSheetOptionHandler
extends SAXBasicTableHandler {
    public SAXSheetOptionHandler() {
        this.handlerMap = new HashMap();
        this.handlerMap.put("t:Selections", new SAXSelectionHandler());
        this.handlerMap.put("t:MergeBlocks", new SAXMergeBlocksHandler());
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if ("t:SheetOptions".equals(qName)) {
            return;
        }
        if ("t:PrintInfo".equals(qName)) {
            this.parsePrintInfo(attrs);
        } else if ("t:GridLine".equals(qName)) {
            this.parseGridLine(attrs);
        } else if ("t:ActiveCell".equals(qName)) {
            this.parseActiveCellIndex(attrs);
        } else if ("t:IndexColumn".equals(qName)) {
            this.parseIndexColumn(attrs);
        } else if ("t:ExcelStyleHead".equals(qName)) {
            this.parseExcelStyleHead(attrs);
        } else {
            super.startElement(namespaceURI, sName, qName, attrs);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        super.endElement(namespaceURI, sName, qName);
        if ("t:Selections".equals(qName)) {
            this.currentHandler = null;
        } else if ("t:MergeBlocks".equals(qName)) {
            this.currentHandler = null;
        }
    }

    private void parseExcelStyleHead(Attributes attrs) {
        String value = attrs.getValue("t:mode");
        if (!StringUtil.isEmptyString((String)value)) {
            this.table.setHeadDisplayMode(Integer.valueOf(value));
        }
    }

    private void parseIndexColumn(Attributes attrs) {
        String value = attrs.getValue("t:styleID");
        if (!StringUtil.isEmptyString((String)value)) {
            ShareStyleAttributes ssa = this.getKDF().getStyleAttributes(value);
            this.table.getIndexColumn().setSsa(ssa);
        }
        if (!StringUtil.isEmptyString((String)(value = attrs.getValue("t:width")))) {
            this.table.getIndexColumn().setRealWidth(Integer.valueOf(value));
        }
        if (!StringUtil.isEmptyString((String)(value = attrs.getValue("widthMode")))) {
            this.table.getIndexColumn().setWidthAdjustMode(Short.valueOf(value));
        }
    }

    private void parseActiveCellIndex(Attributes attrs) {
        String rowIndex = attrs.getValue("t:row");
        String colIndex = attrs.getValue("t:column");
        try {
            if (!StringUtil.isEmptyString((String)rowIndex)) {
                this.table.getSelectManager().setActiveRowIndex(Integer.parseInt(rowIndex));
            }
        }
        catch (Exception e) {
            this.table.getSelectManager().setActiveRowIndex(0);
        }
        try {
            if (!StringUtil.isEmptyString((String)colIndex)) {
                this.table.getSelectManager().setActiveColumnIndex(Integer.parseInt(colIndex));
            }
        }
        catch (Exception e) {
            this.table.getSelectManager().setActiveColumnIndex(0);
        }
    }

    private void parseGridLine(Attributes attrs) {
        String sVal = attrs.getValue("t:headVertical");
        this.table.setVerticalHeadGridLineVisible(StringUtil.getBooleanFromString((String)sVal));
        sVal = attrs.getValue("t:headHorizon");
        this.table.setHorizonHeadGridLineVisible(StringUtil.getBooleanFromString((String)sVal));
        sVal = attrs.getValue("t:bodyVertical");
        this.table.setVerticalGridLineVisible(StringUtil.getBooleanFromString((String)sVal));
        sVal = attrs.getValue("t:bodyHorizon");
        this.table.setHorizonGridLineVisible(StringUtil.getBooleanFromString((String)sVal));
    }

    private void parsePrintInfo(Attributes attrs) {
        this.getTable().getPrintManager().doNothing();
    }
}

