/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table.command;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.command.AbstractTableCommand;
import com.kingdee.bos.ctrl.kdf.table.command.ICommand;
import java.util.LinkedList;
import java.util.ListIterator;

public class CompositeCommand
extends AbstractTableCommand {
    protected LinkedList commandList;

    public CompositeCommand(KDTable table) {
        super(table);
        this.name = "unamed composited command";
    }

    public CompositeCommand(String name, KDTable table) {
        super(name, table);
        this.commandList = new LinkedList();
    }

    @Override
    public void execute() {
        for (ICommand command : this.commandList) {
            command.execute();
        }
    }

    @Override
    public void unexecute() {
        ListIterator iter = this.commandList.listIterator(this.commandList.size() - 1);
        while (iter.hasPrevious()) {
            ICommand command = (ICommand)iter.previous();
            if (!command.isReversible()) continue;
            command.unexecute();
        }
    }

    public int addChild(ICommand command) {
        this.commandList.add(command);
        return this.commandList.size() - 1;
    }

    public int addChild(int index, ICommand command) {
        this.commandList.add(index, command);
        return index;
    }

    public ICommand removeChild() {
        return (ICommand)this.commandList.removeLast();
    }

    public ICommand removeChild(int index) {
        return (ICommand)this.commandList.remove(index);
    }

    public LinkedList getCommandList() {
        return this.commandList;
    }
}

