/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table.undo;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.undo.AbstractKDTableUndoableEdit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public abstract class AbstractSelectBlockEdit
extends AbstractKDTableUndoableEdit {
    protected KDTRange range;
    protected HashMap beforEditCellsContents;
    protected HashMap afterEditCellsContents;

    public AbstractSelectBlockEdit(KDTable table, KDTRange range2) {
        super(table);
        this.range = range2;
        this.init();
    }

    public AbstractSelectBlockEdit(KDTable table, KDTSelectBlock b) {
        super(table);
        this.range = new KDTRange();
        this.range.add(b);
        this.init();
    }

    private void init() {
        this.beforEditCellsContents = new HashMap();
        this.afterEditCellsContents = new HashMap();
        this.saveRange(this.range, this.beforEditCellsContents);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.saveRange(this.range, this.afterEditCellsContents);
        this.doChange(this.beforEditCellsContents);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doChange(this.afterEditCellsContents);
    }

    protected void doChange(HashMap cellsMap) {
        Set keyset = cellsMap.keySet();
        Iterator iter = keyset.iterator();
        this.table.setRefresh(false);
        while (iter.hasNext()) {
            Point p = (Point)iter.next();
            Object value = cellsMap.get(p);
            ICell cell = this.table.getCell(p.getX(), p.getY());
            this.setCellValue(cell, value);
        }
        IBlock block = (IBlock)this.range.get(0);
        this.table.getSelectManager().select(block.getTop(), block.getLeft(), block.getBottom(), block.getRight());
        this.table.setRefresh(true);
        this.table.repaint();
    }

    protected abstract void setCellValue(ICell var1, Object var2);

    protected abstract Object getCellValue(int var1, int var2);

    protected void saveRange(KDTRange range, HashMap saveMap) {
        int size = range.size();
        for (int i = 0; i < size; ++i) {
            IBlock block = (IBlock)range.get(i);
            int top = 0;
            int left = 0;
            int bottom = 0;
            int right = 0;
            switch (block.getMode()) {
                case 8: {
                    top = 0;
                    left = 0;
                    bottom = this.table.getRowCount3() - 1;
                    right = this.table.getColumnCount() - 1;
                    break;
                }
                case 4: {
                    top = 0;
                    left = block.getLeft();
                    bottom = this.table.getRowCount3() - 1;
                    right = block.getRight();
                    break;
                }
                case 2: {
                    top = block.getTop();
                    left = 0;
                    bottom = block.getBottom();
                    right = this.table.getColumnCount() - 1;
                    break;
                }
                case 1: {
                    top = block.getTop();
                    left = block.getLeft();
                    bottom = block.getBottom();
                    right = block.getRight();
                    break;
                }
                default: {
                    return;
                }
            }
            for (int j = top; j <= bottom; ++j) {
                for (int k = left; k <= right; ++k) {
                    this.saveCell(j, k, saveMap);
                }
            }
        }
    }

    protected void saveCell(int j, int k, HashMap saveMap) {
        saveMap.put(new Point(j, k), this.getCellValue(j, k));
    }

    class Point {
        int x;
        int y;

        Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

