/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table.undo;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTBody;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTHead;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.undo.AbstractKDTableUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class RemoveColumnEdit
extends AbstractKDTableUndoableEdit {
    private static final long serialVersionUID = 8020477446869795827L;
    private IColumn col;
    private int colIndex;
    private KDTCell[] headCells;
    private KDTCell[] bodyCells;

    public RemoveColumnEdit(KDTable table, int colIndex) {
        super(table);
        KDTRow row;
        int i;
        this.col = this.table.getColumn(colIndex);
        this.colIndex = colIndex;
        KDTHead head = table.getHead();
        this.headCells = new KDTCell[head.size()];
        for (i = 0; i < head.size(); ++i) {
            row = head.getRow2(i);
            KDTCell headCell = null;
            if (row != null) {
                headCell = row.getCell(colIndex);
            }
            this.headCells[i] = headCell;
        }
        KDTBody body = table.getBody();
        this.bodyCells = new KDTCell[body.size()];
        for (i = 0; i < body.size(); ++i) {
            row = body.getRow2(i);
            KDTCell cell = null;
            if (row != null) {
                cell = row.getCell(colIndex);
            }
            this.bodyCells[i] = cell;
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.table.addColumn(this.colIndex, this.col);
        KDTHead head = this.table.getHead();
        KDTRow row = null;
        int i = 0;
        for (i = 0; i < head.size(); ++i) {
            row = head.getRow2(i);
            if (row == null) continue;
            row.setCell(this.colIndex, this.headCells[i]);
        }
        KDTBody body = this.table.getBody();
        for (i = 0; i < body.size(); ++i) {
            row = body.getRow2(i);
            if (row == null) continue;
            row.setCell(this.colIndex, this.bodyCells[i]);
        }
        this.table.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.table.removeColumn(this.colIndex);
    }

    @Override
    public String getPresentationName() {
        return "removeColumn";
    }
}

