/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.tablepanel.plaf;

import com.kingdee.bos.ctrl.kdf.tablepanel.KDTablePanel;
import com.kingdee.bos.ctrl.kdf.tablepanel.PanelCell;
import com.kingdee.bos.ctrl.kdf.tablepanel.PanelColumn;
import com.kingdee.bos.ctrl.kdf.tablepanel.PanelLine;
import com.kingdee.bos.ctrl.kdf.tablepanel.PanelMerger;
import com.kingdee.bos.ctrl.kdf.tablepanel.PanelRow;
import com.kingdee.bos.ctrl.kdf.tablepanel.TablePanelLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class KingdeeTablePanelUI
extends ComponentUI {
    private KDTablePanel tablePanel;
    private LayoutManager layout;

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeTablePanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.tablePanel = (KDTablePanel)c;
        this.installComponents(this.tablePanel);
        this.installDefaults(this.tablePanel);
        this.installListeners(this.tablePanel);
        this.installKeyboardActions(this.tablePanel);
    }

    protected void installComponents(KDTablePanel tablePanel) {
        if (this.layout == null) {
            this.layout = new TablePanelLayout();
        }
        tablePanel.setLayout(this.layout);
    }

    protected void installDefaults(KDTablePanel tablePanel) {
    }

    protected void installListeners(KDTablePanel tablePanel) {
    }

    protected void installKeyboardActions(KDTablePanel tablePanel) {
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.unInstallKeyboardActions(this.tablePanel);
        this.unInstallListeners(this.tablePanel);
        this.unInstallDefaults(this.tablePanel);
        this.unInstallComponents(this.tablePanel);
        this.tablePanel = null;
        super.uninstallUI(c);
    }

    protected void unInstallComponents(KDTablePanel tablePanel) {
        if (this.layout != null) {
            this.layout = null;
        }
    }

    protected void unInstallDefaults(KDTablePanel tablePanel) {
    }

    protected void unInstallListeners(KDTablePanel tablePanel) {
    }

    protected void unInstallKeyboardActions(KDTablePanel tablePanel) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Insets insets = c.getInsets();
        List rowLineList = PanelLine.generaRowLine(this.tablePanel);
        List columnLineList = PanelLine.generaColumnLine(this.tablePanel);
        g.setColor(Color.WHITE);
        g.fillRect(insets.left, insets.top, c.getWidth() - insets.left - insets.right, c.getHeight() - insets.top - insets.bottom);
        g.setColor(Color.decode("#A2A2A2"));
        this.drawGrids(g, c, rowLineList, columnLineList);
        this.paintMergers(g, c, rowLineList, columnLineList);
    }

    protected void drawGrids(Graphics g, JComponent c, List rowLineList, List columnLineList) {
        this.drawCustomLine(g, c, rowLineList);
        this.drawCustomLine(g, c, columnLineList);
    }

    private void drawCustomLine(Graphics g, JComponent c, List list) {
        for (int i = 0; i < list.size(); ++i) {
            PanelLine line = (PanelLine)list.get(i);
            g.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2());
        }
    }

    protected void paintCells(Graphics g, JComponent c) {
    }

    protected void paintMergers(Graphics g, JComponent c, List rowLineList, List columnLineList) {
        int mergerCount = this.tablePanel.getMergersCount();
        PanelMerger merger = null;
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        PanelCell start = null;
        PanelCell end = null;
        for (int i = 0; i < mergerCount; ++i) {
            merger = this.tablePanel.getMerger(i);
            start = merger.getStartCell();
            end = merger.getEndCell();
            PanelColumn col = start.getColumn();
            int index = this.tablePanel.getColumnIndex(col);
            PanelLine line = (PanelLine)columnLineList.get(index);
            x1 = line.getX1();
            col = end.getColumn();
            index = this.tablePanel.getColumnIndex(col);
            line = (PanelLine)columnLineList.get(index + 1);
            x2 = line.getX1();
            PanelRow row = start.getRow();
            index = this.tablePanel.getRowIndex(row);
            line = (PanelLine)rowLineList.get(index);
            y1 = line.getY1();
            row = end.getRow();
            index = this.tablePanel.getRowIndex(row);
            line = (PanelLine)rowLineList.get(index + 1);
            y2 = line.getY1();
            g.setColor(Color.WHITE);
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
            g.setColor(Color.decode("#A2A2A2"));
            g.drawRect(x1, y1, x2 - x1, y2 - y1);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int i;
        Insets ins = c.getInsets();
        int height = ins.top + ins.bottom;
        int width = ins.left + ins.right;
        for (i = 0; i < this.tablePanel.getRowCount(); ++i) {
            height += this.tablePanel.getRow(i).getHeight();
        }
        for (i = 0; i < this.tablePanel.getColumnCount(); ++i) {
            width += this.tablePanel.getColumn(i).getWidth();
        }
        return new Dimension(width, height);
    }
}

