/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render;

import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.render.RenderObject;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.TextIconRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.Icon;

public class ObjectValueRender
extends TextIconRender {
    protected static final Color BGCOLOR = new Color(7645403);
    protected IDataFormat format;

    @Override
    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        this.draw(graphics, clip, object, cellStyle, null);
    }

    public IDataFormat getFormat() {
        return this.format;
    }

    public void setFormat(IDataFormat format) {
        this.format = format;
    }

    @Override
    protected int getIconWidth() {
        return 15;
    }

    @Override
    protected int getIconHeight() {
        return 15;
    }

    @Override
    protected Icon getIcon(RenderObject ro) {
        KDTable table = ro.getTable();
        int row = ro.getRowIndex();
        int col = ro.getColIndex();
        int ar = table.getSelectManager().getActiveRowIndex();
        int ac = table.getSelectManager().getActiveColumnIndex();
        if (row == ar && col == ac) {
            ICell cell = table.getCell(row, col);
            if (cell != null && cell.getStyle().isLocked()) {
                return null;
            }
            ICellEditor editor = table.getCellEditor(row, col);
            if (editor != null && editor.getComponent() instanceof KDPromptBox) {
                return ((KDPromptBox)editor.getComponent()).getUI().getIconOff();
            }
        }
        return null;
    }

    @Override
    public String getText(Object obj) {
        return this.getFormattedText(obj);
    }

    @Override
    protected Color getIconBackGround() {
        return BGCOLOR;
    }

    public String getFormattedText(Object object) {
        if (object == null) {
            return null;
        }
        String text = null;
        text = this.format == null ? object.toString() : this.format.format(object);
        return text;
    }
}

