/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bim.rpt.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.report.biz.content.ReportManager;
import com.kingdee.bos.ctrl.report.biz.content.ReportType;
import com.kingdee.bos.ctrl.report.forapp.bim.BimReportHelper;
import com.kingdee.bos.ctrl.report.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.report.reportframework.execute.IReportExecutor;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.report.BIMRptCompress;
import com.kingdee.bos.metadata.report.BIMRptQueryStorage;
import com.kingdee.bos.metadata.report.BIMRptStorage;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bim.rpt.IBIMReportService;
import com.kingdee.eas.bim.rpt.app.BIMReportStorage;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Set;
import javax.help.UnsupportedOperationException;

public class BIMReportService
extends AbstractBOSObject
implements IBIMReportService {
    public static final String QUERY_TYPE_JOIN = "0";
    public static final String QUERY_TYPE_UNION = "1";

    public BIMReportService() {
        this.registerInterface(IBIMReportService.class, this);
    }

    public IRowSet getReport(String reportPK) throws BOSException {
        String sql = "SELECT FContent,FTimeStamp,FQuery,FQTimeStamp,FRptType";
        sql = sql + " FROM T_RPT_BIMCommonRpt WHERE FReportPK='" + reportPK + "'";
        return DbUtil.executeQuery((Context)this.getContext(), (String)sql);
    }

    public void setReport(String reportPK, byte[] content, byte[] query) throws BOSException {
        String sql;
        Object[] params;
        Timestamp currDate = new Timestamp(System.currentTimeMillis());
        String uuid = BOSUuid.create((BOSObjectType)this.getType()).toString();
        if (this.exists(reportPK)) {
            params = new Object[]{content, currDate, query, currDate, reportPK};
            sql = "UPDATE T_RPT_BIMCommonRpt SET FContent=?, ";
            sql = sql + " FTimeStamp=?, FQuery=?, FQTimeStamp=?";
            sql = sql + " WHERE FReportPK=?";
        } else {
            params = new Object[]{uuid, reportPK, content, currDate, query, currDate};
            sql = "INSERT INTO T_RPT_BIMCommonRpt ";
            sql = sql + " (FID, FReportPK, FContent, FTimeStamp, FQuery, FQTimeStamp)";
            sql = sql + " VALUES (?, ?, ?, ?, ?, ?)";
        }
        DbUtil.execute((Context)this.getContext(), (String)sql, (Object[])params);
    }

    public IRowSet getQuery(String reportPK) throws BOSException {
        String sql = "SELECT FQuery,FQTimeStamp,FQueryPKs FROM T_RPT_BIMCommonRpt";
        sql = sql + " WHERE FReportPK='" + reportPK + "'";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        return rs;
    }

    public IRowSet getTemplates(String reportPK) throws BOSException {
        String sql = "SELECT FContent,FTimeStamp FROM T_RPT_BIMCommonRpt WHERE FReportPK='" + reportPK + "'";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        return rs;
    }

    public void setTemplates(String reportPK, byte[] templates) throws BOSException {
        String sql = "UPDATE T_RPT_BIMCommonRpt SET FContent=?, FTimeStamp=? WHERE FReportPK=?";
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Object[] params = new Object[]{templates, timestamp, reportPK};
        DbUtil.execute((Context)this.getContext(), (String)sql, (Object[])params);
    }

    public IRowSet getAllTimeStamp(String reportPK) throws BOSException {
        String sql = "SELECT FTimeStamp,FQTimeStamp FROM T_RPT_BIMCommonRpt WHERE FReportPK='" + reportPK + "'";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        return rs;
    }

    public IRowSet getQueryPKs(String reportPK) throws BOSException {
        String sql = "SELECT FQueryPKs FROM T_RPT_BIMCommonRpt WHERE FReportPK='";
        sql = sql + reportPK + "'";
        return DbUtil.executeQuery((Context)this.getContext(), (String)sql);
    }

    public void setReportQuery(String reportPK, byte[] query, Timestamp timestamp) throws BOSException {
        String sql = "UPDATE T_RPT_BIMCommonRpt SET FQuery=?,FQTimeStamp=?";
        sql = sql + " WHERE FReportPK=?";
        Object[] params = new Object[]{query, timestamp, reportPK};
        DbUtil.execute((Context)this.getContext(), (String)sql, (Object[])params);
    }

    public void setReportTemplate(String reportPK, byte[] content, Timestamp timestamp) throws BOSException {
        String sql = "UPDATE T_RPT_BIMCommonRpt SET FContent=?,FTimeStamp=?";
        sql = sql + " WHERE FReportPK=?";
        Object[] params = new Object[]{content, timestamp, reportPK};
        DbUtil.execute((Context)this.getContext(), (String)sql, (Object[])params);
    }

    public BOSObjectType getType() {
        return MetaDataTypeList.JOINQUERY;
    }

    public void close(String rptId) {
        ReportManager.removeReport((String)rptId);
    }

    public String execute(String reportPK, String rptType, HashMap params) {
        ReportType reportType;
        if (rptType.equals(QUERY_TYPE_JOIN)) {
            reportType = ReportType.TABLE;
        } else if (rptType.equals(QUERY_TYPE_UNION)) {
            reportType = DataDefType.KDRS_CUBEMODEL;
        } else {
            throw new UnsupportedOperationException("This report type is not supported!");
        }
        try {
            IReportExecutor rptExec = BimReportHelper.executeReport((Object)reportType, (IReportStorage)new BIMReportStorage(reportPK), (HashMap)params);
            return ReportManager.addReport((IReportExecutor)rptExec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object invoke(String rptId, String methodName, Class[] argTypes, Object[] args) {
        IReportExecutor rptExec = ReportManager.getReport((String)rptId);
        try {
            return ReflectUtil.invoke((Object)rptExec, (String)methodName, (Class[])argTypes, (Object[])args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveKMDTemplates(String reportPK, HashMap kmdTpl) throws BOSException {
        BIMRptStorage rpt;
        IRowSet rs = this.getTemplates(reportPK);
        try {
            rs.absolute(1);
            Object content = rs.getObject("FContent");
            byte[] contentData = null;
            if (content instanceof Blob) {
                Blob blob = (Blob)content;
                contentData = blob.getBytes(1L, (int)blob.length());
            } else if (content instanceof byte[]) {
                contentData = (byte[])content;
            } else {
                throw new UnsupportedOperationException("Not support this db type!");
            }
            rpt = BIMRptCompress.upZipReport((byte[])contentData);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException("Get MDQuery failed!", (Throwable)e);
        }
        HashMap<Object, byte[]> kmdTpls = rpt.getKMDTemplates();
        if (kmdTpls == null) {
            kmdTpls = new HashMap<Object, byte[]>();
        }
        Set keySet = kmdTpl.keySet();
        for (Object key : keySet.toArray()) {
            byte[] newTpl = (byte[])kmdTpl.get(key);
            if (kmdTpls.containsKey(key)) {
                kmdTpls.remove(key);
            }
            kmdTpls.put(key, newTpl);
        }
        rpt.setKMDTemplates(kmdTpls);
        this.setTemplates(reportPK, BIMRptCompress.zipReport((BIMRptStorage)rpt));
    }

    public void loadQuery(String reportPK) throws BOSException {
        IRowSet rs = this.getQuery(reportPK);
        if (rs.size() == 0) {
            throw new NullPointerException("No matched query!");
        }
        try {
            rs.absolute(1);
            byte[] queryData = null;
            Object queryObj = rs.getObject("FQuery");
            if (queryObj instanceof Blob) {
                Blob blob = (Blob)queryObj;
                queryData = blob.getBytes(1L, (int)blob.length());
            } else if (queryObj instanceof byte[]) {
                queryData = (byte[])queryObj;
            } else {
                throw new UnsupportedOperationException("Not support this db type!");
            }
            byte[] queryStream = queryData;
            BIMRptQueryStorage storage = BIMRptCompress.upZipQuery((byte[])queryStream);
            String strQueryPKs = rs.getString("FQueryPKs");
            if (strQueryPKs == null || strQueryPKs.trim().length() == 0) {
                return;
            }
            HashMap list = storage.getQuery();
            String[] queryPKs = StringUtils.split((String)strQueryPKs, (String)",");
            int n = queryPKs.length;
            for (int i = 0; i < n; ++i) {
                if (queryPKs[i].trim().length() == 0) continue;
                String[] items = StringUtils.split((String)queryPKs[i], (String)"|");
                byte[] query = (byte[])list.get(items[0]);
                ByteArrayInputStream is = new ByteArrayInputStream(query);
                AbstractMetaDataCtrl objCtrl = (AbstractMetaDataCtrl)BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)MetaDataTypeList.BASEQUERY);
                objCtrl.load((InputStream)is);
                try {
                    ((InputStream)is).close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException("Get query failed!", (Throwable)e);
        }
    }

    public void loadMDQuery(String reportPK) throws BOSException {
        BIMRptStorage storage;
        IRowSet rs = this.getTemplates(reportPK);
        try {
            rs.absolute(1);
            Object content = rs.getObject("FContent");
            byte[] contentData = null;
            if (content instanceof Blob) {
                Blob blob = (Blob)content;
                contentData = blob.getBytes(1L, (int)blob.length());
            } else if (content instanceof byte[]) {
                contentData = (byte[])content;
            } else {
                throw new UnsupportedOperationException("Not support this db type!");
            }
            storage = BIMRptCompress.upZipReport((byte[])contentData);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException("Get MDQuery failed!", (Throwable)e);
        }
        HashMap mdQueryTpl = storage.getMDQueryTemplate();
        if (mdQueryTpl == null) {
            throw new BOSException("MDQuery is null!");
        }
        Set keySet = mdQueryTpl.keySet();
        for (Object key : keySet.toArray()) {
            byte[] mdQuery = (byte[])mdQueryTpl.get(key);
            ByteArrayInputStream is = new ByteArrayInputStream(mdQuery);
            AbstractMetaDataCtrl objCtrl = (AbstractMetaDataCtrl)BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)MetaDataTypeList.MDQUERY);
            objCtrl.load((InputStream)is);
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean exists(String reportPK) throws BOSException {
        String sql = "SELECT 1 FROM T_RPT_BIMCommonRpt WHERE FReportPK='" + reportPK + "'";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        return rs.size() > 0;
    }
}

