/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.common.app.ServerSysEnvLoader;
import com.kingdee.eas.util.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class CommonListener
implements ServletContextListener {
    private static Logger logger = Logger.getLogger(CommonListener.class);
    private ArrayList listener = new ArrayList();
    private Stack listenerStack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonListener() {
        String listenerCfg = System.getProperty("listener.config");
        InputStream listenerCfgFileStream = null;
        try {
            try {
                if (listenerCfg != null && new File(listenerCfg).exists()) {
                    listenerCfgFileStream = new FileInputStream(new File(listenerCfg));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Load listener.config error[" + e.getMessage() + "], use default config!"));
                logger.debug((Object)listenerCfg);
                listenerCfgFileStream = null;
            }
            if (listenerCfgFileStream == null) {
                listenerCfgFileStream = CommonListener.class.getClassLoader().getResourceAsStream("com/kingdee/eas/common/app/listenerconfig.data");
            }
            if (listenerCfgFileStream != null) {
                Document document = null;
                try {
                    document = XMLParser.parseXML((InputStream)listenerCfgFileStream);
                }
                catch (JDOMException e) {
                    logger.error((Object)("Load listener.config error[" + e.getMessage() + "], parse XML error"));
                }
                catch (IOException e) {
                    logger.error((Object)("Load listener.config error[" + e.getMessage() + "], parse XML error"));
                }
                Element rootEle = document.getRootElement();
                List itemDatas = rootEle.getChild("configitem").getChildren();
                for (int i = 0; i < itemDatas.size(); ++i) {
                    Element dataEl = (Element)itemDatas.get(i);
                    ListenerInfo info = new ListenerInfo();
                    String name = dataEl.getAttributeValue("name");
                    info.setName(name);
                    info.setEnable("true".equalsIgnoreCase(dataEl.getAttributeValue("enable")));
                    info.setFailOnError("true".equalsIgnoreCase(dataEl.getAttributeValue("failOnError")));
                    info.setAsynchInvoke("true".equalsIgnoreCase(dataEl.getAttributeValue("asynchInvoke")));
                    this.listener.add(info);
                }
            }
            ServerSysEnvLoader.initSysEnv();
        }
        finally {
            if (listenerCfgFileStream != null) {
                try {
                    listenerCfgFileStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void asynchInvoke(final ServletContextEvent arg0, final ListenerInfo info) {
        Thread th = new Thread(){

            @Override
            public void run() {
                try {
                    String listenerClassName = info.getName();
                    ServletContextListener listener = (ServletContextListener)Class.forName(listenerClassName).newInstance();
                    logger.info((Object)("BEGIN INIT LISTENER [" + listenerClassName + "]"));
                    listener.contextInitialized(arg0);
                    CommonListener.this.listenerStack.push(listener);
                    logger.info((Object)("END INIT LISTENER [" + listenerClassName + "]"));
                }
                catch (Throwable e) {
                    logger.error((Object)ExceptionUtil.getExcLinkStackTrace(e));
                }
            }
        };
        th.start();
    }

    public void contextInitialized(ServletContextEvent arg0) {
        for (int i = 0; i < this.listener.size(); ++i) {
            ListenerInfo info = (ListenerInfo)this.listener.get(i);
            try {
                if (!info.isEnable()) continue;
                if (info.isAsynchInvoke() && !info.isFailOnError()) {
                    this.asynchInvoke(arg0, info);
                    continue;
                }
                String listenerClassName = info.getName();
                ServletContextListener listener = (ServletContextListener)Class.forName(listenerClassName).newInstance();
                logger.info((Object)("BEGIN INIT LISTENER [" + listenerClassName + "]"));
                listener.contextInitialized(arg0);
                this.listenerStack.push(listener);
                logger.info((Object)("END INIT LISTENER [" + listenerClassName + "]"));
                continue;
            }
            catch (Throwable e) {
                if (info.isFailOnError()) {
                    throw new RuntimeException("run listener [" + info.getName() + "] failed!", e);
                }
                logger.error((Object)ExceptionUtil.getExcLinkStackTrace(e));
            }
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        while (!this.listenerStack.isEmpty()) {
            try {
                ServletContextListener listener = (ServletContextListener)this.listenerStack.pop();
                listener.contextDestroyed(arg0);
            }
            catch (Exception e) {
                logger.error((Object)ExceptionUtil.getExcLinkStackTrace(e));
            }
        }
    }

    private class ListenerInfo {
        private String name;
        private boolean enable = true;
        private boolean failOnError = false;
        private boolean isAsynchInvoke = false;

        private ListenerInfo() {
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public boolean isFailOnError() {
            return this.failOnError;
        }

        public void setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isAsynchInvoke() {
            return this.isAsynchInvoke;
        }

        public void setAsynchInvoke(boolean isAsynchInvoke) {
            this.isAsynchInvoke = isAsynchInvoke;
        }
    }
}

