/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app;

import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.config.AISDeployInfo;
import com.kingdee.bos.framework.config.AppServerDeployInfo;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.common.app.EASSecurityManager;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.io.File;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class ConfigVerifyListener
implements ServletContextListener {
    private static Logger logger = Logger.getLogger(ConfigVerifyListener.class);

    public void contextInitialized(ServletContextEvent arg0) {
        String verifyConfig;
        ConfigurationItem item = Configuration.getInstance().getConfigItem("DebugOptions");
        if (item != null && (verifyConfig = item.getProperty("verifyConfig")) != null && verifyConfig.equals("true")) {
            logger.debug((Object)"Verify metadatapath");
            SolutionDeployInfo slnDeployInfo = DeployInfoManagerFactory.getDeployInfoManager().getSolutionDeployInfo("eas");
            if (slnDeployInfo != null && slnDeployInfo.getMetaDataPath() != null) {
                String url = slnDeployInfo.getMetaDataPath();
                File file = new File(url);
                if (file.exists()) {
                    logger.info((Object)("Metadatapath : " + url));
                } else {
                    logger.error((Object)("Cann't find metadata " + url));
                }
            } else {
                logger.error((Object)"SolutionInfo null or metadatapath null!");
            }
            if (slnDeployInfo != null) {
                logger.debug((Object)"Verify datacenter");
                try {
                    DCRegister dcRegister = new DCRegister();
                    ArrayList dcList = dcRegister.getDCList();
                    for (DCInfo dcInfo : dcList) {
                        AISDeployInfo aisInfo;
                        String dcNumber = dcInfo.getNumber();
                        if (!"eas".equals(dcInfo.getSolutionName())) {
                            logger.error((Object)("AIS " + dcNumber + " solution name error, solution name : " + dcInfo.getSolutionName()));
                        }
                        if ((aisInfo = slnDeployInfo.getAISInfo(dcNumber)) == null) {
                            logger.error((Object)("AIS " + dcNumber + " null!"));
                            this.checkDataSource(null, "jdbc/" + dcNumber);
                            continue;
                        }
                        assert (aisInfo.getServerInfos().length > 0);
                        assert (aisInfo.getServerInfos()[0] != null);
                        String dataSource = aisInfo.getServerInfos()[0].getDatasource();
                        this.checkDataSource(aisInfo.getServerInfos()[0], dataSource);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Verify datacenter error : " + ExceptionUtil.getExcLinkStackTrace(e)));
                }
            }
        }
        try {
            if (System.getSecurityManager() == null && EASSecurityManager.isEnable()) {
                System.setSecurityManager(new EASSecurityManager());
            }
        }
        catch (Throwable e) {
            logger.error((Object)e);
        }
    }

    private void checkDataSource(AppServerDeployInfo appServerInfo, String dataSource) {
        try {
            this.getInitialContext(appServerInfo).lookup(dataSource);
        }
        catch (NameNotFoundException nne) {
            logger.fatal((Object)("FATAL: No DataSource is registered under the name " + dataSource + ", please check your datasource properties  and deployment tool.\n"), (Throwable)nne);
        }
        catch (NamingException nex) {
            logger.fatal((Object)"FATAL: JNDI Exception Occurred. Is your JNDI resource available?\n", (Throwable)nex);
        }
        catch (AccessControlException ae) {
            logger.fatal((Object)"FATAL: You cannot execute this eunction with the security permissions you are using. Try using the securityCredential/securityPrincipalpoolman parameters.\n", (Throwable)ae);
        }
    }

    private InitialContext getInitialContext(AppServerDeployInfo appServerInfo) throws NamingException {
        InitialContext ctx = null;
        if (appServerInfo == null || appServerInfo.getJndiURL() == null) {
            ctx = new InitialContext();
        } else {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.provider.url", appServerInfo.getJndiURL());
            if (appServerInfo.getContextFactory() != null) {
                env.put("java.naming.factory.initial", appServerInfo.getContextFactory());
            }
            if (appServerInfo.getSecurityCredential() != null) {
                env.put("java.naming.security.credentials", appServerInfo.getSecurityCredential());
            }
            if (appServerInfo.getSecurityPrincipal() != null) {
                env.put("java.naming.security.principal", appServerInfo.getSecurityPrincipal());
            }
            ctx = new InitialContext(env);
        }
        return ctx;
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }
}

