/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.IDataFormat;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BizDataFormat
implements IDataFormat {
    protected static final String OBJECTDISPLAYSPLITTER = "; ";
    protected List list = new Vector();

    public BizDataFormat(String p) {
        this.setPattern(p);
    }

    public void setPattern(String p) {
        if (p == null) {
            return;
        }
        int pos = 0;
        boolean end = true;
        for (int i = 0; i < p.length() + 1; ++i) {
            if (i < p.length() && p.charAt(i) != '$') continue;
            String substr = p.substring(pos, i);
            if (end) {
                if (substr.length() > 0) {
                    this.list.add(new Node(0, substr));
                }
            } else if (substr.length() > 0) {
                this.list.add(new Node(1, substr));
            } else if (!this.appendDollarToLastNode()) {
                this.list.add(new Node(0, "$"));
            }
            pos = i + 1;
            end = !end;
        }
    }

    private boolean appendDollarToLastNode() {
        boolean ret = false;
        Node node = (Node)((Vector)this.list).lastElement();
        if (node != null && node.type == 0) {
            node.value = node.value + '$';
            ret = true;
        }
        return ret;
    }

    protected Field getField(String name, Class cl) {
        Field f = null;
        try {
            f = cl.getField(name);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return f;
    }

    @Override
    public String format(Object o) {
        if (o == null) {
            return "";
        }
        if (o.getClass().isArray()) {
            Object[] os = (Object[])o;
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < os.length; ++i) {
                if (i > 0) {
                    ret.append(OBJECTDISPLAYSPLITTER);
                }
                ret.append(this.formatSingleObject(os[i]));
            }
            return ret.toString();
        }
        return this.formatSingleObject(o);
    }

    protected String formatSingleObject(Object o) {
        if (o == null) {
            return "";
        }
        IObjectValue bizo = null;
        if (!(o instanceof IObjectValue)) {
            return o.toString();
        }
        bizo = (IObjectValue)o;
        StringBuffer ret = new StringBuffer();
        Object value = null;
        Node node2 = null;
        for (Node node2 : this.list) {
            if (node2.type == 1) {
                value = bizo.get(node2.value);
                if (value == null) continue;
                ret.append(value.toString());
                continue;
            }
            ret.append(node2.value);
        }
        return ret.toString();
    }

    public Object parseObject(String source) {
        return null;
    }

    public Map parseObjectToMap(String source) {
        if (source == null || source.length() < 1) {
            return null;
        }
        String[] str = source.split(OBJECTDISPLAYSPLITTER);
        HashMap ret = new HashMap();
        for (int i = 0; i < str.length; ++i) {
            this.parseSingleObjectToMap(str[i].trim(), ret);
        }
        return ret;
    }

    protected void parseSingleObjectToMap(String source, Map dest) {
        if (dest == null) {
            return;
        }
        if (source == null || source.length() < 1) {
            return;
        }
        int len = source.length();
        int size = this.list.size();
        Node node = null;
        String str = "";
        int start = 0;
        int end = 0;
        for (int i = 0; i < size; ++i) {
            String splitter;
            node = (Node)this.list.get(i);
            if (node.type == 0) {
                splitter = node.value;
                start = source.indexOf(splitter, end);
                if (start < end || (start += splitter.length()) >= len) break;
                end = start;
                continue;
            }
            int next = i + 1;
            if (next >= size) {
                end = len;
            } else {
                Node nextNode = (Node)this.list.get(next);
                if (nextNode.type != 0) break;
                splitter = nextNode.value;
                end = source.indexOf(splitter, start);
            }
            if (end < start) {
                System.out.println("input error: no matched splitter found");
                break;
            }
            str = source.substring(start, end);
            dest.put(node.value, str);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Node node = null;
        for (int i = 0; i < this.list.size(); ++i) {
            node = (Node)this.list.get(i);
            if (node.type == 0) {
                if (node.value.indexOf(36) != -1) {
                    ret.append(node.value.replaceAll("$", "$$"));
                    continue;
                }
                ret.append(node.value);
                continue;
            }
            ret.append('$');
            ret.append(node.value);
            ret.append('$');
        }
        return ret.toString();
    }

    protected static class Node {
        public static final short STRING = 0;
        public static final short PROPERTY = 1;
        public short type;
        public String value;

        public Node(short t, String v) {
            this.type = t;
            this.value = v;
        }
    }
}

