/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.SignatureFieldInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.CAIdentityAuthorize;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.EASSignatureInfo;
import com.kingdee.eas.base.security.IEASSignature;
import com.kingdee.eas.base.security.PkiSecurityException;
import com.kingdee.eas.base.security.SignatureStatusEnum;
import com.kingdee.eas.base.security.client.provider.UsbkeyCAProviderFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameHelperFacadeFactory;
import com.kingdee.eas.framework.IFrameHelperFacade;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ObjectValueSignature {
    private static Logger logger = Logger.getLogger(ObjectValueSignature.class);
    public static Map signaturConfigMap = null;
    private IUIObject uiObject = null;

    public IUIObject getUiObject() {
        return this.uiObject;
    }

    public void setUiObject(IUIObject uiObject) {
        this.uiObject = uiObject;
    }

    private byte[] getRomotePlain(BOSObjectType bosType, IObjectPK pk) throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        return facade.getPlainText(bosType, pk);
    }

    private byte[] getRomoteFormatPlain(BOSObjectType bosType, IObjectPK pk) throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        return facade.getFormatPlainText(bosType, pk);
    }

    private static Map getRomoteSignatureConfig() throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        Map map = facade.getSignatrueConfig();
        return map;
    }

    private List getRomotePlainCollection(BOSObjectType bosType, IObjectPK[] pk, String fieldKeyName) throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        return facade.getPlainTextCollection(bosType, pk, fieldKeyName);
    }

    private List getRomoteFormatPlainCollection(BOSObjectType bosType, IObjectPK[] pk, String fieldKeyName) throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        return facade.getFormatPlainTextCollection(bosType, pk, fieldKeyName);
    }

    private void signature(BOSObjectType bosType, List plainText, List plainFormatText, String status, IObjectPK[] pk) throws BOSException {
    }

    private Map getRomotePlainMapCollection(BOSObjectType bosType, IObjectPK[] pk, String fieldKeyName) throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        return facade.getPlainTextMapCollection(bosType, pk, fieldKeyName);
    }

    private Map getRomoteFormatPlainMapCollection(BOSObjectType bosType, IObjectPK[] pk, String fieldKeyName) throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        return facade.getFormatPlainTextMapCollection(bosType, pk, fieldKeyName);
    }

    private void signature(BOSObjectType bosType, Map plainText, Map plainFormatText, String status, IObjectPK[] pk) throws BOSException {
    }

    public void signature(String status, BOSObjectType bosType, IObjectPK[] pk, String fieldKeyName) throws Exception {
        CAIdentityAuthorize.checkUser();
        CAIdentityAuthorize.checkPassword();
        this.signatureWithoutCheck(status, bosType, pk, fieldKeyName);
    }

    public void signatureWithoutCheck(String status, BOSObjectType bosType, IObjectPK[] pk, String fieldKeyName) throws Exception {
        try {
            Map map = this.getRomotePlainMapCollection(bosType, pk, fieldKeyName);
            Map mapFormat = this.getRomoteFormatPlainMapCollection(bosType, pk, fieldKeyName);
            if (map != null) {
                this.signature(bosType, map, mapFormat, status, pk);
            }
            this.showSucessMsg();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.showFailureMsg();
        }
    }

    public void signature(String status, BOSObjectType bosType, IObjectPK pk) throws Exception {
        try {
            byte[] plainText = this.getRomotePlain(bosType, pk);
            byte[] plainFormatText = this.getRomoteFormatPlain(bosType, pk);
            if (plainText != null && plainText.length > 0) {
                ArrayList<byte[]> list = new ArrayList<byte[]>();
                list.add(plainText);
                ArrayList<byte[]> formatList = new ArrayList<byte[]>();
                formatList.add(plainFormatText);
                ObjectUuidPK[] pkNew = new ObjectUuidPK[]{new ObjectUuidPK(BOSUuid.read((String)pk.toString()))};
                this.signature(bosType, list, formatList, status, (IObjectPK[])pkNew);
            }
            this.showSucessMsg();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.showFailureMsg();
        }
    }

    public void check(String status, BOSObjectType bizType, List<String> signBillIds) throws Exception {
        CAIdentityAuthorize.checkUser();
        CAIdentityAuthorize.checkPassword();
        IEASSignature iEASSignature = EASSignatureFactory.getRemoteInstance();
        try {
            iEASSignature.checkSignature(bizType, signBillIds);
        }
        catch (PkiSecurityException e) {
            if (PkiSecurityException.VERIFY_FAIL_BIZ.getCode().equals(e.getSubCode())) {
                String warningMsg = EASResource.getString((String)"com.kingdee.eas.base.security.PkiSecurityException", (String)PkiSecurityException.VERIFY_FAIL_BIZ.getName());
                MsgBox.showWarning((String)warningMsg);
                SysUtil.abort();
            }
            throw e;
        }
    }

    public boolean checkUsbKeyInited() throws Exception {
        return UsbkeyCAProviderFactory.getProvider().checkUsbKeyInited(this.getUiObject());
    }

    public void _handleSignaturePlainText(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        if (request.get("isCheckUsbKeyInited") != null && !StringUtils.isEmpty((String)request.getId())) {
            ObjectUuidPK pk = new ObjectUuidPK(request.getId());
            try {
                IFrameHelperFacade frameHelperFacade = FrameHelperFacadeFactory.getLocalInstance(ctx);
                byte[] plainText = frameHelperFacade.getPlainText(request.getBosType(), (IObjectPK)pk);
                byte[] plainFormatText = frameHelperFacade.getFormatPlainText(request.getBosType(), (IObjectPK)pk);
                if (plainText != null && plainText.length > 0) {
                    response.put("plainText", plainText);
                    response.put("plainFormatText", plainFormatText);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                response.put("isError", true);
            }
        }
    }

    public void _handleSignature(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        if (request.get("plainText") != null) {
            try {
                byte[] plainText = (byte[])request.get("plainText");
                byte[] plainFormatText = (byte[])request.get("plainFormatText");
                List signaturelist = (List)request.get("signaturelist");
                if (plainText != null && plainText.length > 0) {
                    ArrayList<byte[]> list = new ArrayList<byte[]>();
                    list.add(plainText);
                    ArrayList<byte[]> formatList = new ArrayList<byte[]>();
                    formatList.add(plainFormatText);
                    IEASSignature easSignture = EASSignatureFactory.getLocalInstance((Context)ctx);
                    UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                    EASSignatureInfo signatureInfo = null;
                    byte[] objByte = null;
                    byte[] formatByte = null;
                    for (int i = 0; i < list.size(); ++i) {
                        objByte = (byte[])list.get(i);
                        formatByte = (byte[])formatList.get(i);
                        signatureInfo = new EASSignatureInfo();
                        signatureInfo.setBosType(request.getBosType().toString());
                        signatureInfo.setSignature(new String((byte[])signaturelist.get(i), "UTF-8"));
                        signatureInfo.setUser(userInfo);
                        signatureInfo.setPlainText(new String(objByte, "UTF-8"));
                        signatureInfo.setFormatPlainText(new String(formatByte, "UTF-8"));
                        signatureInfo.setAuditStatus(SignatureStatusEnum.SUCCESS);
                        easSignture.addnew((CoreBaseInfo)signatureInfo);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                response.put("isError", true);
            }
        }
    }

    public void signaturePlainText(String status, BOSObjectType bosType, IObjectPK pk) throws Exception {
        boolean bool = this.checkUsbKeyInited();
        if (!bool) {
            return;
        }
        try {
            byte[] plainText = this.getRomotePlain(bosType, pk);
            byte[] plainFormatText = this.getRomoteFormatPlain(bosType, pk);
            if (plainText != null && plainText.length > 0) {
                ArrayList<byte[]> list = new ArrayList<byte[]>();
                list.add(plainText);
                ArrayList<byte[]> formatList = new ArrayList<byte[]>();
                formatList.add(plainFormatText);
                ObjectUuidPK[] pkNew = new ObjectUuidPK[]{new ObjectUuidPK(BOSUuid.read((String)pk.toString()))};
                this.signature(bosType, list, formatList, status, (IObjectPK[])pkNew);
            }
            this.showSucessMsg();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.showFailureMsg();
        }
    }

    public static void prepareIsHasBosTypeConfig(RequestContext request, BOSObjectType bosType) {
        try {
            if (bosType != null && signaturConfigMap == null) {
                request.put("isHasBosTypeConfig", true);
            }
        }
        catch (Exception err) {
            return;
        }
    }

    public static boolean isHasBosTypeConfig(BOSObjectType bosType) {
        if (bosType != null) {
            SignatureFieldInfo info;
            if (signaturConfigMap == null) {
                try {
                    signaturConfigMap = ObjectValueSignature.getRomoteSignatureConfig();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (signaturConfigMap != null && signaturConfigMap.containsKey(bosType.toString()) && (info = (SignatureFieldInfo)signaturConfigMap.get(bosType.toString())).isSignatureNeeded()) {
                return true;
            }
        }
        return false;
    }

    public void showSucessMsg() {
    }

    public void showFailureMsg() {
        String failureMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Signature_failure");
        if (this.getUiObject() != null) {
            MsgBox.showError((Component)((CoreUI)this.getUiObject()), (String)failureMsg);
        } else {
            MsgBox.showError((String)failureMsg);
        }
        SysUtil.abort();
    }

    public static boolean isBosTypeSignatureWhenApprove(BOSObjectType bosType) {
        SignatureFieldInfo info;
        return ObjectValueSignature.isHasBosTypeConfig(bosType) && (info = (SignatureFieldInfo)signaturConfigMap.get(bosType.toString())).isSignatureWhenApprove();
    }
}

