/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.app.CustomerParams;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.app.context.IMultiOrgSupportApp;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;

public class OrgContextService {
    private IMultiOrgSupportApp multiOrgSupport = null;

    public void initDefaultMainOrgContext(RequestContext request, ResponseContext response, Context context) throws Exception {
        ContextTypeEnum contextType = (ContextTypeEnum)((Object)request.get("CONTEXTTYPE"));
        OrgType orgType = request.getMainOrgType();
        if (contextType != null && ContextTypeEnum.INMAINTAINING.equals((Object)contextType) && "ADDNEW".equals(request.getState())) {
            FullOrgUnitCollection orgCol;
            String orgUnitID = null;
            if (request.getOrg() != null) {
                orgUnitID = request.getOrg().toString();
            }
            if (orgUnitID == null && ContextUtil.getCurrentOrgUnit((Context)context, (OrgType)orgType) != null) {
                orgUnitID = ContextUtil.getCurrentOrgUnit((Context)context, (OrgType)orgType).getId().toString();
            }
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)context);
            String permissionItem = null;
            if (this.multiOrgSupport != null) {
                permissionItem = this.multiOrgSupport.getPermissionItem();
            }
            IPermission permission = PermissionFactory.getLocalInstance((Context)context);
            if (!StringUtils.isEmpty((String)permissionItem) && orgUnitID != null && user != null && !permission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(orgUnitID), permissionItem)) {
                orgUnitID = null;
            }
            if (orgUnitID == null && (orgCol = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(user.getId()), orgType, (IObjectPK)new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType)), permissionItem)) != null && orgCol.size() > 0) {
                orgUnitID = orgCol.get(0).getId().toString();
            }
            if (orgUnitID != null) {
                request.setOrg((IObjectPK)new ObjectUuidPK(orgUnitID));
                new BaseFrameService().switchMainOrg(request, response, context);
            }
        }
    }

    public FilterInfo changeQueryContext(Context context, QuerySolutionInfo solution, RequestContext request, ResponseContext response) throws Exception {
        OrgUnitInfo[] orgs = this.getOrgFromQuerySolution(solution, request, context);
        OrgUnitInfo mainOrg = this.convertDataToOrgUnitInfo(context, orgs);
        OrgType orgType = request.getMainOrgType();
        String permissionItem = null;
        if (this.multiOrgSupport != null) {
            permissionItem = this.multiOrgSupport.getPermissionItem();
        }
        String propertyOfBizOrg = (String)request.get("PROPERTY_OF_BIZORG");
        if (mainOrg == null && orgType != null) {
            OrgUnitInfo currOrg = ContextUtil.getCurrentOrgUnit((Context)context, (OrgType)orgType);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)context);
            if (currOrg != null && user != null && permissionItem != null && !StringUtils.isEmpty((String)permissionItem) && PermissionFactory.getLocalInstance((Context)context).hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(currOrg.getId()), permissionItem)) {
                mainOrg = currOrg;
            }
        }
        if (mainOrg != null) {
            request.setOrg((IObjectPK)new ObjectUuidPK(mainOrg.getId()));
            new BaseFrameService().switchMainOrg(request, response, context);
        }
        FilterInfo filter = new FilterInfo();
        if (propertyOfBizOrg != null) {
            if (orgs != null && orgs.length > 0) {
                HashSet<String> idSet = new HashSet<String>();
                for (int i = 0; i < orgs.length; ++i) {
                    idSet.add(orgs[i].getId().toString());
                }
                filter.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, idSet, CompareType.INCLUDE));
            } else if (mainOrg != null) {
                filter.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, (Object)mainOrg.getId().toString()));
            }
        }
        return filter;
    }

    private OrgUnitInfo convertDataToOrgUnitInfo(Context ctx, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof OrgUnitInfo) {
            return (OrgUnitInfo)data;
        }
        if (data instanceof Object[]) {
            Object[] orgs = (Object[])data;
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            BOSUuid userDefaultOrgID = userInfo.getDefOrgUnit().getId();
            for (int i = 0; i < orgs.length; ++i) {
                if (!((OrgUnitInfo)orgs[i]).getId().equals((Object)userDefaultOrgID)) continue;
                return (OrgUnitInfo)orgs[i];
            }
            if (orgs.length > 0) {
                return (OrgUnitInfo)orgs[0];
            }
        }
        return null;
    }

    private OrgUnitInfo[] getOrgFromQuerySolution(QuerySolutionInfo solution, RequestContext request, Context context) throws Exception {
        String key = (String)request.get("MAINBIZORG_KEY_CP");
        String delimiters = (String)request.get("QUERY_DELIMITERS");
        if (solution != null && key != null && delimiters != null) {
            QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
            int size = queryPanelCollection.size();
            for (int i = 0; i < size; ++i) {
                String params;
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
                if (queryPanelInfo.getPanelClassName() == null || !QueryPanelTypeEnum.CUSTOMER_PANEL.equals((Object)queryPanelInfo.getQueryPanelType()) || (params = queryPanelInfo.getCustomerParams()) == null) continue;
                CustomerParams cp = new CustomerParams();
                ArrayList al = XMLBean.TransStrToAL((String)params);
                Iterator j = al.iterator();
                XMLBean xb = null;
                while (j.hasNext()) {
                    xb = (XMLBean)j.next();
                    cp.addCustomerParam(xb.getName(), xb.getValue());
                }
                String orgs = cp.getCustomerParam(key);
                if (orgs == null) continue;
                return this.getOrgUnitInfos(context, orgs, delimiters);
            }
        }
        return null;
    }

    private OrgUnitInfo[] getOrgUnitInfos(Context ctx, String ids, String delim) throws Exception {
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getKeyIdList(ids, delim), CompareType.INCLUDE));
        view.setFilter(filter);
        FullOrgUnitCollection collection = iOrgUnit.getFullOrgUnitCollection(view);
        OrgUnitInfo[] results = new OrgUnitInfo[collection.size()];
        for (int i = 0; i < collection.size(); ++i) {
            results[i] = collection.get(i);
        }
        return results;
    }

    private LinkedHashSet getKeyIdList(String ids, String delim) {
        StringTokenizer stk = new StringTokenizer(ids, delim);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        while (stk.hasMoreTokens()) {
            result.add(String.valueOf(stk.nextToken()).trim());
        }
        return result;
    }

    public void setMultiOrgSupport(IMultiOrgSupportApp multiOrgSupport) {
        this.multiOrgSupport = multiOrgSupport;
    }
}

