/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.cache;

import com.kingdee.eas.framework.cache.CacheStatInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class CacheStat {
    private static Logger logger = Logger.getLogger((String)"cachestat");
    private static CacheStat cacheStat;
    private Hashtable stats = new Hashtable();

    protected CacheStat() {
    }

    public static synchronized CacheStat getInstance() {
        if (cacheStat == null) {
            cacheStat = new CacheStat();
        }
        return cacheStat;
    }

    public void doStat(String regionName, String objName, boolean fromDb) {
        CacheStatInfo info = null;
        String key = regionName + "!" + objName;
        if (this.stats.containsKey(key)) {
            info = (CacheStatInfo)this.stats.get(key);
            if (fromDb) {
                info.setFromDb(info.getFromDb() + 1);
            } else {
                info.setTotalAccess(info.getTotalAccess() + 1);
            }
        } else {
            info = new CacheStatInfo();
            if (fromDb) {
                info.setFromDb(1);
            } else {
                info.setTotalAccess(1);
            }
            this.stats.put(key, info);
        }
    }

    public void printStat() {
        int fromDb = 0;
        int totalAccess = 0;
        String out = null;
        Enumeration enum1 = this.stats.keys();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            CacheStatInfo info = (CacheStatInfo)this.stats.get(key);
            out = key;
            out = out + "\t" + new Integer(info.getTotalAccess() - info.getFromDb());
            out = out + "\t" + new Integer(info.getFromDb());
            out = out + "\t" + new Float(1.0 - (double)info.getFromDb() * 1.0 / (double)info.getTotalAccess());
            fromDb += info.getFromDb();
            totalAccess += info.getTotalAccess();
        }
        out = EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"0_CacheStat");
        out = out + "\t" + new Integer(totalAccess - fromDb);
        out = out + "\t" + new Integer(fromDb);
        out = out + "\t" + new Float(1.0 - (double)fromDb * 1.0 / (double)totalAccess);
    }
}

