/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.expression;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class UILayoutExecutorHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.expression.UILayoutExecutorHelper");
    private static double MaxFloat = 3.4028234663852886E38;
    private static double MinFloat = -3.4028234663852886E38;
    public static final String CONFIGURE_ORDER = "_Configure_Order";

    public static void initComponent(EntityObjectInfo entity, ComponentInfo cInfo, Component comp) {
        if (entity == null || cInfo == null || comp == null) {
            return;
        }
        String bindField = UILayoutExecutorHelper.getBindField(cInfo);
        com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)entity, (String)bindField);
        if (comp instanceof KDBizPromptBox && prop != null && prop instanceof LinkPropertyInfo) {
            KDBizPromptBox promt = (KDBizPromptBox)comp;
            RelationshipInfo relationShip = ((LinkPropertyInfo)prop).getRelationship();
            EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
            String sQueryPK = null;
            if (supplyEntityInfo != null && !StringUtils.isEmpty((String)(sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query")))) {
                String display = ((LinkPropertyInfo)prop).getExtendedProperty("dataField");
                display = UILayoutExecutorHelper.parseStrToDisplayField(display);
                promt.setQueryInfo(sQueryPK);
                promt.setVisible(true);
                promt.setEditable(true);
                promt.setDisplayFormat(display);
                promt.setEditFormat("$number$");
                promt.setCommitFormat("$number$");
                UILayoutExecutorHelper.setSelector(supplyEntityInfo, promt);
            }
        } else if (comp instanceof KDComboBox && prop != null && prop instanceof OwnPropertyInfo) {
            BizEnumInfo enumInfo;
            KDComboBox combo = (KDComboBox)comp;
            if (prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).getDataType() == DataType.ENUM && (enumInfo = ((OwnPropertyInfo)prop).getEnumType()) != null) {
                combo.addItems(EnumUtils.getEnumList((String)enumInfo.getClassName()).toArray());
            }
        } else if (comp instanceof KDTextField || comp instanceof KDFormattedTextField) {
            PropertyCollection pcol = cInfo.getProperties();
            int maxLength = -1;
            int precision = -1;
            String MINIMUMVALUE = null;
            String MAXIMUMVALUE = null;
            int size = pcol.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo pInfo = pcol.get(i);
                if (pInfo.getName().equals("maxLength")) {
                    maxLength = Integer.valueOf(pInfo.getValue());
                }
                if (pInfo.getName().equals("minimumValue")) {
                    MINIMUMVALUE = pInfo.getValue().replaceAll("\"", "");
                }
                if (pInfo.getName().equals("maximumValue")) {
                    MAXIMUMVALUE = pInfo.getValue().replaceAll("\"", "");
                }
                if (!pInfo.getName().equals("precision")) continue;
                precision = Integer.valueOf(pInfo.getValue());
            }
            if (comp instanceof KDTextField && maxLength != -1) {
                ((KDTextField)comp).setMaxLength(maxLength);
            } else if (comp instanceof KDFormattedTextField) {
                ((KDFormattedTextField)comp).setDataType(1);
                if (precision != -1) {
                    ((KDFormattedTextField)comp).setPrecision(precision);
                }
                if (!StringUtils.isEmpty(MINIMUMVALUE)) {
                    ((KDFormattedTextField)comp).setMinimumValue((Comparable)new BigDecimal(MINIMUMVALUE));
                }
                if (!StringUtils.isEmpty(MAXIMUMVALUE)) {
                    ((KDFormattedTextField)comp).setMaximumValue((Comparable)new BigDecimal(MAXIMUMVALUE));
                }
                ((KDFormattedTextField)comp).setSupportedEmpty(true);
            }
        }
    }

    public static void initCellEditor(EntityObjectInfo entity, ComponentInfo tableControl, KDTable kdtEntrys, DataBinder dataBinder) {
        if (entity == null || tableControl == null || kdtEntrys == null) {
            return;
        }
        PropertyInfo property = tableControl.getProperties().get("formatXml");
        if (property != null) {
            int i;
            KDTDefaultCellEditor editor;
            com.kingdee.bos.metadata.entity.PropertyInfo prop;
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
            HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
            List columns = tableInfo.getColumns();
            ArrayList<com.kingdee.bos.metadata.entity.PropertyInfo> propList = new ArrayList<com.kingdee.bos.metadata.entity.PropertyInfo>(5);
            ArrayList<KDTDefaultCellEditor> editorList = new ArrayList<KDTDefaultCellEditor>(5);
            ArrayList<CellInfo> cellList = new ArrayList<CellInfo>(5);
            ArrayList<PropertyBindingInfo> pbList = new ArrayList<PropertyBindingInfo>(5);
            int n = columns.size();
            for (int i2 = 0; i2 < n; ++i2) {
                ColumnInfo columnInfo = (ColumnInfo)columns.get(i2);
                String preFixName = tableControl.getName() + "_" + columnInfo.getName();
                String bindField = UILayoutExecutorHelper.getColumnBindField(tableControl, columnInfo.getName());
                prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)entity, (String)bindField);
                if (prop == null || !prop.isConfigured() || (editor = UILayoutExecutorHelper.getCellEditor(prop, preFixName)) == null) continue;
                propList.add(prop);
                editorList.add(editor);
                cellList.add((CellInfo)headerInfo.getCells().get(i2));
                pbList.add(UILayoutExecutorHelper.getColumnPropertyBinding(tableControl, columnInfo.getName()));
            }
            if (propList.size() == 0) {
                logger.info((Object)"no configure column");
                return;
            }
            IRow head = kdtEntrys.getHeadRow(0);
            int n2 = propList.size();
            for (i = 0; i < n2; ++i) {
                prop = (com.kingdee.bos.metadata.entity.PropertyInfo)propList.get(i);
                editor = (KDTDefaultCellEditor)editorList.get(i);
                CellInfo cellInfo = (CellInfo)cellList.get(i);
                IColumn column = kdtEntrys.addColumn();
                column.setKey(prop.getName());
                column.setEditor((ICellEditor)editor);
                UILayoutExecutorHelper.setColumnStyle(prop, column);
                ICell cell = head.getCell(column.getColumnIndex());
                String cellName = cellInfo.getName();
                if (StringUtils.isEmpty((String)cellName)) {
                    cell.setValue((Object)prop.getName());
                    continue;
                }
                cell.setValue((Object)cellName);
            }
            n2 = pbList.size();
            for (i = 0; i < n2; ++i) {
                PropertyBindingInfo pbInfo = (PropertyBindingInfo)pbList.get(i);
                Class clazz = UILayoutExecutorHelper.getClassName(pbInfo.getFieldType());
                if (clazz == null) continue;
                dataBinder.registerBinding(pbInfo.getBingdingField(), clazz, (Component)kdtEntrys, pbInfo.getPropertyName());
                logger.info((Object)("entry bind:dataBinder.registerBinding(" + pbInfo.getBingdingField() + "," + clazz + "," + kdtEntrys.getName() + "," + pbInfo.getPropertyName() + ");"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reOrderTableColumn(KDTable entry, UIObjectInfo cfgUI) {
        String order;
        if (entry != null && cfgUI != null && !StringUtils.isEmpty((String)(order = cfgUI.getExtendedProperty(entry.getName() + CONFIGURE_ORDER)))) {
            logger.info((Object)("------------ load " + entry.getName() + " columns' order -----------"));
            logger.info((Object)(entry.getName() + CONFIGURE_ORDER + ":" + order));
            String[] orders = order.split("\\|");
            ArrayList<String> list = new ArrayList<String>(orders.length);
            int size = orders.length;
            for (int j = 0; j < size; ++j) {
                list.add(orders[j]);
            }
            boolean moveable = entry.isColumnMoveable();
            try {
                entry.setColumnMoveable(true);
                KDTColumns columns = entry.getColumns();
                int m = 0;
                int columnCount = columns.size();
                int size2 = list.size();
                for (int j = 0; j < size2; ++j) {
                    int index = columns.getColumnIndex(list.get(j).toString());
                    if (index == -1 || m >= columnCount) continue;
                    entry.moveColumn(index, m);
                    ++m;
                }
            }
            catch (Exception e) {
                logger.error((Object)("reset " + entry.getName() + " columns' order error"), (Throwable)e);
            }
            finally {
                entry.setColumnMoveable(moveable);
            }
        }
    }

    private static void setColumnStyle(com.kingdee.bos.metadata.entity.PropertyInfo prop, IColumn column) {
        if (column == null) {
            return;
        }
        if (prop != null && prop instanceof LinkPropertyInfo) {
            RelationshipInfo relationShip = ((LinkPropertyInfo)prop).getRelationship();
            EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
            String sQueryPK = null;
            if (supplyEntityInfo != null && !StringUtils.isEmpty((String)(sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query")))) {
                String display = ((LinkPropertyInfo)prop).getExtendedProperty("dataField");
                display = UILayoutExecutorHelper.parseStrToDisplayField(display);
                ObjectValueRender render = new ObjectValueRender();
                render.setFormat((IDataFormat)new BizDataFormat(display));
                column.setRenderer((IBasicRender)render);
            }
        } else if (prop != null && UILayoutExecutorHelper.getMappingField(prop) != null && UILayoutExecutorHelper.getMappingField(prop).getTypeName() != null) {
            if (UILayoutExecutorHelper.getMappingField(prop).getTypeName().equals((Object)SQLType.DATETIME)) {
                column.getStyleAttributes().setNumberFormat("yyyy-MM-dd");
            }
            if (UILayoutExecutorHelper.getMappingField(prop).getTypeName().equals((Object)SQLType.NUMERIC)) {
                int pre = ((OwnPropertyInfo)prop).getDecimalDigits();
                pre = pre < 0 ? 0 : pre;
                column.getStyleAttributes().setNumberFormat("%[\".\" " + pre + "]f");
            }
        }
    }

    private static KDTDefaultCellEditor getCellEditor(com.kingdee.bos.metadata.entity.PropertyInfo prop, String preFixName) {
        if (prop != null && prop instanceof LinkPropertyInfo) {
            RelationshipInfo relationShip = ((LinkPropertyInfo)prop).getRelationship();
            EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
            String sQueryPK = null;
            if (supplyEntityInfo != null && !StringUtils.isEmpty((String)(sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query")))) {
                KDBizPromptBox _PromptBox = new KDBizPromptBox();
                String display = ((LinkPropertyInfo)prop).getExtendedProperty("dataField");
                display = UILayoutExecutorHelper.parseStrToDisplayField(display);
                _PromptBox.setQueryInfo(sQueryPK);
                _PromptBox.setVisible(true);
                _PromptBox.setEditable(true);
                _PromptBox.setDisplayFormat(display);
                _PromptBox.setEditFormat("$number$");
                _PromptBox.setCommitFormat("$number$");
                return new KDTDefaultCellEditor((IKDEditor)_PromptBox);
            }
        } else if (prop != null && UILayoutExecutorHelper.getMappingField(prop) != null && UILayoutExecutorHelper.getMappingField(prop).getTypeName() != null) {
            if (prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).getDataType() == DataType.ENUM) {
                BizEnumInfo enumInfo = ((OwnPropertyInfo)prop).getEnumType();
                if (enumInfo != null) {
                    KDComboBox _ComboBox = new KDComboBox();
                    _ComboBox.setName(preFixName + "_ComboBox");
                    _ComboBox.setVisible(true);
                    _ComboBox.addItems(EnumUtils.getEnumList((String)enumInfo.getClassName()).toArray());
                    return new KDTDefaultCellEditor((JComboBox)_ComboBox);
                }
            } else {
                if (UILayoutExecutorHelper.getMappingField(prop).getTypeName().equals((Object)SQLType.DATETIME)) {
                    KDDatePicker _DatePicker = new KDDatePicker();
                    _DatePicker.setName(preFixName + "_DatePicker");
                    _DatePicker.setVisible(true);
                    _DatePicker.setEditable(true);
                    return new KDTDefaultCellEditor(_DatePicker);
                }
                if (UILayoutExecutorHelper.getMappingField(prop).getTypeName().equals((Object)SQLType.NVARCHAR)) {
                    KDTextField _TextField = new KDTextField();
                    _TextField.setName(preFixName + "_TextField");
                    _TextField.setMaxLength(UILayoutExecutorHelper.getMappingField(prop).getLength());
                    return new KDTDefaultCellEditor((JTextField)_TextField);
                }
                if (prop instanceof OwnPropertyInfo && DataType.BOOLEAN.equals((Object)((OwnPropertyInfo)prop).getDataType())) {
                    KDCheckBox _CheckBox = new KDCheckBox();
                    _CheckBox.setName(preFixName + "_CheckBox");
                    return new KDTDefaultCellEditor((JCheckBox)_CheckBox);
                }
                if (UILayoutExecutorHelper.getMappingField(prop).getTypeName().equals((Object)SQLType.INT) || UILayoutExecutorHelper.getMappingField(prop).getTypeName().equals((Object)SQLType.NUMERIC)) {
                    KDFormattedTextField _TextField = new KDFormattedTextField();
                    _TextField.setName(preFixName + "_TextField");
                    _TextField.setVisible(true);
                    _TextField.setEditable(true);
                    _TextField.setHorizontalAlignment(2);
                    _TextField.setSupportedEmpty(true);
                    if (UILayoutExecutorHelper.getMappingField(prop).getTypeName().equals((Object)SQLType.INT)) {
                        _TextField.setDataType(0);
                    } else {
                        _TextField.setDataType(1);
                        _TextField.setMinimumValue((Comparable)new BigDecimal("-9.999999999E7"));
                        _TextField.setMaximumValue((Comparable)new BigDecimal("9.999999999E7"));
                        int pre = ((OwnPropertyInfo)prop).getDecimalDigits();
                        _TextField.setPrecision(pre < 0 ? 0 : pre);
                    }
                    return new KDTDefaultCellEditor((JTextField)_TextField);
                }
            }
        }
        return null;
    }

    public static String getBindField(ComponentInfo cInfo) {
        if (cInfo == null) {
            return null;
        }
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (StringUtils.isEmpty((String)pbInfo.getBingdingField())) continue;
            return pbInfo.getBingdingField();
        }
        return null;
    }

    private static String getColumnBindField(ComponentInfo cInfo, String columnName) {
        if (cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        String tableColumnName = "";
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            return pbInfo.getBingdingField();
        }
        return null;
    }

    private static PropertyBindingInfo getColumnPropertyBinding(ComponentInfo cInfo, String columnName) {
        if (cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            String tableColumnName;
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            return pbInfo;
        }
        return null;
    }

    public static BizUnitInfo loadBizUnit(MetaDataPK pk) {
        BizUnitInfo bizUnit = null;
        if (pk != null) {
            try {
                BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ContextManager.getContext());
                bizUnit = bizUnitCtrl.getValue((IMetaDataPK)pk);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return bizUnit;
    }

    public static String parseStrToDisplayField(String sDisField) {
        if (StringUtils.isEmpty((String)sDisField)) {
            return "$number$";
        }
        String strFirst = "";
        String strLeft = "";
        String strSecond = "";
        String strRight = "";
        String strTemp = "";
        String sDisplayFormat = "";
        boolean bAddDisField = false;
        int iPos = sDisField.indexOf("+");
        if (iPos > 0) {
            strFirst = sDisField.substring(0, iPos).trim();
            String sKey = "";
            strTemp = sDisField.substring(iPos + 2);
            sDisplayFormat = "$" + strFirst + "$";
            if (sDisField.trim().length() > iPos && strTemp.trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                strLeft = strTemp.substring(0, iPos);
                strLeft = strLeft.replaceAll("\"", "");
                sDisplayFormat = sDisplayFormat + strLeft;
                if (strTemp.trim().length() > iPos + 1 && (strTemp = strTemp.substring(iPos + 2)).trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                    strSecond = strTemp.substring(0, iPos);
                    sDisplayFormat = sDisplayFormat + "$" + strSecond.trim() + "$";
                    if (strTemp.length() > iPos + 1) {
                        strRight = strTemp.substring(iPos + 2);
                        strRight = strRight.replaceAll("\"", "");
                        sDisplayFormat = sDisplayFormat + strRight;
                    }
                }
            }
        } else {
            strFirst = sDisField.trim();
            sDisplayFormat = "$" + strFirst + "$";
        }
        return sDisplayFormat;
    }

    public static Class getClassName(String name) {
        Class<?> clazz;
        if ("String".equals(name)) {
            return String.class;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"ClassNotFoundException! Class not found when registerBinding in UILayoutExecutor!");
            return null;
        }
        return clazz;
    }

    private static com.kingdee.bos.metadata.data.ColumnInfo getMappingField(com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        if (prop == null) {
            return null;
        }
        if (prop.getMappingField() != null) {
            return prop.getMappingField();
        }
        if (prop.getExtendedField() != null) {
            return prop.getExtendedField().getExtendedColumn();
        }
        return null;
    }

    public static void removeCfgCell(EntityObjectInfo entity, ComponentInfo tableControl, KDTable kdtEntrys, DataBinder dataBinder) {
        if (entity == null || tableControl == null || kdtEntrys == null) {
            return;
        }
        PropertyInfo property = tableControl.getProperties().get("formatXml");
        if (property != null) {
            com.kingdee.bos.metadata.entity.PropertyInfo prop;
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
            List columns = tableInfo.getColumns();
            ArrayList<com.kingdee.bos.metadata.entity.PropertyInfo> propList = new ArrayList<com.kingdee.bos.metadata.entity.PropertyInfo>(5);
            ArrayList<PropertyBindingInfo> pbList = new ArrayList<PropertyBindingInfo>(5);
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
                String bindField = UILayoutExecutorHelper.getColumnBindField(tableControl, columnInfo.getName());
                prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)entity, (String)bindField);
                if (prop == null || !prop.isConfigured()) continue;
                propList.add(prop);
                pbList.add(UILayoutExecutorHelper.getColumnPropertyBinding(tableControl, columnInfo.getName()));
            }
            if (propList.size() == 0) {
                logger.info((Object)"no configure columns");
                return;
            }
            int n2 = pbList.size();
            for (int i = 0; i < n2; ++i) {
                PropertyBindingInfo pbInfo = (PropertyBindingInfo)pbList.get(i);
                Class clazz = UILayoutExecutorHelper.getClassName(pbInfo.getFieldType());
                if (clazz == null) continue;
                dataBinder.unRegisterBinding(pbInfo.getBingdingField(), clazz, (Component)kdtEntrys, pbInfo.getPropertyName());
                logger.info((Object)("entry unRegisterBind:dataBinder.unRegisterBinding(" + pbInfo.getBingdingField() + "," + clazz + "," + kdtEntrys.getName() + "," + pbInfo.getPropertyName() + ");"));
            }
            int n3 = propList.size();
            for (int i = 0; i < n3; ++i) {
                prop = (com.kingdee.bos.metadata.entity.PropertyInfo)propList.get(i);
                IColumn column = kdtEntrys.getColumn(prop.getName());
                if (column == null) continue;
                kdtEntrys.removeColumn(column.getColumnIndex());
                logger.info((Object)("delete column:" + column.getKey()));
            }
        }
    }

    public static boolean containPropertyByName(ComponentInfo component, String name) {
        PropertyInfo prop;
        return component != null && (prop = component.getPropertyByName(name)) != null;
    }

    public static int getLabelLength(ComponentInfo component) {
        PropertyInfo prop;
        if (component != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(component.getClassType()) && (prop = component.getPropertyByName("boundLabelLength")) != null) {
            try {
                return Integer.parseInt(prop.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean getLabelUnderLine(ComponentInfo component) {
        PropertyInfo prop;
        if (component != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(component.getClassType()) && (prop = component.getPropertyByName("boundLabelUnderline")) != null) {
            try {
                return Boolean.valueOf(prop.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private static void setSelector(EntityObjectInfo entity, KDBizPromptBox promt) {
        block7: {
            if (entity != null && promt != null) {
                String selector = entity.getExtendedProperty("f7UsedListUIClassName");
                if (!StringUtils.isEmpty((String)selector)) {
                    try {
                        Object obj = Class.forName(selector).newInstance();
                        if (obj instanceof KDPromptSelector) {
                            promt.setSelector((KDPromptSelector)obj);
                            break block7;
                        }
                        logger.info((Object)"is not instanceof KDPromptSelector");
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                } else {
                    logger.info((Object)"selector is null,do not set selector for KDBizPromptBox");
                }
            } else {
                logger.info((Object)"can not set the selector becourse the entity or promt is null");
            }
        }
    }
}

