/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query.component;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.framework.query.component.AutoCompletionTextField;
import com.kingdee.eas.framework.query.component.IAutoCompletionPopup;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IPopupInvoker;
import com.kingdee.eas.framework.query.component.IQueryTextField;
import com.kingdee.eas.framework.query.component.ItemLabel;
import com.kingdee.eas.framework.query.component.ListPopup;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import javax.swing.JComponent;

public abstract class AbstractAutoCompletionPopup
implements IAutoCompletionPopup,
IPopupInvoker {
    private static int DEFAULT_PREFERRED_HEIGHT = 100;
    protected ListPopup popup;
    protected int preferredHeight = DEFAULT_PREFERRED_HEIGHT;
    protected LinkedList<IListPopupItem> popupItems = new LinkedList();
    protected int quickItemSize = 0;
    protected AutoCompletionTextField autoCompletionTextField;

    public AbstractAutoCompletionPopup(AutoCompletionTextField autoCompletionTextField) {
        this.autoCompletionTextField = autoCompletionTextField;
        this.createPopup();
    }

    protected void initPopupValue() throws BOSException {
        this.setPopupPreferredHeight(25 * this.quickItemSize + 5);
    }

    protected void setPopupPreferredHeight(int h) {
        this.preferredHeight = h;
    }

    protected void createPopup() {
        this.popup = new ListPopup(this, false);
    }

    @Override
    public void changeList() {
        this.popup.setList(this.popupItems);
        if (this.popup.getSelectedIndex() == -1) {
            this.popup.setSelectedIndex(0);
        }
        this.popup.repaint();
    }

    @Override
    public boolean isPopupVisible() {
        return this.popup.isVisible();
    }

    @Override
    public void setPopupVisible(boolean visible) {
        this.popup.setVisible(visible);
    }

    @Override
    public void processKeyPress(KeyEvent e) {
        this.popup.keyPressed(e);
    }

    @Override
    public void showPopup() {
        this.popup.show();
    }

    @Override
    public Rectangle getFocusedBounds() {
        return null;
    }

    @Override
    public JComponent getOwner() {
        return this.autoCompletionTextField;
    }

    @Override
    public Point getPopupLocation() {
        return new Point(0, this.autoCompletionTextField.getHeight() - 1);
    }

    @Override
    public Dimension getPopupSize() {
        return new Dimension(this.autoCompletionTextField.getWidth(), this.preferredHeight);
    }

    @Override
    public ItemLabel createItemLabel(IQueryTextField queryTextField, IListPopupItem listPopupItem) {
        return new ItemLabel(queryTextField, listPopupItem);
    }

    @Override
    public boolean doNotAllowInput() {
        return false;
    }
}

