/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query.component;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.LimitedLengthDocument;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.component.IBorderClip;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItemExecute;
import com.kingdee.eas.framework.query.component.IMouseOverIntention;
import com.kingdee.eas.framework.query.component.IQueryTextField;
import com.kingdee.eas.framework.query.component.ItemLabel;
import com.kingdee.eas.framework.query.component.KDRoundRectLabel;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.text.Document;

public class QueryTextField
extends KDTextField
implements IQueryTextField,
IMouseOverIntention {
    private static final long serialVersionUID = -4361662358234740903L;
    public static int iconGap = 6;
    private static final int MAXLEN = 80;
    public static final int MAXITEMSIZE = 3;
    private int maxItemSize = 3;
    private KDLabel searchLabel = new KDLabel((Icon)new ImageIcon(this.getClass().getResource("quick_search.png")));
    private KDLabel clearLabel = new KDLabel((Icon)QuickFilterResources.icon_clear);
    private KDLabel infoLabel = new KDLabel(QuickFilterResources.getMessage("INPUTSEARCHITEM"));
    private LinkedList<ItemLabel> itemLabelList = new LinkedList();
    private Dimension searchIconSize;
    private Dimension infoSize;
    private int itemLabelBeginLocation;
    private int searchIconPosition = 2;
    private boolean showClearIcon = true;
    private boolean showInfoIcon = true;
    private boolean showSearchIcon = true;
    private CellRendererPane cellRendererPane = new CellRendererPane();
    private int mouseLocation = 0;
    private boolean isFocused = false;
    protected KDRoundRectLabel dateRangeBox = null;
    private KDLabel dateRangePopupLabel = new KDLabel((Icon)QuickFilterResources.icon_popup);
    private Dimension popupIconSize;
    private int W_DATEBOX = 70;
    String searchInfoTips;
    private JComponent mouseCom;

    public void setMaxItemSize(int size) {
        this.maxItemSize = size;
    }

    public QueryTextField() {
        this(20);
    }

    public QueryTextField(String text) {
        super(text);
        this.initTextField();
    }

    public QueryTextField(int columns) {
        super(columns);
        this.initTextField();
    }

    public QueryTextField(String text, int columns) {
        super(text, columns);
        this.initTextField();
    }

    public QueryTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.initTextField();
    }

    public void addUserObject(IListPopupItem userObj) {
        ++this.mouseLocation;
        this.itemLabelList.add(this.createItemLabel(userObj));
        if (this.itemLabelList.size() == this.maxItemSize) {
            ((LimitedLengthDocument)this.getDocument()).setMaxLength(0);
        }
    }

    protected ItemLabel createItemLabel(IListPopupItem userObj) {
        return new ItemLabel(this, userObj);
    }

    protected int getW_DATEBOX() {
        return this.W_DATEBOX;
    }

    protected void setW_DATEBOX(int w_datebox) {
        this.W_DATEBOX = w_datebox;
        this.dateRangeBox.setSize(this.W_DATEBOX, 22);
    }

    public void setShowSearchIcon(boolean showSearchIcon) {
        this.showSearchIcon = showSearchIcon;
        this.searchIconSize = new Dimension(0, 0);
    }

    public void setInfoLabelText(String text) {
        this.infoLabel.setText(text);
    }

    @Override
    public CellRendererPane getCellRendererPane() {
        return this.cellRendererPane;
    }

    public void initDateRangePopup(QuickFilteringSupportItems supportItems, IListPopupItemExecute executor) {
        if (StringUtils.isEmpty((String)supportItems.getBizDateField())) {
            return;
        }
        this.dateRangeBox = new KDRoundRectLabel(3);
        this.dateRangeBox.setHasBorder(true);
        this.dateRangeBox.setToolTipText(QuickFilterResources.getMessage("SEARCHDATERANGE"));
        this.dateRangeBox.setPreferredSize(new Dimension(this.W_DATEBOX, 22));
        this.dateRangeBox.setSize(this.W_DATEBOX, 22);
        this.dateRangeBox.setOpaque(true);
        this.dateRangeBox.setBackground(this.dateRangePopupLabel.getBackground());
        this.dateRangeBox.setForeground(Color.BLACK);
        this.dateRangeBox.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void initTextField() {
        this.searchLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.searchLabel.setToolTipText(QuickFilterResources.getMessage("SEARCH"));
        this.searchLabel.setEnabled(false);
        this.searchLabel.setPreferredSize(new Dimension(30, 30));
        this.clearLabel.setToolTipText(QuickFilterResources.getMessage("CLEARSEARCH"));
        this.popupIconSize = new Dimension(10, 10);
        this.setSelectAllOnFocus(false);
        this.searchIconSize = this.searchLabel.getPreferredSize();
        this.infoSize = this.infoLabel.getPreferredSize();
        this.infoLabel.setEnabled(false);
        this.addThisMouseListener();
        this.addThisMouseMotionListener();
        this.addThisFocusListener();
        this.addThisKeyListener();
    }

    private void addThisKeyListener() {
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                String oldText = QueryTextField.this.getText();
                int keyCode = e.getKeyCode();
                switch (keyCode) {
                    case 8: {
                        if (!"".equals(oldText)) break;
                        QueryTextField.this.removeItemLabel(QueryTextField.this.mouseLocation - 1);
                        break;
                    }
                    case 37: {
                        if (QueryTextField.this.mouseLocation > 1) {
                            QueryTextField.this.mouseLocation--;
                        }
                        QueryTextField.this.repaint();
                        break;
                    }
                    case 39: {
                        if (QueryTextField.this.mouseLocation < QueryTextField.this.itemLabelList.size()) {
                            QueryTextField.this.mouseLocation++;
                        }
                        QueryTextField.this.repaint();
                        break;
                    }
                    case 40: {
                        break;
                    }
                }
            }
        });
    }

    private void addThisFocusListener() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                QueryTextField.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                QueryTextField.this.repaint();
            }
        });
    }

    private void addThisMouseMotionListener() {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JComponent com = QueryTextField.this.getComponentAtPoint(e.getPoint());
                QueryTextField.this.setMouseComponent(com, e.getPoint());
                if (com != QueryTextField.this.clearLabel) {
                    QueryTextField.this.clearLabel.setIcon((Icon)QuickFilterResources.icon_clear);
                }
                if (QueryTextField.this.mouseCom instanceof ItemLabel) {
                    QueryTextField.this.invokeItemLabelMouseMotionListener(e);
                }
                QueryTextField.this.setToolTipText(QueryTextField.this.getToolTipText(e));
                QueryTextField.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
    }

    private void addThisMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                QueryTextField.this.setMouseComponent(null, e.getPoint());
                QueryTextField.this.isFocused = false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (QueryTextField.this.mouseCom == QueryTextField.this.clearLabel) {
                    QueryTextField.this.clearFilters();
                } else if (QueryTextField.this.mouseCom == QueryTextField.this.searchLabel) {
                    QueryTextField.this.handleIconClick();
                } else if (QueryTextField.this.mouseCom == QueryTextField.this.dateRangePopupLabel || QueryTextField.this.mouseCom == QueryTextField.this.dateRangeBox) {
                    QueryTextField.this.invokeDateRangeMouseListener(e);
                } else if (QueryTextField.this.mouseCom instanceof ItemLabel) {
                    QueryTextField.this.invokeItemLabelMouseListener(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (QueryTextField.this.mouseCom == QueryTextField.this.clearLabel) {
                    QueryTextField.this.clearLabel.setIcon((Icon)QuickFilterResources.icon_clear_click);
                } else if (QueryTextField.this.mouseCom instanceof ItemLabel) {
                    QueryTextField.this.invokeItemLabelMouseListener(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (QueryTextField.this.mouseCom == QueryTextField.this.clearLabel) {
                    QueryTextField.this.clearLabel.setIcon((Icon)QuickFilterResources.icon_clear_over);
                } else if (QueryTextField.this.mouseCom instanceof ItemLabel) {
                    QueryTextField.this.invokeItemLabelMouseListener(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                QueryTextField.this.isFocused = true;
            }
        });
    }

    protected void invokeDateRangeMouseListener(MouseEvent e) {
    }

    private Dimension getItemPreferredSize() {
        int width = 0;
        int size = this.mouseLocation;
        for (int i = 0; i < size; ++i) {
            ItemLabel item = this.itemLabelList.get(i);
            width += item.getWidth() + iconGap;
        }
        return new Dimension(width, 22);
    }

    protected void handleIconClick() {
    }

    public String getToolTipText(MouseEvent event) {
        if (this.mouseCom == null) {
            return null;
        }
        if (this.mouseCom == this) {
            return this.infoLabel.getText();
        }
        return this.mouseCom.getToolTipText(event);
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.searchIconPosition == 2) {
            insets.left = (int)((double)insets.left + ((double)(this.searchIconSize.width + iconGap) + this.getItemPreferredSize().getWidth()));
            insets.right = this.isShowClearIcon() ? (insets.right += this.searchIconSize.width + iconGap) : (insets.right += iconGap);
            insets.right += this.W_DATEBOX;
        } else {
            insets.left = (int)((double)insets.left + ((double)iconGap + this.getItemPreferredSize().getWidth()));
            insets.right = this.isShowClearIcon() ? (insets.right += this.searchIconSize.width + iconGap) : (insets.right += iconGap);
            insets.right += this.W_DATEBOX;
        }
        return insets;
    }

    private JComponent getComponentAtPoint(Point point) {
        int y;
        int x = (int)point.getX();
        if (!this.contains(x, y = (int)point.getY())) {
            return null;
        }
        if (this.searchIconPosition == 2) {
            if (x < this.searchIconSize.width + iconGap + 2) {
                return this.searchLabel;
            }
            if (this.dateRangeBox != null && x > this.getDateRangeBoxX()) {
                return this.dateRangeBox;
            }
            if (this.dateRangeBox != null && x > this.getDateRangePopupX()) {
                return this.dateRangePopupLabel;
            }
            if (this.isShowingClearIcon() && x > this.getClearLabelX()) {
                return this.clearLabel;
            }
            JComponent itemLabel = this.getItemLabelAtPoint(point);
            if (itemLabel != null) {
                return itemLabel;
            }
        } else {
            if ((this.getText() == null || this.getText().length() == 0) && x > this.getWidth() - this.searchIconSize.width - iconGap - 2) {
                return this.searchLabel;
            }
            if (this.isShowingClearIcon() && x > this.getWidth() - this.searchIconSize.width - iconGap - 2) {
                return this.clearLabel;
            }
            JComponent itemLabel = this.getItemLabelAtPoint(point);
            if (itemLabel != null) {
                return itemLabel;
            }
        }
        return this;
    }

    private JComponent getItemLabelAtPoint(Point point) {
        int y;
        int x = (int)point.getX();
        if (!this.contains(x, y = (int)point.getY())) {
            return null;
        }
        int newX = x - this.itemLabelBeginLocation;
        int width = 0;
        if (newX > 0) {
            int size = this.itemLabelList.size();
            for (int i = 0; i < size; ++i) {
                ItemLabel item = this.itemLabelList.get(i);
                if ((width += item.getWidth() + iconGap) < newX) continue;
                return item;
            }
        }
        return null;
    }

    private int getXAtItemLabel(ItemLabel focusItem, int px) {
        int x = px - this.itemLabelBeginLocation;
        int size = this.itemLabelList.size();
        for (int i = 0; i < size; ++i) {
            ItemLabel item = this.itemLabelList.get(i);
            if (((Object)((Object)item)).equals((Object)focusItem)) {
                return x;
            }
            x -= item.getWidth() + iconGap;
        }
        return x;
    }

    private boolean isShowingClearIcon() {
        return this.showClearIcon && (this.getText() != null && this.getText().length() != 0 || this.hasItemLabel());
    }

    public boolean hasItemLabel() {
        return this.itemLabelList.size() > 0;
    }

    public IListPopupItem[] getListPopupItems() {
        int size = this.itemLabelList.size();
        IListPopupItem[] items = new IListPopupItem[size];
        for (int i = 0; i < size; ++i) {
            ItemLabel item = this.itemLabelList.get(i);
            items[i] = item.getListItem();
        }
        return items;
    }

    private void setMouseComponent(JComponent com, Point p) {
        if (com == null || this.mouseCom != com) {
            this.setDefaultIconStatus(this.mouseCom);
        }
        if (this.mouseCom == com) {
            if (this.itemLabelList.contains(this.mouseCom)) {
                this.setCursor(this.mouseCom.getCursor());
                ((ItemLabel)((Object)this.mouseCom)).setMouseState(true, this.getXAtItemLabel((ItemLabel)((Object)this.mouseCom), p.x));
            }
            return;
        }
        this.mouseCom = com;
        if (this.mouseCom == this) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        } else if (this.mouseCom == this.clearLabel) {
            this.clearLabel.setIcon((Icon)QuickFilterResources.icon_clear_over);
            this.setCursor(this.clearLabel.getCursor());
        } else if (this.mouseCom == this.dateRangeBox) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (this.mouseCom == this.searchLabel) {
            // empty if block
        }
        if (this.mouseCom == this.infoLabel) {
            // empty if block
        }
        this.repaint();
    }

    private void setDefaultIconStatus(JComponent icon) {
        if (icon != null) {
            if (icon == this.clearLabel) {
                this.clearLabel.setIcon((Icon)QuickFilterResources.icon_clear);
            } else if (icon instanceof ItemLabel) {
                ((ItemLabel)((Object)icon)).setMouseState(false, -1);
            }
            this.repaint();
        }
    }

    private void paintItemLabel(Graphics2D g2d, int y) {
        if (this.hasItemLabel()) {
            int x = iconGap + 2;
            if (this.searchIconPosition == 2) {
                x += this.searchIconSize.width;
            }
            y = (int)((double)this.getHeight() / 2.0 - 11.0);
            this.itemLabelBeginLocation = x;
            int size = this.itemLabelList.size();
            for (int i = 0; i < size; ++i) {
                ItemLabel item = this.itemLabelList.get(i);
                x = item.paint(g2d, x, y);
            }
        }
    }

    private void paintInfoLabel(Graphics2D g2d, int y) {
        if (!this.showInfoIcon) {
            return;
        }
        if (!(this.isFocusOwner() || this.getText() != null && this.getText().length() != 0 || this.mouseLocation != 0)) {
            int x = iconGap + 2 + (int)this.getItemPreferredSize().getWidth() + 5;
            if (this.searchIconPosition == 2) {
                x += this.searchIconSize.width;
            }
            FontMetrics fm = g2d.getFontMetrics();
            int width = fm.stringWidth(this.infoLabel.getText()) + 5;
            y = (int)((double)this.getHeight() / 2.0 - this.infoSize.getHeight() / 2.0);
            this.cellRendererPane.paintComponent(g2d, (Component)this.infoLabel, (Container)((Object)this), x, y, width, this.infoSize.height);
        }
    }

    private void paintSearchLabel(Graphics2D g2d, int y) {
        if (!this.showSearchIcon) {
            return;
        }
        if (this.searchIconPosition == 2) {
            this.cellRendererPane.paintComponent(g2d, (Component)this.searchLabel, (Container)((Object)this), iconGap, y, this.searchIconSize.width, this.searchIconSize.height);
        } else if (this.getText() == null || this.getText().length() == 0) {
            this.cellRendererPane.paintComponent(g2d, (Component)this.searchLabel, (Container)((Object)this), this.getWidth() - this.searchIconSize.width - iconGap, y, this.searchIconSize.width, this.searchIconSize.height);
        }
    }

    private void paintClearLabel(Graphics2D g2d, int y) {
        if (!this.showClearIcon) {
            return;
        }
        if (this.getText() != null && this.getText().length() != 0 || this.hasItemLabel()) {
            int x = this.getClearLabelX();
            this.cellRendererPane.paintComponent(g2d, (Component)this.clearLabel, (Container)((Object)this), x, y, this.searchIconSize.width, this.searchIconSize.height);
        }
    }

    private int getClearLabelX() {
        int x = this.getWidth() - this.searchIconSize.width - iconGap;
        if (this.dateRangeBox != null) {
            x -= this.W_DATEBOX;
        }
        return x;
    }

    private void paintDateRangePopupLabel(Graphics2D g2d, int y) {
        if (this.dateRangeBox == null) {
            return;
        }
        this.cellRendererPane.paintComponent(g2d, (Component)this.dateRangePopupLabel, (Container)((Object)this), this.getDateRangePopupX(), y + (this.getHeight() - this.popupIconSize.height) / 2, this.popupIconSize.width, this.popupIconSize.height);
    }

    private int getDateRangePopupX() {
        return this.getWidth() - this.popupIconSize.width - iconGap;
    }

    int getDateRangeBoxX() {
        return this.getWidth() - this.W_DATEBOX;
    }

    @Override
    public void removeItemLabel(int index) {
        if (index >= 0 && this.itemLabelList.size() > index) {
            this.itemLabelList.remove(index);
            if (this.mouseLocation > 0) {
                --this.mouseLocation;
            }
            this.repaint();
        }
    }

    @Override
    public void removeItemLabel(ItemLabel itemLabel) {
        if (this.itemLabelList.remove((Object)itemLabel)) {
            if (this.mouseLocation > 0) {
                --this.mouseLocation;
            }
            this.repaint();
        }
    }

    private void lockTextField(boolean b) {
        if (b) {
            ((LimitedLengthDocument)this.getDocument()).setMaxLength(0);
            this.showInfoIcon = false;
        } else {
            ((LimitedLengthDocument)this.getDocument()).setMaxLength(80);
            this.showInfoIcon = true;
        }
    }

    protected void moveMouseLoaction() {
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.lockTextFieldAsPaint();
        Graphics2D g2d = (Graphics2D)g;
        int y = (int)((double)this.getHeight() / 2.0 - this.searchLabel.getPreferredSize().getHeight() / 2.0);
        this.paintItemLabel(g2d, y);
        this.paintSearchLabel(g2d, y);
        this.paintInfoLabel(g2d, y);
        this.paintDateRangeBox(g2d, y);
        this.paintDateRangePopupLabel(g2d, y);
        this.paintClearLabel(g2d, y);
    }

    private void lockTextFieldAsPaint() {
        if (this.doNotAllowInput()) {
            this.lockTextField(true);
        } else {
            this.lockTextField(false);
        }
    }

    protected boolean doNotAllowInput() {
        return this.mouseLocation < this.itemLabelList.size() || this.itemLabelList.size() >= this.maxItemSize;
    }

    private void paintDateRangeBox(Graphics2D g2d, int y) {
        if (this.dateRangeBox == null) {
            return;
        }
        this.cellRendererPane.paintComponent(g2d, (Component)((Object)this.dateRangeBox), (Container)((Object)this), this.getDateRangeBoxX(), y, this.W_DATEBOX, 30);
    }

    public void paint(Graphics g) {
        Border border = this.getBorder();
        if (border instanceof IBorderClip) {
            ((IBorderClip)((Object)border)).paintClip((Component)((Object)this), g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    public Dimension getPreferredSize() {
        Insets s = super.getInsets();
        Insets t = this.getInsets();
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.setSize(preferredSize.width - (t.left + t.right - s.left - s.right), preferredSize.height + 2);
        return preferredSize;
    }

    public int getIconPosition() {
        return this.searchIconPosition;
    }

    public void setIconPosition(int iconPosition) {
        this.searchIconPosition = iconPosition;
        this.invalidate();
        this.repaint();
    }

    public boolean isShowClearIcon() {
        return this.showClearIcon;
    }

    public void setShowClearIcon(boolean showClearIcon) {
        this.showClearIcon = showClearIcon;
        this.repaint();
    }

    public void clearFilters() {
        this.setText("");
        this.itemLabelList.clear();
        this.mouseLocation = 0;
        this.repaint();
    }

    private void invokeItemLabelMouseListener(MouseEvent e) {
        MouseListener[] lisenters;
        if (!this.itemLabelList.contains(this.mouseCom)) {
            return;
        }
        ItemLabel item = (ItemLabel)((Object)this.mouseCom);
        for (MouseListener l : lisenters = item.getMouseListeners(this.getXAtItemLabel(item, e.getPoint().x))) {
            if (e.getID() == 501) {
                l.mousePressed(e);
                continue;
            }
            if (e.getID() == 500) {
                l.mouseClicked(e);
                continue;
            }
            if (e.getID() != 502) continue;
            l.mouseReleased(e);
        }
    }

    private void invokeItemLabelMouseMotionListener(MouseEvent e) {
        MouseMotionListener[] lisenters;
        if (!this.itemLabelList.contains(this.mouseCom)) {
            return;
        }
        ItemLabel item = (ItemLabel)((Object)this.mouseCom);
        for (MouseMotionListener l : lisenters = item.getMouseMotionListeners(this.getXAtItemLabel(item, e.getPoint().x))) {
            if (e.getID() != 503) continue;
            l.mouseMoved(e);
        }
    }

    @Override
    public boolean isMouseOver() {
        return this.isFocused;
    }

    @Override
    public int getInputMaxWidth() {
        int maxInputWidth = this.getBounds().width;
        if (this.showSearchIcon) {
            maxInputWidth -= this.searchIconSize.width - iconGap * 2 - 2;
        }
        if (this.showClearIcon) {
            maxInputWidth -= this.searchIconSize.width - iconGap - 2;
        }
        if (this.dateRangeBox != null) {
            maxInputWidth -= this.W_DATEBOX - 2;
        }
        return maxInputWidth;
    }
}

