/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.eas.framework.report.util.CommRptResourceUtil;
import java.util.ArrayList;
import java.util.List;

public class CellMatrix {
    private CellMatrix() {
    }

    public static void dumpMatrix(Object[][] dd) {
        for (int i = 0; i < dd.length; ++i) {
            for (int j = 0; j < dd[i].length; ++j) {
                System.out.print(" " + dd[i][j]);
            }
            System.out.println();
        }
    }

    public static String getDumpMatrixString(Object[][] dd) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < dd.length; ++i) {
            for (int j = 0; j < dd[i].length; ++j) {
                sb.append(dd[i][j]).append("  ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static Object[][] listToMatrix(List list) {
        Object[][] objs = new Object[list.size()][1];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = new Object[1];
            objs[i][0] = list.get(i);
        }
        return objs;
    }

    public static Object[][] turnCatercorner(Object[][] dd) {
        if (dd == null || dd.length == 0) {
            return dd;
        }
        int rows = dd.length;
        int cols = dd[0].length;
        Object[][] dd2 = new Object[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                dd2[j][i] = dd[i][j];
            }
        }
        return dd2;
    }

    public static Object[][] turnClockwise(Object[][] dd) {
        if (dd == null || dd.length == 0) {
            return dd;
        }
        int rows = dd.length;
        int cols = dd[0].length;
        Object[][] dd2 = new Object[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                dd2[j][rows - i - 1] = dd[i][j];
            }
        }
        return dd2;
    }

    public static Object[][] turnAntiClockwise(Object[][] dd) {
        if (dd == null || dd.length == 0) {
            return dd;
        }
        int rows = dd.length;
        int cols = dd[0].length;
        Object[][] dd2 = new Object[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                dd2[cols - j - 1][i] = dd[i][j];
            }
        }
        return dd2;
    }

    public static Object[][] descartesProduct(Object[][] dd1, Object[][] dd2) {
        if (dd1 == null || dd1.length == 0) {
            return dd2;
        }
        if (dd2 == null || dd2.length == 0) {
            return dd1;
        }
        int row1 = dd1.length;
        int col1 = dd1[0].length;
        int row2 = dd2.length;
        int col2 = dd2[0].length;
        Object[][] objs = new Object[row1 * row2][col1 + col2];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = new Object[col1 + col2];
            for (int j = 0; j < col1 + col2; ++j) {
                objs[i][j] = j < col1 ? dd1[i / row2][j] : dd2[i % row2][j - col1];
            }
        }
        return objs;
    }

    public static Object[][] horizontalLevelProduct(Object[][] dd1, Object[][] dd2) {
        return CellMatrix.turnClockwise(CellMatrix.descartesProduct(dd1, CellMatrix.turnAntiClockwise(dd2)));
    }

    public static Object[][] join(Object[][] dd1, Object[][] dd2) {
        if (dd1 == null || dd1.length == 0) {
            return dd2;
        }
        if (dd2 == null || dd2.length == 0) {
            return dd1;
        }
        int row1 = dd1.length;
        int row2 = dd2.length;
        int row = Math.max(row1, row2);
        int col1 = dd1[0].length;
        int col2 = dd2[0].length;
        int col = col1 + col2;
        Object[][] re = new String[row][col];
        if (row1 > row2) {
            for (int i = 0; i < row1; ++i) {
                for (int j = 0; j < col1; ++j) {
                    re[i][j] = dd1[i][j];
                }
            }
            int n = row1 - row2;
            for (int i = 0; i < row2; ++i) {
                for (int j = 0; j < col2; ++j) {
                    re[i + n][j + col1] = dd2[i][j];
                }
            }
        } else {
            int j;
            int i;
            int n = row2 - row1;
            for (i = 0; i < row1; ++i) {
                for (j = 0; j < col1; ++j) {
                    re[i + n][j] = dd1[i][j];
                }
            }
            for (i = 0; i < row; ++i) {
                for (j = 0; j < col2; ++j) {
                    re[i][j + col1] = dd2[i][j];
                }
            }
        }
        return re;
    }

    public static List parseAutoMatchMergeRegion(Object[][] dd) {
        return CellMatrix.parseAutoMatchMergeRegion(dd, true, true, true);
    }

    public static List parseAutoMatchMergeRegion(Object[][] dd, boolean rowDir, boolean colDir, boolean withNullEq) {
        int j;
        int i;
        ArrayList<int[]> list = new ArrayList<int[]>();
        if (dd == null || dd.length == 0 || !rowDir && !colDir) {
            return list;
        }
        ArrayList<Object> keyList = new ArrayList<Object>();
        int rows = dd.length;
        int cols = dd[0].length;
        Object lastKey = null;
        Object curKey = null;
        int len = 0;
        if (rowDir) {
            for (i = 0; i < rows; ++i) {
                for (j = 0; j < cols; ++j) {
                    curKey = dd[i][j];
                    if (j == 0) {
                        lastKey = curKey;
                        len = 0;
                        continue;
                    }
                    if (j != cols - 1 && CellMatrix.equalsTo(curKey, lastKey, withNullEq)) {
                        ++len;
                        continue;
                    }
                    if (j == cols - 1 && CellMatrix.equalsTo(curKey, lastKey, withNullEq)) {
                        list.add(new int[]{j - len - 1, i, j, i});
                        keyList.add(lastKey);
                    } else if (len > 0) {
                        list.add(new int[]{j - len - 1, i, j - 1, i});
                        keyList.add(lastKey);
                    }
                    lastKey = curKey;
                    len = 0;
                }
            }
        }
        if (colDir) {
            for (i = 0; i < cols; ++i) {
                for (j = 0; j < rows; ++j) {
                    curKey = dd[j][i];
                    if (j == 0) {
                        lastKey = curKey;
                        len = 0;
                        continue;
                    }
                    if (j != rows - 1 && CellMatrix.equalsTo(curKey, lastKey, withNullEq)) {
                        ++len;
                        continue;
                    }
                    if (j == rows - 1 && CellMatrix.equalsTo(curKey, lastKey, withNullEq)) {
                        list.add(new int[]{i, j - len - 1, i, j});
                        keyList.add(lastKey);
                    } else if (len > 0) {
                        list.add(new int[]{i, j - len - 1, i, j - 1});
                        keyList.add(lastKey);
                    }
                    lastKey = curKey;
                    len = 0;
                }
            }
        }
        if (rowDir && colDir) {
            int[] last = null;
            int[] cur = null;
            block4: for (int i2 = 0; i2 < list.size() - 1; ++i2) {
                last = (int[])list.get(i2);
                lastKey = keyList.get(i2);
                for (int j2 = i2 + 1; j2 < list.size(); ++j2) {
                    boolean canBeMerge;
                    cur = (int[])list.get(j2);
                    curKey = keyList.get(j2);
                    if (!CellMatrix.equalsTo(curKey, lastKey, withNullEq)) continue;
                    boolean bl = canBeMerge = last[1] == cur[1] && last[3] == cur[3] && last[2] + 1 >= cur[0] || last[0] == cur[0] && last[2] == cur[2] && last[3] + 1 >= cur[1];
                    if (!canBeMerge) continue;
                    list.remove(j2);
                    list.remove(i2);
                    keyList.remove(j2);
                    keyList.remove(i2);
                    list.add(i2, new int[]{last[0], last[1], cur[2], cur[3]});
                    keyList.add(i2, curKey);
                    --i2;
                    continue block4;
                }
            }
        }
        return list;
    }

    public static String[][] convert(Object[][] dd, boolean force) {
        if (dd == null) {
            return null;
        }
        if (dd.length == 0) {
            return new String[0][];
        }
        int rows = dd.length;
        int cols = dd[0].length;
        String[][] dd2 = new String[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                dd2[i][j] = force ? (String)dd[i][j] : String.valueOf(dd[i][j]);
            }
        }
        return dd2;
    }

    public static boolean equalsTo(Object value1, Object value2, boolean withNullEq) {
        if (value2 == null) {
            return withNullEq ? value1 == null : false;
        }
        return value2.equals(value1);
    }

    public static boolean equals(Object value1, Object value2) {
        if (value1 == null || value2 == null) {
            return true;
        }
        return value1.equals(value2);
    }

    public static Object[][] insertColumns(Object[][] dd, int insertIndex, int count, Object defaultValue) {
        if (dd == null || dd.length == 0) {
            return dd;
        }
        int rows = dd.length;
        int cols = dd[0].length;
        int toColumnIndex = insertIndex + count;
        Object[][] dd2 = new Object[rows][cols + count];
        for (int i = 0; i < rows; ++i) {
            int n = cols + count;
            for (int j = 0; j < n; ++j) {
                dd2[i][j] = j <= insertIndex ? dd[i][j] : (j <= toColumnIndex ? defaultValue : dd[i][j - count]);
            }
        }
        return dd2;
    }

    public static Object[][] removeColumns(Object[][] dd, int[] ix) {
        if (dd == null || dd.length == 0) {
            return dd;
        }
        int rows = dd.length;
        int cols = dd[0].length;
        Object[][] dd2 = new Object[rows][cols - ix.length];
        int n = -1;
        boolean canBeRemove = false;
        for (int i = 0; i < cols; ++i) {
            canBeRemove = false;
            for (int k = 0; k < ix.length; ++k) {
                if (i != ix[k]) continue;
                canBeRemove = true;
                break;
            }
            if (canBeRemove) continue;
            ++n;
            for (int j = 0; j < rows; ++j) {
                dd2[j][n] = dd[j][i];
            }
        }
        return dd2;
    }

    public static Object[][] removeRows(Object[][] dd, int[] ix) {
        if (dd == null || dd.length == 0) {
            return dd;
        }
        int rows = dd.length;
        int cols = dd[0].length;
        Object[][] dd2 = new Object[rows - ix.length][cols];
        int n = -1;
        boolean canBeRemove = false;
        for (int i = 0; i < rows; ++i) {
            canBeRemove = false;
            for (int k = 0; k < ix.length; ++k) {
                if (i != ix[k]) continue;
                canBeRemove = true;
                break;
            }
            if (canBeRemove) continue;
            ++n;
            for (int j = 0; j < cols; ++j) {
                dd2[n][j] = dd[i][j];
            }
        }
        return dd2;
    }

    public static void main(String[] args) {
        Object[][] h1 = new String[][]{{CommRptResourceUtil.getRes("date"), CommRptResourceUtil.getRes("voucher_type_no"), CommRptResourceUtil.getRes("abstract"), CommRptResourceUtil.getRes("debit"), CommRptResourceUtil.getRes("debit"), CommRptResourceUtil.getRes("credit"), CommRptResourceUtil.getRes("credit"), CommRptResourceUtil.getRes("credit"), CommRptResourceUtil.getRes("credit") + "2", CommRptResourceUtil.getRes("credit")}, {CommRptResourceUtil.getRes("date"), CommRptResourceUtil.getRes("voucher_type_no"), CommRptResourceUtil.getRes("abstract"), CommRptResourceUtil.getRes("qty"), CommRptResourceUtil.getRes("money_amount"), CommRptResourceUtil.getRes("qty"), CommRptResourceUtil.getRes("money_amount"), CommRptResourceUtil.getRes("credit"), CommRptResourceUtil.getRes("credit"), CommRptResourceUtil.getRes("credit")}, {CommRptResourceUtil.getRes("date"), CommRptResourceUtil.getRes("voucher_type_no"), CommRptResourceUtil.getRes("abstract"), CommRptResourceUtil.getRes("qty"), CommRptResourceUtil.getRes("money_amount"), CommRptResourceUtil.getRes("qty"), CommRptResourceUtil.getRes("money_amount"), CommRptResourceUtil.getRes("credit"), CommRptResourceUtil.getRes("credit"), CommRptResourceUtil.getRes("credit")}, {CommRptResourceUtil.getRes("date"), CommRptResourceUtil.getRes("voucher_type_no"), CommRptResourceUtil.getRes("abstract"), CommRptResourceUtil.getRes("qty"), CommRptResourceUtil.getRes("money_amount"), CommRptResourceUtil.getRes("qty"), CommRptResourceUtil.getRes("money_amount"), CommRptResourceUtil.getRes("credit"), CommRptResourceUtil.getRes("credit"), CommRptResourceUtil.getRes("credit")}};
        Object[][] hh = CellMatrix.insertColumns(h1, 2, 3, "333");
        CellMatrix.dumpMatrix(hh);
        CellMatrix.dumpMatrix(CellMatrix.removeColumns(hh, new int[]{0, 2}));
    }
}

