/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBUtilx {
    public static Connection getConnection(Context ctx, int transactionLevel) throws SQLException {
        Connection con = EJBFactory.getConnection((Context)ctx);
        return con;
    }

    public static Connection getConnectionByDefault(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    public static Connection getConnection(Context ctx) throws SQLException {
        return DBUtilx.getConnection(ctx, 1);
    }

    private static void close(Connection con) throws SQLException {
        if (con != null) {
            con.close();
        }
    }

    private static void close(ResultSet rs, Statement stmt, Connection con) throws SQLException {
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (con != null) {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(String sql, SqlParams pp, Context ctx) throws SQLException {
        Connection con = DBUtilx.getConnection(ctx);
        try {
            boolean bl = DBUtil.execute(sql, pp, con);
            return bl;
        }
        finally {
            DBUtilx.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, SqlParams pp, Context ctx) throws SQLException {
        Connection con = DBUtilx.getConnection(ctx);
        try {
            int n = DBUtil.executeUpdate(sql, pp, con);
            return n;
        }
        finally {
            DBUtilx.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RptRowSet executeQuery(String sql, SqlParams pp, int from, int length, Context ctx) throws SQLException {
        Connection con = DBUtilx.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtil.executeQuery(sql, pp, from, length, con);
            return rptRowSet;
        }
        finally {
            DBUtilx.close(con);
        }
    }

    public static RptRowSet executeQuery(String sql, SqlParams pp, Context ctx) throws SQLException {
        return DBUtilx.executeQuery(sql, pp, 0, -1, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CreateTempTableResult executeSelectIntoForTempTable(String sql, SqlParams pp, Context ctx) throws Exception {
        Connection con = DBUtilx.getConnection(ctx);
        try {
            CreateTempTableResult createTempTableResult = DBUtil.executeSelectIntoForTempTable(ctx, sql, pp, con);
            return createTempTableResult;
        }
        finally {
            DBUtilx.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeSelectInto(String sql, SqlParams pp, Context ctx) throws SQLException {
        Connection con = DBUtilx.getConnection(ctx);
        try {
            int n = DBUtil.executeSelectInto(sql, pp, con);
            return n;
        }
        finally {
            DBUtilx.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRowSet executeQuery2(String sql, SqlParams pp, int from, int length, Context ctx) throws SQLException {
        JdbcRowSet jdbcRowSet;
        Connection con = DBUtilx.getConnection(ctx);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql);
            pp.putToStatement(ps);
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs, from, length, false);
            jdbcRowSet = rowset;
        }
        catch (Throwable throwable) {
            DBUtilx.close(rs, ps, con);
            throw throwable;
        }
        DBUtilx.close(rs, ps, con);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery2(String sql, SqlParams pp, Context ctx) throws SQLException {
        return DBUtilx.executeQuery2(sql, pp, 0, -1, ctx);
    }
}

