/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.util;

import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.Comparator;

public final class BizOrgUtility {
    public static OrgUnitInfo loadDefaultMainOrg(OrgUnitCollection bizOrgs) {
        if (bizOrgs == null) {
            return null;
        }
        int size = bizOrgs.size();
        OrgUnitInfo[] mainOrgs = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = bizOrgs.toArray();
            System.arraycopy(objects, 0, mainOrgs, 0, size);
        }
        String loginOrgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        for (int i = 0; i < mainOrgs.length; ++i) {
            if (!loginOrgId.equals(mainOrgs[i].getId().toString())) continue;
            return mainOrgs[i];
        }
        if ((mainOrgs = (OrgUnitInfo[])BizOrgUtility.sortDataByNumber((DataBaseInfo[])mainOrgs, true)) == null || mainOrgs.length == 0) {
            return null;
        }
        return mainOrgs[0];
    }

    static DataBaseInfo[] sortDataByNumber(DataBaseInfo[] datas, boolean isAsc) {
        if (datas == null || datas.length < 2) {
            return datas;
        }
        class DataCompare
        implements Comparator<DataBaseInfo> {
            private boolean isAsc = true;

            public DataCompare(boolean isAsc) {
                this.isAsc = isAsc;
            }

            @Override
            public int compare(DataBaseInfo o1, DataBaseInfo o2) {
                return this.isAsc ? o1.getNumber().compareTo(o2.getNumber()) : o2.getNumber().compareTo(o1.getNumber());
            }
        }
        Arrays.sort((Object[])datas, (Comparator)new DataCompare(isAsc));
        return datas;
    }

    private BizOrgUtility() {
    }
}

