/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.util;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FileUtils {
    private static Logger logger = Logger.getLogger(FileUtils.class);
    public static final String fileSeparator = ".";
    public static final String bmpType = "bmp";
    public static final String pngType = "png";
    public static final String jpgType = "jpg";
    public static final String bmpSuffix = ".bmp";
    public static final String pngSuffix = ".png";
    public static final String jpgSuffix = ".jpg";

    public static void initSaveDialog() throws Exception {
        KDFileChooser fileChooser = FileUtils.initPicKDFileChooser();
    }

    public static KDFileChooser initPicKDFileChooser() throws Exception {
        String title = EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"90_FileUtils");
        String FileName = FileUtils.bulidFileName(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"10_CloudShareDialog"), pngType);
        String[] suffixs = new String[]{bmpSuffix, jpgSuffix, pngSuffix};
        KDFileChooser fileChooser = FileUtils.getKDFileChooser(title, "", FileName, suffixs);
        return fileChooser;
    }

    public static String bulidFileName(String prefix, String fileType) {
        String dateTime = "";
        dateTime = FileUtils.getCurrentTimeStamp();
        StringBuffer name = new StringBuffer();
        name.append(prefix);
        name.append(dateTime);
        name.append(pngSuffix);
        return name.toString();
    }

    public static File initFile(KDFileChooser fileChooser, String suffix) throws Exception {
        if (fileChooser != null) {
            int result = fileChooser.showSaveDialog(null);
            File file = fileChooser.getSelectedFile();
            if (result != 0) {
                return null;
            }
            if (!file.getAbsolutePath().endsWith(suffix)) {
                file = new File(file.getAbsolutePath() + suffix);
            }
            if (file.exists()) {
                int select = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"56_ExportExcelConfigUI"));
                if (select == 2) {
                    return null;
                }
                if (select == 0 && !file.renameTo(file)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"57_ExportExcelConfigUI"));
                    return null;
                }
            }
            return file;
        }
        return null;
    }

    public static KDFileChooser getKDFileChooser(String title, String path, String fileName, String[] suffixs) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        File tempFile = null;
        if (StringUtils.isEmpty((String)path)) {
            int index = fileName.indexOf(fileSeparator);
            String prefix = fileName.substring(0, index);
            String suffix = fileName.substring(index);
            tempFile = File.createTempFile(prefix, suffix);
        } else {
            tempFile = new File(path, fileName);
        }
        fileChooser.setSelectedFile(tempFile);
        if (suffixs != null && suffixs.length > 0) {
            for (int i = 0; i < suffixs.length; ++i) {
                fileChooser.addChoosableFileFilter(FileUtils.bulidFilter(suffixs[i]));
            }
        }
        return fileChooser;
    }

    public static FileFilter bulidFilter(final String suffix) throws Exception {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null) {
                    return extension.equalsIgnoreCase(suffix);
                }
                return false;
            }

            private String getExtension(File f) {
                String ext = null;
                String fileName = f.getName();
                int i = fileName.lastIndexOf(FileUtils.fileSeparator);
                if (i > 0 && i < fileName.length() - 1) {
                    ext = fileName.substring(i + 1).toLowerCase();
                }
                return ext;
            }

            @Override
            public String getDescription() {
                return suffix + "(*" + suffix + ")";
            }
        };
        return fileFilter;
    }

    public static File getSystemTempFile(String tempFileName, String suffix) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(tempFileName, suffix);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return tempFile;
    }

    public static String getCurrentTimeStamp() {
        SimpleDateFormat tempDate = new SimpleDateFormat("yyyyMMddHHmmss");
        return tempDate.format(new Date());
    }
}

