/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.maintain.sshTunnel.util;

import com.kingdee.bos.maintain.sshTunnel.ISshTunnelUser;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelState;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelUserFactory;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelUserInfo;
import com.kingdee.bos.maintain.sshTunnel.util.FileUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.util.httpDownload.HttpDownloadUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BatUtil {
    private static final Logger logger = CoreUIObject.getLogger(BatUtil.class);
    private static String startSshPath = System.getProperty("EAS_HOME") + "/client/easssh/startupssh.cmd";
    private static String stopSshPath = System.getProperty("EAS_HOME") + "/client/easssh/stopssh.bat";

    public static boolean startUpSsh(UserInfo userInfo) {
        try {
            String userID = userInfo.getId().toString();
            ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
            FilterInfo filterinfo = new FilterInfo();
            filterinfo.appendFilterItem("user", (Object)userID);
            EntityViewInfo evinfo = new EntityViewInfo();
            evinfo.setFilter(filterinfo);
            CoreBaseCollection sshUsers = instance.getCollection(evinfo);
            int size = sshUsers.size();
            if (size > 0) {
                SshTunnelUserInfo sshInfo = (SshTunnelUserInfo)sshUsers.get(0);
                if (sshInfo.getState().equals((Object)SshTunnelState.AUTHORIZED)) {
                    String easHome = System.getProperty("EAS_HOME");
                    String sshPath = easHome + "/client/easssh";
                    String fileName = easHome + "/client/download/easssh.zip";
                    String pathName = easHome + "/client/";
                    File easSshFile = new File(sshPath);
                    if (!easSshFile.exists()) {
                        HttpDownloadUtil.downloadFileFromServer((String)"download/easssh.zip");
                        FileUtil.delAndDecompress(fileName, pathName);
                    }
                    instance = SshTunnelUserFactory.getRemoteInstance();
                    String config = instance.getSSHConfig();
                    String[] ipPort = config.split("!");
                    ArrayList<String> ipPortlist = FileUtil.getEassshEnv(easHome + "/client/easssh/kdeasssh_env.bat");
                    int length = ipPort.length;
                    int isize = ipPortlist.size();
                    if (!(length != 2 || isize != 2 || ipPortlist.get(0).equals(ipPort[0]) && ipPortlist.get(1).equals(ipPort[1]))) {
                        HttpDownloadUtil.downloadFileFromServer((String)"download/easssh/kdeasssh_env.bat");
                    }
                    if (!BatUtil.hasStartedSSH()) {
                        Process proc = Runtime.getRuntime().exec("cmd.exe /C start " + startSshPath);
                        int wfnum = proc.waitFor();
                        if (wfnum != 0) {
                            logger.error((Object)("Return errorcode :" + wfnum));
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("startUpSsh Exception" + e.toString()));
            return false;
        }
    }

    public static boolean stopSsh(UserInfo userInfo) {
        try {
            File stop = new File(stopSshPath);
            if (stop.exists() && BatUtil.hasStartedSSH()) {
                Process child = Runtime.getRuntime().exec("cmd.exe /C start " + stopSshPath);
                int wfnum = child.waitFor();
                if (wfnum != 0) {
                    logger.error((Object)("Return errorcode :" + wfnum));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("stopSsh Exception" + e.toString()));
            return false;
        }
    }

    public static boolean hasStartedSSH() {
        try {
            Process pro = Runtime.getRuntime().exec("cmd.exe /C tasklist | find \"kpower\"");
            InputStream in = pro.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String result = null;
            String line = null;
            while ((line = br.readLine()) != null) {
                result = result + line.toString();
            }
            br.close();
            in.close();
            return result != null && !result.equalsIgnoreCase("null");
        }
        catch (Exception e) {
            logger.error((Object)("hasStartedSSH Exception" + e.toString()));
            return false;
        }
    }

    public static boolean hasBootReg() {
        try {
            String cmd = "reg query HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Run /v startupssh";
            Process pro = Runtime.getRuntime().exec(cmd);
            InputStream in = pro.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String result = null;
            String line = null;
            while ((line = br.readLine()) != null) {
                result = result + line.toString();
            }
            br.close();
            in.close();
            return result != null && !result.equalsIgnoreCase("null") && result.contains("startupssh");
        }
        catch (Exception e) {
            logger.error((Object)("hasBootReg Exception" + e));
            return false;
        }
    }

    public static boolean addBootReg(String path) {
        try {
            String cmd = "reg add HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Run /v startupssh /t REG_SZ /d " + path + " /f";
            Process pro = Runtime.getRuntime().exec(cmd);
            int wfnum = pro.waitFor();
            if (wfnum != 0) {
                logger.error((Object)("addBootReg errorcode :" + wfnum));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("hasBootReg Exception" + e.toString()));
            return false;
        }
    }

    public static boolean deleteBootReg() {
        try {
            String cmd = "reg delete HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Run /v startupssh /f";
            Process pro = Runtime.getRuntime().exec(cmd);
            int wfnum = pro.waitFor();
            if (wfnum != 0) {
                logger.error((Object)("deleteBootReg errorcode :" + wfnum));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("deleteBootReg Exception" + e.toString()));
            return false;
        }
    }
}

