/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.mbos.common.util;

import com.kingdee.mbos.common.util.CMeta;
import com.kingdee.mbos.common.util.FileInfo;
import com.kingdee.mbos.common.util.FileStore;
import com.kingdee.mbos.common.util.ICMStorage;
import com.kingdee.mbos.common.util.PackageNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class CMStorage
implements ICMStorage {
    private static Logger logger = Logger.getLogger(CMStorage.class);

    @Override
    public void uploadFile(String absolutePath, InputStream in) {
        try {
            this.writeFile(absolutePath, in);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String fileName, InputStream in) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(fileName);
            IOUtils.copy((InputStream)in, (OutputStream)output);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String fileName, String data, String encoding) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(fileName);
            IOUtils.write((String)data, (OutputStream)output, (String)encoding);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void addFile(String absolutePath, String content) {
        try {
            this.writeFile(absolutePath, content, "UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deleteFile(String url) {
        File file = null;
        if (url != null) {
            file = new File(url);
        }
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void addPackage(String eid, String path, String name, String caption, String mime) {
        PackageNode packageNode = new PackageNode(path, name, caption, mime);
        CMeta meta = (CMeta)packageNode.getNodeMeta();
        FileInfo fileInfo = new FileStore(eid).createPackage(packageNode.getPath(), meta);
    }

    @Override
    public void deletePackage(String eid, String path, String name, ArrayList<FileInfo> fileInfos) {
        PackageNode packageNode = new PackageNode(path, name, null, null);
        String fullName = packageNode.getFullPath();
        for (FileInfo fileInfo : fileInfos) {
            new FileStore(fileInfo.storeType).deleteFileCascade(fileInfo);
        }
        new FileStore(eid).deletePackageCascade(fullName);
    }
}

