/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.mbos.light.deploy.handle;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.base.weibo.util.HttpClientTool;
import com.kingdee.mbos.light.deploy.handle.SSLClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class MBosUtil {
    private static final String CHECKMBOS_OPERATION = "checkmbos";
    private static final String DEPLOYMBOS_OPERATION = "deploymbos";
    private static final String CHECKMBOS_OPERATION_W = "checkworkflow";
    private static final String DEPLOYMBOS_OPERATION_W = "deployworkflow";
    private static final String REGISTER_URL = "https://mbos.kdeascloud.com/mbos/auth/registerGroup";
    private static final String CHECK_URL = "https://mbos.kdeascloud.com/mbos/auth/pingEasUrl";

    public static Map<String, String> buildError(String operation, String msg) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("operation", operation);
        result.put("success", "false");
        result.put("msg", msg);
        return result;
    }

    public static Map<String, String> buildSuccess(String operation) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("operation", operation);
        result.put("success", "true");
        return result;
    }

    public static Map deployMbos(Map params) {
        if (!params.containsKey("eid") || !params.containsKey("easurl")) {
            return MBosUtil.buildError(DEPLOYMBOS_OPERATION, "\u4f01\u4e1a\u53f7\u6216EAS\u5916\u7f51\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String result = "";
        JSONObject jo = null;
        StringBuilder resultMsg = new StringBuilder();
        try {
            result = MBosUtil.httpsPost(REGISTER_URL, null, params);
            jo = (JSONObject)JSONObject.parse((String)result);
            if ("false".equals(jo.get((Object)"success"))) {
                resultMsg.append("\u534e\u4e3a\u4e91\u6ce8\u518c\u5931\u8d25\uff1a" + jo.getString("msg"));
            }
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            resultMsg.append("\u534e\u4e3a\u4e91\u6ce8\u518c\u5931\u8d25\uff1a");
            if (result != null && result.indexOf("Access denied") > -1) {
                resultMsg.append("\u8bbf\u95ee\u88ab\u62d2\u7edd");
            }
            if (errorMessage != null && errorMessage.indexOf("connect timed out") > -1) {
                resultMsg.append("\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6");
            }
            resultMsg.append(result);
        }
        if (resultMsg.toString().equals("")) {
            return MBosUtil.buildSuccess(DEPLOYMBOS_OPERATION);
        }
        return MBosUtil.buildError(DEPLOYMBOS_OPERATION, resultMsg.toString());
    }

    public static Map checkMbos(Map params) {
        String result = HttpClientTool.httpPost((HttpClient)MBosUtil.getClient(), (String)CHECK_URL, (Map)params);
        System.out.println("-----------checkMbos--------:" + result);
        JSONObject jo = null;
        Object jo1 = null;
        try {
            jo = (JSONObject)JSONObject.parse((String)result);
            if ("false".equals(jo.get((Object)"success"))) {
                return MBosUtil.buildError(CHECKMBOS_OPERATION, jo.getString("msg"));
            }
        }
        catch (Exception e) {
            if (result != null && result.indexOf("Access denied") > -1) {
                return MBosUtil.buildError(CHECKMBOS_OPERATION, "\u8bbf\u95ee\u88ab\u62d2\u7edd");
            }
            if (result != null && result.indexOf("connect timed out") > -1) {
                return MBosUtil.buildError(CHECKMBOS_OPERATION, "\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6");
            }
            return MBosUtil.buildError(CHECKMBOS_OPERATION, result);
        }
        return MBosUtil.buildSuccess(CHECKMBOS_OPERATION);
    }

    public static Map deployWorkflow(Map params) {
        if (!params.containsKey("eid") || !params.containsKey("easurl")) {
            return MBosUtil.buildError(DEPLOYMBOS_OPERATION_W, "\u4f01\u4e1a\u53f7\u6216EAS\u5916\u7f51\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return MBosUtil.buildSuccess(DEPLOYMBOS_OPERATION_W);
    }

    public static Map checkWorkflow(Map params) {
        return MBosUtil.buildSuccess(CHECKMBOS_OPERATION_W);
    }

    private static HttpClient getClient() {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(5000);
        return httpClient;
    }

    private static DefaultHttpClient createSingleHttpClient() throws Exception {
        SSLClient client = new SSLClient();
        HostConfiguration config = new HostConfiguration();
        client.getParams().setParameter("http.connection.timeout", (Object)5000);
        client.getParams().setParameter("http.socket.timeout", (Object)5000);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(String surl, Map map) {
        DefaultHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = "";
        try {
            HttpEntity resEntity;
            CloseableHttpResponse response;
            httpClient = MBosUtil.createSingleHttpClient();
            httpPost = new HttpPost(surl);
            httpPost.addHeader("Connection", "close");
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry elem : map.entrySet()) {
                list.add(new BasicNameValuePair((String)elem.getKey(), (String)elem.getValue()));
            }
            if (list.size() > 0) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, "utf-8");
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            }
        }
        catch (Exception t) {
            result = t.getMessage();
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsPost(String url, Map<String, String> reqHead, Map<String, String> paramMap) throws ParseException, IOException, Exception {
        DefaultHttpClient httpClient = null;
        HttpPost httpPost = null;
        try {
            HttpEntity httpEntity;
            CloseableHttpResponse closeableHttpResponse;
            httpClient = MBosUtil.createSingleHttpClient();
            httpPost = new HttpPost(url);
            httpPost.addHeader("Connection", "close");
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            if (reqHead != null) {
                Set<String> keySet = reqHead.keySet();
                for (String string : keySet) {
                    httpPost.addHeader(string, reqHead.get(string));
                }
            }
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            if (paramMap != null) {
                for (Map.Entry entry : paramMap.entrySet()) {
                    nameValuePairs.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
            }
            if ((closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost)) != null && (httpEntity = closeableHttpResponse.getEntity()) != null) {
                String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
                return string;
            }
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return null;
    }
}

