/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.f.advanced;

import com.kingdee.cbos.process.vm.internal.Feature;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.i.node.Sync;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.model.Node;
import java.util.Set;

public class Synchronization
extends Feature {
    public static final String NAME = "sync";
    private Node.Stage point;

    public Synchronization(Node.Stage point) {
        this.point = point;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getCategories() {
        return new String[]{"merge"};
    }

    @Override
    public int getIndex() {
        return 100;
    }

    @Override
    public void preHandle(NodeImpl node) {
    }

    @Override
    public void postHandle(NodeImpl node) {
        if (!node.getParent().isSolidified()) {
            node.getFlow().addLazyFeature(this, node);
            return;
        }
        node.getParent().generateGraph();
        Set<String> priors = node.getParent().getGraph().findPriors(node.getId());
        for (NodeImpl sibling : node.getParent().getChildren()) {
            if (sibling == node) continue;
            sibling.insert(NIS.NOTIFY_SIBLING_BEFORE_END);
        }
        node.insert(NIS.DISPATCH2NOT_CLOSED4SYNC);
        switch (this.point) {
            case BEFORE_READY: {
                node.insert(new Sync(NIS.SYNC_BEFORE_READY.getLabel(), priors));
                break;
            }
            case BEFORE_CHILDREN_STARTED: {
                node.insert(new Sync(NIS.SYNC_BEFORE_CHILDREN_STARTED.getLabel(), priors));
                break;
            }
            case BEFORE_TRANSFERRING: {
                node.insert(new Sync(NIS.SYNC_BEFORE_TRANSFERRING.getLabel(), priors));
                break;
            }
            case BEFORE_CLOSED: {
                node.insert(new Sync(NIS.SYNC_BEFORE_COMPLETED.getLabel(), priors));
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.point.toString());
            }
        }
    }
}

