/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.node;

import com.kingdee.cbos.process.vm.internal.i.node.AbstractInstruction;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.r.DataAreaImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.plugin.Synchronizer;
import com.kingdee.cbos.process.vm.runtime.Execution;
import java.util.LinkedList;
import java.util.List;

public final class Dispatch2NotClosed
extends AbstractInstruction {
    private static final String EXECUTED_PRIORS = "EXECUTED_PRIORS";
    private boolean forJoin;

    public Dispatch2NotClosed(int index, boolean forJoin) {
        super(index);
        this.forJoin = forJoin;
    }

    @Override
    public int invoke(ExecutionImpl<NodeImpl> e) throws Exception {
        NodeImpl node = (NodeImpl)e.getDefine();
        DataAreaImpl dataArea = e.getDataArea();
        for (ExecutionImpl<?> sibling : ((ExecutionImpl)e.getParent()).getChildren()) {
            if (!node.equals(sibling.getDefine()) || sibling.isClosed() || dataArea != sibling.getDataArea() || sibling == e || sibling.current() == this || "true".equals(sibling.getProperty("$appended"))) continue;
            this.signalNotClosed(e, sibling);
            this.setPrior4Join(e, sibling);
            e.end();
            return 0;
        }
        this.setPrior4Join(e);
        return 1;
    }

    private void setPrior4Join(ExecutionImpl<NodeImpl> e) {
        if (this.forJoin) {
            String id;
            List<String> executed = Dispatch2NotClosed.getExecutedPriorTransitions(e);
            if (executed == null) {
                executed = new LinkedList<String>();
            }
            if ((id = e.getEntryTransitionId()) != null) {
                executed.add(id);
            }
            e.setProperty(EXECUTED_PRIORS, executed);
        }
    }

    private void setPrior4Join(ExecutionImpl<NodeImpl> e, ExecutionImpl<?> sibling) {
        if (this.forJoin) {
            List<String> executed = Dispatch2NotClosed.getExecutedPriorTransitions(sibling);
            String id = e.getEntryTransitionId();
            if (id != null) {
                executed.add(id);
            }
        }
    }

    private void signalNotClosed(ExecutionImpl<NodeImpl> e, ExecutionImpl<?> sibling) throws Exception {
        sibling.setPrior(e.getPriorExecutionIds(), e.getEntryTransitionId());
        Synchronizer sync = ((NodeImpl)e.getDefine()).getFlow().getSynchronizer();
        if (sync != null) {
            sync.begin((Execution<? extends Node>)sibling, true);
        }
        e.getContext().push(sibling);
    }

    static List<String> getExecutedPriorTransitions(ExecutionImpl<?> e) {
        return (List)e.getProperty(EXECUTED_PRIORS);
    }

    static void setExecutedPriorTransitions(ExecutionImpl<?> e, List<String> executed) {
        e.setProperty(EXECUTED_PRIORS, executed);
    }

    public String toString() {
        return "dispatch-2-not-closed";
    }
}

