/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.m;

import com.kingdee.cbos.process.vm.internal.Consts;
import com.kingdee.cbos.process.vm.internal.i.Instruction;
import com.kingdee.cbos.process.vm.internal.i.wrapper.ListenerWrapper;
import com.kingdee.cbos.process.vm.internal.i.wrapper.Wrapper;
import com.kingdee.cbos.process.vm.internal.m.AbstractElement;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.Priority;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.model.DataType;
import com.kingdee.cbos.process.vm.model.VariableScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;

public abstract class VariableScopeImpl<E extends VariableScopeImpl<E>>
extends AbstractElement
implements VariableScope {
    private List<Instruction<E>> instructions = new ArrayList<Instruction<E>>();
    private Map<String, VariableImpl<E>> variables = new HashMap<String, VariableImpl<E>>();
    private List<ListenerWrapper<E>> listeners = new ArrayList<ListenerWrapper<E>>();
    private Map<String, VariableImpl<? extends VariableScope>> a_variables = new HashMap<String, VariableImpl<? extends VariableScope>>();
    private Priority priority;
    private Map<String, Object> attributes;
    private AtomicBoolean lock = new AtomicBoolean(false);

    protected VariableScopeImpl(String id, String title, Priority priority) {
        super(id, title);
        this.priority = priority;
    }

    public Priority getPriority() {
        return this.priority;
    }

    protected VariableScopeImpl(FlowImpl flow, String id, String title, Priority priority) {
        super(flow, id, title);
        this.priority = priority;
    }

    protected final void addListener(ListenerWrapper<E> listener) {
        this.addWrapper(listener);
        this.listeners.add(listener);
    }

    protected final void addWrapper(Wrapper<E, ?> wrapper) {
        this.insert(wrapper);
    }

    public final VariableImpl<E> addVariable(String id, String title, String name, DataType type, Object initValue, boolean singleton) {
        if (this.variables.containsKey(name)) {
            throw new RuntimeException("\u540d\u79f0\u4e3a(" + name + ")\u7684\u6d41\u7a0b\u53d8\u91cf\u5df2\u5b58\u5728\uff01");
        }
        if (title == null || title.length() == 0) {
            title = name;
        }
        VariableImpl<VariableScopeImpl> var = new VariableImpl<VariableScopeImpl>(this.getFlow(), id, title, name, type, initValue, singleton, this);
        this.variables.put(name, var);
        return var;
    }

    public final VariableImpl<E> getVariable(String name) {
        return this.variables.get(name);
    }

    public boolean variablesWereSolidified() {
        return !(this.variables instanceof HashMap);
    }

    public final Map<String, VariableImpl<E>> getVariables() {
        return this.variables;
    }

    protected List<ListenerWrapper<E>> getListeners() {
        return this.listeners;
    }

    public final VariableImpl<? extends VariableScope> findVariable(String name) {
        return this.a_variables.get(name);
    }

    public final VariableImpl<? extends VariableScope> retrieveVariable(String name) {
        VariableImpl<? extends VariableScope> v = this.a_variables.get(name);
        if (v != null) {
            return v;
        }
        throw new RuntimeException("\u6d41\u7a0b\u53d8\u91cf(" + name + ")\u5728(" + this + ")\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u89c1\uff01");
    }

    public void insert(Instruction<E> i) {
        if (this.getFlow().isReadOnly()) {
            throw new RuntimeException("\u7981\u6b62\u4fee\u6539(" + this + ")\u7684\u5fae\u7a0b\u5e8f\u3002");
        }
        int p = 0;
        for (int j = this.instructions.size() - 1; j >= 0; --j) {
            int index = this.instructions.get(j).getLabel();
            if (index == i.getLabel()) {
                this.instructions.set(j, i);
                return;
            }
            if (index >= i.getLabel()) continue;
            p = j + 1;
            break;
        }
        this.instructions.add(p, i);
    }

    public final void remove(Instruction<E> i) {
        for (int j = this.instructions.size() - 1; j >= 0; --j) {
            int index = this.instructions.get(j).getLabel();
            if (index != i.getLabel()) continue;
            this.instructions.remove(j);
            break;
        }
    }

    public final boolean contains(Instruction<E> i) {
        return this.instructions.contains(i);
    }

    void solidifyVariables() {
        this.a_variables.putAll(this.getOtherAvailableVariables());
        this.a_variables.putAll(this.variables);
        this.a_variables = Collections.unmodifiableMap(this.a_variables);
        if (this.variables.size() == 0) {
            this.variables = Consts.EMPTY_MAP;
        } else {
            for (VariableImpl<E> v : this.variables.values()) {
                v.solidifyVariables();
                v.solidifyListeners();
            }
            this.variables = Collections.unmodifiableMap(this.variables);
        }
    }

    void solidifyListeners() {
        this.listeners = this.listeners.size() == 0 ? Consts.EMPTY_LIST : Collections.unmodifiableList(this.listeners);
    }

    abstract Map<String, VariableImpl<? extends VariableScope>> getOtherAvailableVariables();

    public Map<String, VariableImpl<? extends VariableScope>> getAvailableVariables() {
        return this.a_variables;
    }

    public final int size() {
        return this.instructions.size();
    }

    public final Instruction<E> getInstruction(int index) {
        return this.instructions.get(index);
    }

    public final int seekInstruction(int label) {
        int j = this.size();
        for (int i = 0; i < j; ++i) {
            Instruction<E> x = this.getInstruction(i);
            if (x.getLabel() < label) continue;
            return i;
        }
        return -1;
    }

    void dumpMicroProgram(StringBuilder sb) {
        for (Instruction<E> i : this.instructions) {
            sb.append(i).append("[").append(i.getLabel()).append("]; ");
        }
    }

    void updateCRC(CRC32 crc) {
        for (Instruction<E> i : this.instructions) {
            String s = i.toString();
            for (int j = 0; j < s.length(); ++j) {
                crc.update(s.charAt(j));
            }
        }
    }

    public int getInstructionCount() {
        return this.instructions.size();
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.lock();
        try {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(name, value);
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        while (!this.lock.compareAndSet(false, true)) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void unlock() {
        this.lock.set(false);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        this.lock();
        try {
            Object object = this.attributes.get(name);
            return object;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.attributes != null) {
            this.lock();
            try {
                attributes.putAll(this.attributes);
            }
            finally {
                this.unlock();
            }
        }
        return attributes;
    }
}

