/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.r;

import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import com.kingdee.cbos.process.vm.internal.r.profie.ProfileImpl;

public final class ControllerImpl {
    private ControllerImpl() {
    }

    public static void execute(FlowContextImpl ctx) throws Exception {
        ctx.setError(null);
        ProfileImpl profile = ProfileImpl.getProfile(ctx);
        try {
            ControllerImpl.execute(ctx, profile);
            ctx.setStopped(true);
        }
        finally {
            ctx.setStopped(false);
            profile.end();
        }
        ControllerImpl.checkError(ctx);
    }

    private static void checkError(FlowContextImpl ctx) throws Exception {
        if (ctx.getError() != null) {
            Exception error = ctx.getError();
            ctx.setError(null);
            throw error;
        }
    }

    private static void execute(FlowContextImpl ctx, ProfileImpl profile) throws Exception {
        ExecutionImpl<?> e = ctx.pop();
        while (e != null) {
            boolean interupted = ControllerImpl.execute(ctx, profile, e);
            if (interupted) {
                ctx.setStopped(false);
                break;
            }
            e = ctx.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean execute(FlowContextImpl ctx, ProfileImpl profile, ExecutionImpl<?> e) throws Exception {
        while (e.getIp() >= 0) {
            profile.begin(e);
            boolean success = false;
            try {
                boolean isContinue = e.execute();
                success = true;
                if (isContinue) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                if (!profile.end(e, success)) continue;
                return true;
            }
        }
        return false;
    }
}

