/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.graph;

import com.kingdee.cbos.process.vm.utils.graph.Activity;
import com.kingdee.cbos.process.vm.utils.graph.Diagram;
import com.kingdee.cbos.process.vm.utils.graph.Node;
import com.kingdee.cbos.process.vm.utils.graph.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

class Block
implements Node {
    private Type type;
    private String id;
    private Activity act;
    private LinkedList<Block> children;
    private Block parent;
    private int x;
    private int y;
    private Diagram graph;
    private int width;
    private int height;
    private int top;
    private int left;
    private List<Block> nexts;
    private List<Block> priors;

    public Block(Diagram graph, Block parent) {
        this.id = UUID.randomUUID().toString();
        this.type = Type.Join;
        this.graph = graph;
        this.parent = parent;
    }

    public Block(Diagram graph, Activity act) {
        this.id = act.getId();
        this.type = Type.Activity;
        this.act = act;
        this.graph = graph;
    }

    public Block(Diagram graph, String id) {
        this.id = id;
        this.type = Type.Group;
        this.graph = graph;
    }

    public Activity getActivity() {
        return this.act;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public LinkedList<Block> getChildren() {
        return this.children;
    }

    public Block getParent() {
        return this.parent;
    }

    public Diagram getGraph() {
        return this.graph;
    }

    public void addChild(Block child) {
        child.parent = this;
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(child);
    }

    public void addNext(Block next) {
        if (this.nexts == null) {
            this.nexts = new LinkedList<Block>();
        }
        this.nexts.add(next);
    }

    public void addPrior(Block prior) {
        if (this.parent != null && this.parent.parent != null && this.parent.parent.getId().equals(prior.getId())) {
            return;
        }
        if (this.priors == null) {
            this.priors = new LinkedList<Block>();
        }
        this.priors.add(prior);
    }

    void removePrior(Block prior) {
        this.priors.remove(prior);
        if (this.priors.size() == 0) {
            this.priors = null;
        }
    }

    void removeNext(Block next) {
        this.nexts.remove(next);
        if (this.nexts.size() == 0) {
            this.nexts = null;
        }
    }

    public List<Block> getPriors() {
        return this.priors;
    }

    public List<Block> getNexts() {
        return this.nexts;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    void sortChildren() {
        if (this.children == null) {
            return;
        }
        this.calcPriorAndNext();
        this.sort();
    }

    private void sort() {
        LinkedList<Block> sortedActivities = new LinkedList<Block>();
        for (Block child : this.children) {
            if (child.getNexts() != null) continue;
            this.scan(sortedActivities, child);
        }
        this.children = sortedActivities;
    }

    private void scan(LinkedList<Block> sortedActivities, Block block) {
        sortedActivities.addFirst(block);
        List<Block> priors = block.priors;
        if (priors != null) {
            for (Block prior : priors) {
                this.scan(sortedActivities, prior);
            }
        }
    }

    private void calcPriorAndNext() {
        for (Block child : this.children) {
            String[] priorActIds;
            Activity act = child.getActivity();
            if (act == null || (priorActIds = act.getPriorActIds()) == null) continue;
            for (String actId : priorActIds) {
                Block prior = this.graph.get(actId);
                prior.addNext(child);
                child.addPrior(prior);
            }
        }
    }

    public String toString() {
        return this.act == null ? this.id : this.act.getTitle();
    }
}

