/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.group;

import com.kingdee.cbos.process.vm.utils.Ref;
import com.kingdee.cbos.process.vm.utils.group.MessageQueue;
import com.kingdee.cbos.process.vm.utils.group.MessageReceived;
import com.kingdee.cbos.process.vm.utils.group.MessageSending;
import com.kingdee.cbos.process.vm.utils.group.MessageService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.UUID;

public final class MessageServer {
    public static final String SEPERATOR = ":";
    public static final String CHARSET = "UTF-8";
    public static final String MULTICAST_GROUP_IP = "239.75.9.28";
    public static final int MULTICAST_PORT = 38928;
    public static final int MAX_LENGTH = 512;
    private static InetAddress group;
    private static MulticastSocket receiver;
    public static final Ref<String> ID;
    private static Thread msgReceiver;
    private static boolean inited;
    private static HashMap<String, MessageService> services;
    public static final Ref<MessageService> ECHO;

    public static String getServerId() {
        return ID.get();
    }

    public static boolean inited() {
        return inited;
    }

    public static synchronized void init() {
        if (inited) {
            return;
        }
        try {
            group = InetAddress.getByAddress(new byte[]{-17, 75, 9, 28});
            receiver = new MulticastSocket(38928);
            try {
                receiver.joinGroup(group);
            }
            catch (Throwable t) {
                try {
                    InetAddress addr = InetAddress.getLocalHost();
                    receiver.setInterface(addr);
                    receiver.joinGroup(group);
                }
                catch (Throwable t1) {
                    InetAddress addr = InetAddress.getByName("localhost");
                    receiver.setInterface(addr);
                    receiver.joinGroup(group);
                }
            }
            msgReceiver = new Thread(new MessageReceiver());
            msgReceiver.setName("MSG_RECEIVER");
            msgReceiver.setDaemon(true);
            msgReceiver.start();
            inited = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void send(String command, String message) {
        String msgId = UUID.randomUUID().toString();
        byte[] msg = MessageServer.constructMessage(command, message, msgId);
        DatagramPacket p = new DatagramPacket(msg, msg.length, group, 38928);
        MessageQueue.SENDER.get().enqueue(new MessageSending(p));
    }

    private static byte[] constructMessage(String command, String message, String msgId) {
        byte[] msg;
        try {
            msg = (MessageServer.getServerId() + SEPERATOR + msgId + SEPERATOR + command + SEPERATOR + message).getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (msg.length > 512) {
            throw new RuntimeException("\u6d88\u606f\u592a\u957f\uff0c\u8d85\u8fc7\u4e86512\u5b57\u8282\uff01");
        }
        return msg;
    }

    public static synchronized void register(String command, MessageService svc) {
        if (services.containsKey(command)) {
            throw new RuntimeException("\u547d\u4ee4{" + svc + "}\u7684\u5904\u7406\u670d\u52a1\u5df2\u6ce8\u518c\uff01");
        }
        services.put(command, svc);
    }

    public static synchronized MessageService getService(String command) {
        return services.get(command);
    }

    private static DatagramPacket receive() throws IOException {
        byte[] buf = new byte[512];
        DatagramPacket p = new DatagramPacket(buf, buf.length);
        receiver.receive(p);
        return p;
    }

    static {
        ID = new Ref<String>(UUID.randomUUID().toString());
        inited = false;
        services = new HashMap();
        ECHO = new Ref<1>(new MessageService(){

            @Override
            public void handle(SocketAddress host, String serverId, String msgId, String message) {
            }
        });
    }

    private static class MessageReceiver
    implements Runnable {
        private MessageReceiver() {
        }

        @Override
        public void run() {
            while (!receiver.isClosed()) {
                try {
                    DatagramPacket p = MessageServer.receive();
                    MessageReceived msg = new MessageReceived(p);
                    MessageQueue.RECEIVER.get().enqueue(msg);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

