/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.web.polling;

import com.kingdee.bos.qing.common.framework.manage.ClientCallManager;
import com.kingdee.bos.qing.common.framework.model.server.AbstractServerMessage;
import com.kingdee.bos.qing.common.framework.model.server.AbstractServerMessageForClient;
import com.kingdee.bos.qing.common.framework.web.IServerMessageSender;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServerMessageSender4Polling
implements IServerMessageSender {
    private List<AbstractServerMessage> messages = new ArrayList<AbstractServerMessage>();
    private AtomicBoolean isPacking = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(AbstractServerMessage message) {
        if (message == null) {
            return;
        }
        AtomicBoolean atomicBoolean = this.isPacking;
        synchronized (atomicBoolean) {
            if (!this.isPacking.get()) {
                this.messages.add(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] packMessages() {
        StringBuilder stringBuilder = new StringBuilder("[");
        AtomicBoolean atomicBoolean = this.isPacking;
        synchronized (atomicBoolean) {
            this.isPacking.set(true);
            for (AbstractServerMessage message : this.messages) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(",");
                }
                if (message instanceof AbstractServerMessageForClient) {
                    AbstractServerMessageForClient serverMessageForClient = (AbstractServerMessageForClient)message;
                    String clientID = serverMessageForClient.getClientID();
                    String callID = serverMessageForClient.getCallID();
                    ClientCallManager.setCallFinish(clientID, callID);
                }
                stringBuilder.append(message.toJson());
            }
        }
        stringBuilder = stringBuilder.append("]");
        try {
            return stringBuilder.toString().getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.error(e.getMessage(), e);
            return null;
        }
    }
}

